/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.rest.client.impl.log;

import com.appdynamics.voltron.rest.client.impl.log.SimRegistrationRepLogger;
import com.appdynamics.voltron.rest.client.impl.log.SimRegistrationRepLoggerMessageLimit;
import com.appdynamics.voltron.rest.client.impl.log.SimRegistrationRepetitiveLogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimRegistrationRepLoggerModule
extends AbstractModule {
    private static final Logger log = LoggerFactory.getLogger(SimRegistrationRepLoggerModule.class);
    @VisibleForTesting
    static final long DEFAULT_MESSAGE_LIMIT = 1L;
    @VisibleForTesting
    static final long DEFAULT_CACHE_EXPIRY_TIME_MINS = 240L;
    @VisibleForTesting
    static final int DEFAULT_CACHE_SIZE = 1000;
    private static final String REGISTRATION_REPETITIVE_LOGGER_TURNOVER_TIME_MINUTES = "appdynamics.machine.agent.registration.repetitive.logger.turnoverTimeInMinutes";
    private static final String REGISTRATION_REPETITIVE_LOGGER_MESSAGE_LIMIT = "appdynamics.machine.agent.registration.repetitive.logger.messageLimit";
    private static final String REGISTRATION_REPETITIVE_LOGGER_MAX_CACHE_SIZE = "appdynamics.machine.agent.registration.repetitive.logger.maxCacheSize";
    private LoadingCache<String, AtomicLong> messageCache;

    protected void configure() {
        this.bind(SimRegistrationRepetitiveLogger.class).in(Singleton.class);
    }

    @Provides
    @Singleton
    @SimRegistrationRepLogger
    @VisibleForTesting
    LoadingCache<String, AtomicLong> provideCache() {
        long turnoverTime = (Long)this.getTurnoverTimeMins().get();
        log.info("The turnover time for the SIM Registration repetitive logger is {} minutes", (Object)turnoverTime);
        int maxCacheSize = this.getCacheSize();
        log.info("The cache size for the SIM Registration repetitive logger is {}", (Object)maxCacheSize);
        this.messageCache = CacheBuilder.newBuilder().expireAfterWrite(turnoverTime, TimeUnit.MINUTES).maximumSize((long)maxCacheSize).build((CacheLoader)new CacheLoader<String, AtomicLong>(){

            public AtomicLong load(String key) throws Exception {
                return new AtomicLong(0L);
            }
        });
        return this.messageCache;
    }

    @Provides
    @Singleton
    @SimRegistrationRepLogger
    @VisibleForTesting
    Supplier<Long> getTurnoverTimeMins() {
        return new Supplier<Long>(){

            public Long get() {
                return SimRegistrationRepLoggerModule.getLongProperty(SimRegistrationRepLoggerModule.REGISTRATION_REPETITIVE_LOGGER_TURNOVER_TIME_MINUTES, 240L);
            }
        };
    }

    @Provides
    @Singleton
    @SimRegistrationRepLoggerMessageLimit
    @VisibleForTesting
    Supplier<Long> getMessageLimit() {
        return new Supplier<Long>(){

            public Long get() {
                return SimRegistrationRepLoggerModule.getLongProperty(SimRegistrationRepLoggerModule.REGISTRATION_REPETITIVE_LOGGER_MESSAGE_LIMIT, 1L);
            }
        };
    }

    @VisibleForTesting
    int getCacheSize() {
        return SimRegistrationRepLoggerModule.getIntProperty(REGISTRATION_REPETITIVE_LOGGER_MAX_CACHE_SIZE, 1000);
    }

    public static long getLongProperty(String propName, long def) {
        return Long.parseLong(System.getProperty(propName, String.valueOf(def)));
    }

    public static int getIntProperty(String propName, int def) {
        return Integer.parseInt(System.getProperty(propName, String.valueOf(def)));
    }
}

