/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.rest.client.impl.apache;

import com.appdynamics.voltron.rest.client.impl.apache.ApacheFeignClient;
import com.google.inject.Inject;
import java.io.IOException;
import javax.annotation.PreDestroy;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ManagedHttpClient
implements HttpClient {
    private static final Logger log = LoggerFactory.getLogger(ManagedHttpClient.class);
    private final CloseableHttpClient delegate;

    @Inject
    private ManagedHttpClient(@ApacheFeignClient CloseableHttpClient delegate) {
        this.delegate = delegate;
    }

    public HttpParams getParams() {
        return this.delegate.getParams();
    }

    public ClientConnectionManager getConnectionManager() {
        return this.delegate.getConnectionManager();
    }

    public HttpResponse execute(HttpUriRequest request) throws IOException, ClientProtocolException {
        log.debug("Executing request: {}", (Object)request.getRequestLine());
        try {
            return this.delegate.execute(request);
        }
        catch (Exception e) {
            log.error("Request failed with exception", (Throwable)e);
            log.debug("Printing error stacktrace", (Throwable)e);
            throw e;
        }
    }

    public HttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException, ClientProtocolException {
        log.debug("Executing request: {}", (Object)request.getRequestLine());
        try {
            return this.delegate.execute(request, context);
        }
        catch (Exception e) {
            log.error("Request failed with exception", (Throwable)e);
            log.debug("Printing error stacktrace", (Throwable)e);
            throw e;
        }
    }

    public HttpResponse execute(HttpHost target, HttpRequest request) throws IOException, ClientProtocolException {
        log.debug("Executing request: {}", (Object)request.getRequestLine());
        try {
            return this.delegate.execute(target, request);
        }
        catch (Exception e) {
            log.error("Request failed with exception", (Throwable)e);
            log.debug("Printing error stacktrace", (Throwable)e);
            throw e;
        }
    }

    public HttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        log.debug("Executing request: {}", (Object)request.getRequestLine());
        try {
            return this.delegate.execute(target, request, context);
        }
        catch (Exception e) {
            log.error("Request failed with exception", (Throwable)e);
            log.debug("Printing error stacktrace", (Throwable)e);
            throw e;
        }
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        log.debug("Executing request: {}", (Object)request.getRequestLine());
        try {
            return (T)this.delegate.execute(request, responseHandler);
        }
        catch (Exception e) {
            log.error("Request failed with exception", (Throwable)e);
            log.debug("Printing error stacktrace", (Throwable)e);
            throw e;
        }
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        log.debug("Before Executing request: {}", (Object)request.getRequestLine());
        try {
            return (T)this.delegate.execute(request, responseHandler, context);
        }
        catch (Exception e) {
            log.error("Request failed with exception", (Throwable)e);
            log.debug("Printing error stacktrace", (Throwable)e);
            throw e;
        }
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        log.debug("Executing request: {}", (Object)request.getRequestLine());
        try {
            return (T)this.delegate.execute(target, request, responseHandler);
        }
        catch (Exception e) {
            log.error("Request failed with exception", (Throwable)e);
            log.debug("Printing error stacktrace", (Throwable)e);
            throw e;
        }
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        log.debug("Executing request: {}", (Object)request.getRequestLine());
        try {
            return (T)this.delegate.execute(target, request, responseHandler, context);
        }
        catch (Exception e) {
            log.error("Request failed with exception", (Throwable)e);
            log.debug("Printing error stacktrace", (Throwable)e);
            throw e;
        }
    }

    @PreDestroy
    private void close() {
        try {
            this.delegate.close();
        }
        catch (IOException e) {
            log.warn("Failed to close HTTP client.", (Throwable)e);
        }
    }
}

