/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.rest.client.impl.apache;

import lombok.NonNull;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;

public class AuthInfo {
    private final AuthScope authScope;
    private final AuthScheme authScheme;
    private final Credentials credentials;
    private final boolean preemptive;
    private final String hostScheme;

    public AuthInfo(@NonNull AuthScope authScope, @NonNull AuthScheme authScheme, @NonNull Credentials credentials, boolean preemptive) {
        this(authScope, authScheme, credentials, preemptive, false);
        if (authScope == null) {
            throw new NullPointerException("authScope is marked non-null but is null");
        }
        if (authScheme == null) {
            throw new NullPointerException("authScheme is marked non-null but is null");
        }
        if (credentials == null) {
            throw new NullPointerException("credentials is marked non-null but is null");
        }
    }

    public AuthInfo(@NonNull AuthScope authScope, @NonNull AuthScheme authScheme, @NonNull Credentials credentials, boolean preemptive, boolean isHttps) {
        if (authScope == null) {
            throw new NullPointerException("authScope is marked non-null but is null");
        }
        if (authScheme == null) {
            throw new NullPointerException("authScheme is marked non-null but is null");
        }
        if (credentials == null) {
            throw new NullPointerException("credentials is marked non-null but is null");
        }
        if (preemptive && !authScheme.isComplete()) {
            throw new IllegalArgumentException("The authentication scheme has to appear complete. See for example PreemptiveBasicAuthScheme.");
        }
        this.authScope = authScope;
        this.authScheme = authScheme;
        this.credentials = credentials;
        this.preemptive = preemptive;
        this.hostScheme = isHttps ? "https" : "http";
    }

    public AuthScope getAuthScope() {
        return this.authScope;
    }

    public AuthScheme getAuthScheme() {
        return this.authScheme;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public boolean isPreemptive() {
        return this.preemptive;
    }

    public String getHostScheme() {
        return this.hostScheme;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthInfo)) {
            return false;
        }
        AuthInfo other = (AuthInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPreemptive() != other.isPreemptive()) {
            return false;
        }
        AuthScope this$authScope = this.getAuthScope();
        AuthScope other$authScope = other.getAuthScope();
        if (this$authScope == null ? other$authScope != null : !this$authScope.equals(other$authScope)) {
            return false;
        }
        AuthScheme this$authScheme = this.getAuthScheme();
        AuthScheme other$authScheme = other.getAuthScheme();
        if (this$authScheme == null ? other$authScheme != null : !this$authScheme.equals(other$authScheme)) {
            return false;
        }
        Credentials this$credentials = this.getCredentials();
        Credentials other$credentials = other.getCredentials();
        if (this$credentials == null ? other$credentials != null : !this$credentials.equals(other$credentials)) {
            return false;
        }
        String this$hostScheme = this.getHostScheme();
        String other$hostScheme = other.getHostScheme();
        return !(this$hostScheme == null ? other$hostScheme != null : !this$hostScheme.equals(other$hostScheme));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuthInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPreemptive() ? 79 : 97);
        AuthScope $authScope = this.getAuthScope();
        result = result * 59 + ($authScope == null ? 43 : $authScope.hashCode());
        AuthScheme $authScheme = this.getAuthScheme();
        result = result * 59 + ($authScheme == null ? 43 : $authScheme.hashCode());
        Credentials $credentials = this.getCredentials();
        result = result * 59 + ($credentials == null ? 43 : $credentials.hashCode());
        String $hostScheme = this.getHostScheme();
        result = result * 59 + ($hostScheme == null ? 43 : $hostScheme.hashCode());
        return result;
    }

    public String toString() {
        return "AuthInfo(authScope=" + String.valueOf(this.getAuthScope()) + ", authScheme=" + String.valueOf(this.getAuthScheme()) + ", credentials=" + String.valueOf(this.getCredentials()) + ", preemptive=" + this.isPreemptive() + ", hostScheme=" + this.getHostScheme() + ")";
    }
}

