/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.rest.client.impl.apache;

import com.appdynamics.voltron.rest.client.ProxyConfig;
import com.appdynamics.voltron.rest.client.VoltronFeign;
import com.appdynamics.voltron.rest.client.impl.apache.ApacheClientImpl;
import com.appdynamics.voltron.rest.client.impl.apache.ApacheFeignClient;
import com.appdynamics.voltron.rest.client.impl.apache.ApacheProxy;
import com.appdynamics.voltron.rest.client.impl.apache.AuthInfo;
import com.appdynamics.voltron.rest.client.impl.apache.ConnectionCleanerConfig;
import com.appdynamics.voltron.rest.client.impl.apache.ConnectionCleanerTask;
import com.appdynamics.voltron.rest.client.impl.apache.ConnectionManagerConfig;
import com.appdynamics.voltron.rest.client.impl.apache.ManagedHttpClient;
import com.appdynamics.voltron.rest.client.impl.apache.PreemptiveBasicAuthScheme;
import com.appdynamics.voltron.rest.client.impl.log.SimRegistrationRepLoggerModule;
import com.appdynamics.voltron.utils.ManagedScheduledExecutorService;
import com.appdynamics.voltron.utils.annotations.Delegate;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.PrivateModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.multibindings.Multibinder;
import feign.Client;
import feign.Request;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.DefaultRoutePlanner;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class ApacheClientModule
extends PrivateModule {
    private static final long DEFAULT_CLEANER_SHUTDOWN_TIMEOUT = 10000L;
    private static final long DEFAULT_CLEANER_INTERVAL = 30000L;
    private static final long DEFAULT_CLEANER_IDLE_CONN_TIMEOUT = 120000L;
    private final Key<Client> clientKey;

    public ApacheClientModule(Key<Client> clientKey) {
        this.clientKey = clientKey;
    }

    protected final void configure() {
        this.configureScheduledExecutorService((LinkedBindingBuilder<ScheduledExecutorService>)this.bind(ScheduledExecutorService.class).annotatedWith(ApacheFeignClient.class));
        this.configureConnectionCleaner((LinkedBindingBuilder<ConnectionCleanerConfig>)this.bind(ConnectionCleanerConfig.class).annotatedWith(ApacheFeignClient.class));
        this.configureConnectionManager((LinkedBindingBuilder<ConnectionManagerConfig>)this.bind(ConnectionManagerConfig.class).annotatedWith(ApacheFeignClient.class));
        this.configureAuth((Multibinder<AuthInfo>)Multibinder.newSetBinder((Binder)this.binder(), AuthInfo.class, Delegate.class));
        this.bind(HttpClient.class).annotatedWith(ApacheFeignClient.class).to(ManagedHttpClient.class).in(Singleton.class);
        this.bind(ConnectionCleanerTask.class).asEagerSingleton();
        this.install((Module)new SimRegistrationRepLoggerModule());
        this.bind(this.clientKey).to(ApacheClientImpl.class);
        this.expose(this.clientKey);
    }

    @ApacheProxy
    @Provides
    private Optional<AuthInfo> provideProxyAuthInfo(@VoltronFeign Optional<ProxyConfig> proxyConfigOptional) {
        if (!proxyConfigOptional.isPresent()) {
            return Optional.absent();
        }
        ProxyConfig proxyConfig = (ProxyConfig)proxyConfigOptional.get();
        if (!proxyConfig.getAuth().isPresent()) {
            return Optional.absent();
        }
        ProxyConfig.Auth auth = (ProxyConfig.Auth)proxyConfig.getAuth().get();
        PreemptiveBasicAuthScheme scheme = auth.isPreemptiveAuth() ? PreemptiveBasicAuthScheme.forProxy() : new BasicScheme();
        return Optional.of((Object)new AuthInfo(new AuthScope(proxyConfig.getHostname(), proxyConfig.getPort()), (AuthScheme)scheme, (Credentials)new UsernamePasswordCredentials(auth.getUsername(), auth.getPassword()), auth.isPreemptiveAuth()));
    }

    @ApacheProxy
    @Provides
    private Optional<HttpHost> provideProxyHost(@VoltronFeign Optional<ProxyConfig> proxyConfigOptional) {
        if (!proxyConfigOptional.isPresent()) {
            return Optional.absent();
        }
        return Optional.of((Object)new HttpHost(((ProxyConfig)proxyConfigOptional.get()).getHostname(), ((ProxyConfig)proxyConfigOptional.get()).getPort()));
    }

    @Singleton
    @Provides
    private Set<AuthInfo> provideAuthInfoSet(@Delegate Set<AuthInfo> multibinderAuthInfo, @ApacheProxy Optional<AuthInfo> proxyAuthInfo) {
        return ImmutableSet.builder().addAll(multibinderAuthInfo).addAll((Iterable)proxyAuthInfo.asSet()).build();
    }

    @ApacheFeignClient
    @Provides
    private AuthCache provideAuthCache(Set<AuthInfo> authInfoSet) {
        BasicAuthCache authCache = new BasicAuthCache();
        for (AuthInfo authInfo : authInfoSet) {
            if (!authInfo.isPreemptive()) continue;
            HttpHost host = new HttpHost(authInfo.getAuthScope().getHost(), authInfo.getAuthScope().getPort(), authInfo.getHostScheme());
            authCache.put(host, authInfo.getAuthScheme());
        }
        return authCache;
    }

    @ApacheFeignClient
    @Provides
    private CredentialsProvider provideCredentialsProvider(Set<AuthInfo> authInfoSet) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        for (AuthInfo authInfo : authInfoSet) {
            credentialsProvider.setCredentials(authInfo.getAuthScope(), authInfo.getCredentials());
        }
        return credentialsProvider;
    }

    @ApacheFeignClient
    @Provides
    private HttpRoutePlanner provideRoutePlanner(@ApacheProxy Optional<HttpHost> proxyHost) {
        if (proxyHost.isPresent()) {
            return new DefaultProxyRoutePlanner((HttpHost)proxyHost.get());
        }
        return new DefaultRoutePlanner((SchemePortResolver)new DefaultSchemePortResolver());
    }

    @ApacheFeignClient
    @Provides
    private Registry<ConnectionSocketFactory> provideConnectionSocketFactoryRegistry(@VoltronFeign Optional<HostnameVerifier> optionalHostnameVerifier, @VoltronFeign Optional<SSLContext> optionalSslContext) {
        RegistryBuilder registryBuilder = RegistryBuilder.create();
        registryBuilder.register("http", (Object)new PlainConnectionSocketFactory());
        if (optionalSslContext.isPresent()) {
            SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory((SSLContext)optionalSslContext.get(), (HostnameVerifier)optionalHostnameVerifier.orNull());
            registryBuilder.register("https", (Object)sslConnectionSocketFactory);
        }
        return registryBuilder.build();
    }

    @ApacheFeignClient
    @Provides
    @Singleton
    private HttpClientConnectionManager provideConnectionManager(@ApacheFeignClient Registry<ConnectionSocketFactory> connectionSocketFactoryRegistry, @ApacheFeignClient ConnectionManagerConfig config) {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(connectionSocketFactoryRegistry);
        connectionManager.setDefaultMaxPerRoute(config.getMaxConnectionsPerRoute());
        connectionManager.setMaxTotal(config.getMaxConnectionsTotal());
        return connectionManager;
    }

    @Provides
    @Singleton
    @ApacheFeignClient
    private CloseableHttpClient provideHttpClient(@VoltronFeign Request.Options options, @ApacheFeignClient CredentialsProvider credentialsProvider, @ApacheFeignClient HttpRoutePlanner httpRoutePlanner, @ApacheFeignClient HttpClientConnectionManager connectionManager) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(options.connectTimeoutMillis()).setSocketTimeout(options.readTimeoutMillis()).build();
        return HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setDefaultCredentialsProvider(credentialsProvider).setRoutePlanner(httpRoutePlanner).setConnectionManager(connectionManager).build();
    }

    protected void configureConnectionCleaner(LinkedBindingBuilder<ConnectionCleanerConfig> bind) {
        bind.toInstance((Object)new ConnectionCleanerConfig(30000L, 120000L));
    }

    protected void configureScheduledExecutorService(LinkedBindingBuilder<ScheduledExecutorService> bindExecutor) {
        bindExecutor.toInstance((Object)new ManagedScheduledExecutorService(){

            protected ScheduledExecutorService createDelegate() {
                return Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("connection-cleaner").build());
            }

            protected TimeUnit getTimeUnit() {
                return TimeUnit.MILLISECONDS;
            }

            protected long getShutdownTimeout() {
                return 10000L;
            }

            public String toString() {
                return "ConnectionCleanerScheduledExecutorService";
            }
        });
    }

    protected void configureConnectionManager(LinkedBindingBuilder<ConnectionManagerConfig> bind) {
        bind.toInstance((Object)new ConnectionManagerConfig(4, 20));
    }

    protected void configureAuth(Multibinder<AuthInfo> authInfoMultibinder) {
    }
}

