/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.rest.client;

import com.appdynamics.voltron.rest.client.FeignClientBuilderModule;
import com.appdynamics.voltron.rest.client.FeignServiceFactory;
import com.appdynamics.voltron.rest.client.RestClientPath;
import com.appdynamics.voltron.rest.client.RestClientProvider;
import com.google.common.base.Optional;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.PrivateModule;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.binder.LinkedBindingBuilder;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public abstract class FeignClientServicesModule
extends AbstractModule {
    private final List<ClientService<?>> services;
    private final String clientName;

    public FeignClientServicesModule(@NonNull String clientName) {
        if (clientName == null) {
            throw new NullPointerException("clientName is marked non-null but is null");
        }
        this.clientName = clientName;
        this.services = new ArrayList();
    }

    protected final void configure() {
        this.configureServices();
        for (ClientService<?> service : this.services) {
            this.install((Module)service);
        }
    }

    protected abstract void configureServices();

    protected final <T> ClientPathBindingBuilder serve(@NonNull Class<T> restInterface) {
        if (restInterface == null) {
            throw new NullPointerException("restInterface is marked non-null but is null");
        }
        ClientService<T> service = new ClientService<T>(restInterface, this.clientName);
        this.services.add(service);
        return service;
    }

    private static class ClientService<T>
    extends PrivateModule
    implements ClientPathBindingBuilder {
        private static final String EMPTY_PATH = "";
        private final Class<T> restInterface;
        private final String clientName;
        private Optional<? extends Module> servicePathProviderModule;

        private ClientService(@NonNull Class<T> restInterface, @NonNull String clientName) {
            if (restInterface == null) {
                throw new NullPointerException("restInterface is marked non-null but is null");
            }
            if (clientName == null) {
                throw new NullPointerException("clientName is marked non-null but is null");
            }
            this.restInterface = restInterface;
            this.clientName = clientName;
            this.servicePathProviderModule = Optional.absent();
        }

        private static LinkedBindingBuilder<String> bindRestClientPath(Binder binder) {
            return binder.bind(String.class).annotatedWith(RestClientPath.class);
        }

        @Override
        public void fromPath(final String path) {
            this.servicePathProviderModule = Optional.of((Object)new Module(){

                public void configure(Binder binder) {
                    ClientService.bindRestClientPath(binder).toInstance((Object)path);
                }
            });
        }

        @Override
        public void fromPathByProvider(final Class<? extends Provider<String>> pathProviderClass) {
            this.servicePathProviderModule = Optional.of((Object)new Module(){

                public void configure(Binder binder) {
                    ClientService.bindRestClientPath(binder).toProvider(pathProviderClass);
                }
            });
        }

        @Override
        public void fromPathByProvider(final Provider<String> pathProvider) {
            this.servicePathProviderModule = Optional.of((Object)new Module(){

                public void configure(Binder binder) {
                    ClientService.bindRestClientPath(binder).toProvider(pathProvider);
                }
            });
        }

        protected void configure() {
            this.bind(FeignServiceFactory.class).to(FeignClientBuilderModule.getServiceFactoryKeyForClient(this.clientName));
            RestClientProvider<T> restInterfaceProvider = new RestClientProvider<T>(this.restInterface);
            this.requestInjection(restInterfaceProvider);
            this.bind(this.restInterface).toProvider(restInterfaceProvider).in(Scopes.SINGLETON);
            if (this.servicePathProviderModule.isPresent()) {
                this.install((Module)this.servicePathProviderModule.get());
            } else {
                ClientService.bindRestClientPath((Binder)this.binder()).toInstance((Object)EMPTY_PATH);
            }
            this.expose(this.restInterface);
        }
    }

    public static interface ClientPathBindingBuilder {
        public void fromPath(String var1);

        public void fromPathByProvider(Class<? extends Provider<String>> var1);

        public void fromPathByProvider(Provider<String> var1);
    }
}

