/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.rest.client;

import com.appdynamics.voltron.rest.client.DefaultFeignServiceFactory;
import com.appdynamics.voltron.rest.client.FeignBuilderProvider;
import com.appdynamics.voltron.rest.client.FeignServiceFactory;
import com.appdynamics.voltron.rest.client.Jackson;
import com.appdynamics.voltron.rest.client.ProxyConfig;
import com.appdynamics.voltron.rest.client.RestClientBaseUrl;
import com.appdynamics.voltron.rest.client.VoltronErrorDecoder;
import com.appdynamics.voltron.rest.client.VoltronFeign;
import com.appdynamics.voltron.rest.client.VoltronFeignGzip;
import com.appdynamics.voltron.rest.client.VoltronRetryer;
import com.appdynamics.voltron.rest.client.impl.urlconn.UrlConnectionClientModule;
import com.appdynamics.voltron.rest.client.ssl.FeignSslClientModule;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.PrivateModule;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.Request;
import feign.RequestInterceptor;
import feign.Retryer;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.jaxrs.JAXRSContract;
import feign.slf4j.Slf4jLogger;
import java.lang.annotation.Annotation;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import lombok.NonNull;

public abstract class FeignClientBuilderModule
extends PrivateModule {
    private static final long DEFAULT_INITIAL_RETRY_PERIOD = TimeUnit.MILLISECONDS.toMillis(100L);
    private static final long DEFAULT_MAX_RETRY_PERIOD = TimeUnit.SECONDS.toMillis(1L);
    @VisibleForTesting
    protected static final int DEFAULT_MAX_RETRIES = 5;
    private static final long DEFAULT_CONNECT_TIMEOUT = TimeUnit.SECONDS.toMillis(20L);
    private static final long DEFAULT_READ_TIMEOUT = TimeUnit.SECONDS.toMillis(120L);
    private Multibinder<RequestInterceptor> requestInterceptorsBinder;
    private String clientName;

    public FeignClientBuilderModule(@NonNull String clientName) {
        if (clientName == null) {
            throw new NullPointerException("clientName is marked non-null but is null");
        }
        this.clientName = clientName;
    }

    protected final void configure() {
        this.requestInterceptorsBinder = Multibinder.newSetBinder((Binder)this.binder(), RequestInterceptor.class, VoltronFeign.class);
        this.configureObjectMapper((LinkedBindingBuilder<ObjectMapper>)this.bind(ObjectMapper.class).annotatedWith(VoltronFeign.class));
        this.bind(Contract.class).annotatedWith(VoltronFeign.class).to(JAXRSContract.class);
        this.bind(Slf4jLogger.class).annotatedWith(VoltronFeign.class).toInstance((Object)new Slf4jLogger());
        this.configureErrorDecoder((LinkedBindingBuilder<ErrorDecoder>)this.bind(ErrorDecoder.class).annotatedWith(VoltronFeign.class));
        this.configureEncoder((LinkedBindingBuilder<Encoder>)this.bind(Encoder.class).annotatedWith(VoltronFeign.class));
        this.configureDecoder((LinkedBindingBuilder<Decoder>)this.bind(Decoder.class).annotatedWith(VoltronFeign.class));
        this.configureRetryer((LinkedBindingBuilder<Retryer>)this.bind(Retryer.class).annotatedWith(VoltronFeign.class));
        this.configureOptions((LinkedBindingBuilder<Request.Options>)this.bind(Request.Options.class).annotatedWith(VoltronFeign.class));
        this.configureGzipCompression((LinkedBindingBuilder<Boolean>)this.bind(Boolean.TYPE).annotatedWith(VoltronFeignGzip.class));
        this.install(this.buildSslModule((Key<Optional<HostnameVerifier>>)Key.get((TypeLiteral)new TypeLiteral<Optional<HostnameVerifier>>(){}, VoltronFeign.class), (Key<Optional<SSLContext>>)Key.get((TypeLiteral)new TypeLiteral<Optional<SSLContext>>(){}, VoltronFeign.class)));
        this.install(this.buildClientImplModule((Key<Client>)Key.get(Client.class, VoltronFeign.class)));
        this.configureProxy((LinkedBindingBuilder<Optional<ProxyConfig>>)this.bind((TypeLiteral)new TypeLiteral<Optional<ProxyConfig>>(){}).annotatedWith(VoltronFeign.class));
        this.configureClientBuilder();
        this.configureBaseUrl((LinkedBindingBuilder<String>)this.bind(String.class).annotatedWith(RestClientBaseUrl.class));
        this.configureFeignBuilderProvider((LinkedBindingBuilder<Feign.Builder>)this.bind(Feign.Builder.class).annotatedWith(VoltronFeign.class));
        Key<FeignServiceFactory> serviceFactoryKey = FeignClientBuilderModule.getServiceFactoryKeyForClient(this.clientName);
        this.configureServiceFactory((LinkedBindingBuilder<FeignServiceFactory>)this.bind(serviceFactoryKey));
        this.expose(serviceFactoryKey);
    }

    protected Module buildClientImplModule(Key<Client> clientKey) {
        return new UrlConnectionClientModule(clientKey);
    }

    protected void configureEncoder(LinkedBindingBuilder<Encoder> bindEncoder) {
        bindEncoder.toProvider(Jackson.JacksonEncoderProvider.class);
    }

    protected void configureErrorDecoder(LinkedBindingBuilder<ErrorDecoder> bindDecoder) {
        bindDecoder.to(VoltronErrorDecoder.class);
    }

    protected void configureDecoder(LinkedBindingBuilder<Decoder> bindDecoder) {
        bindDecoder.toProvider(Jackson.JacksonDecoderProvider.class);
    }

    protected void configureObjectMapper(LinkedBindingBuilder<ObjectMapper> bindObjectMapper) {
        bindObjectMapper.to(ObjectMapper.class).in(Scopes.SINGLETON);
    }

    protected void configureClientBuilder() {
    }

    protected abstract void configureBaseUrl(LinkedBindingBuilder<String> var1);

    protected void configureServiceFactory(LinkedBindingBuilder<FeignServiceFactory> bind) {
        bind.to(DefaultFeignServiceFactory.class).in(Scopes.SINGLETON);
    }

    protected void configureFeignBuilderProvider(LinkedBindingBuilder<Feign.Builder> bind) {
        bind.toProvider(FeignBuilderProvider.class).in(Scopes.SINGLETON);
    }

    protected final LinkedBindingBuilder<RequestInterceptor> addRequestInterceptor() {
        return this.requestInterceptorsBinder.addBinding();
    }

    protected void configureGzipCompression(LinkedBindingBuilder<Boolean> bindGzipEnabled) {
        bindGzipEnabled.toInstance((Object)Boolean.FALSE);
    }

    protected void configureRetryer(LinkedBindingBuilder<Retryer> bind) {
        bind.toInstance((Object)VoltronRetryer.createWithDefaultRetryer(DEFAULT_INITIAL_RETRY_PERIOD, DEFAULT_MAX_RETRY_PERIOD, 5));
    }

    protected void configureOptions(LinkedBindingBuilder<Request.Options> bind) {
        bind.toInstance((Object)new Request.Options((int)DEFAULT_CONNECT_TIMEOUT, (int)DEFAULT_READ_TIMEOUT));
    }

    protected Module buildSslModule(Key<Optional<HostnameVerifier>> hostnameVerifierKey, Key<Optional<SSLContext>> sslContextKey) {
        return new FeignSslClientModule(hostnameVerifierKey, sslContextKey);
    }

    protected void configureProxy(LinkedBindingBuilder<Optional<ProxyConfig>> bind) {
        bind.toInstance((Object)Optional.absent());
    }

    public static Key<FeignServiceFactory> getServiceFactoryKeyForClient(String clientName) {
        return Key.get(FeignServiceFactory.class, (Annotation)Names.named((String)clientName));
    }
}

