/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.netflix.config.DynamicProperty;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;

public class DefaultContextualPredicate
implements Predicate<Map<String, Collection<String>>> {
    private final Function<String, String> getValueFromKeyFunction;
    public static final DefaultContextualPredicate PROPERTY_BASED = new DefaultContextualPredicate(new Function<String, String>(){

        @SuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"})
        public String apply(@Nullable String input) {
            return DynamicProperty.getInstance(input).getString();
        }
    });

    public DefaultContextualPredicate(Function<String, String> getValueFromKeyFunction) {
        this.getValueFromKeyFunction = getValueFromKeyFunction;
    }

    @SuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"})
    public boolean apply(@Nullable Map<String, Collection<String>> input) {
        if (null == input) {
            throw new NullPointerException();
        }
        for (Map.Entry<String, Collection<String>> entry : input.entrySet()) {
            String key = entry.getKey();
            Collection<String> value = entry.getValue();
            if (value.contains(this.getValueFromKeyFunction.apply((Object)key))) continue;
            return false;
        }
        return true;
    }
}

