/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.rest.utils;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import lombok.NonNull;

public class StringParsing {
    private static final Splitter COMMA_SEPARATED_SPLITTER = Splitter.on((String)",").trimResults().omitEmptyStrings();

    public static Set<Long> convertStringIdsToSetIds(@NonNull String ids) {
        if (ids == null) {
            throw new NullPointerException("ids is marked non-null but is null");
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String machineId : COMMA_SEPARATED_SPLITTER.split((CharSequence)ids)) {
            builder.add((Object)Long.valueOf(machineId));
        }
        return builder.build();
    }

    public static Set<String> convertStringsToSetStrings(@NonNull String tokens) {
        if (tokens == null) {
            throw new NullPointerException("tokens is marked non-null but is null");
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String token : COMMA_SEPARATED_SPLITTER.split((CharSequence)tokens)) {
            builder.add((Object)token);
        }
        return builder.build();
    }

    public static String convertCollectionIdsToStringIds(@NonNull Collection<Long> ids) {
        if (ids == null) {
            throw new NullPointerException("ids is marked non-null but is null");
        }
        StringBuilder sb = new StringBuilder();
        Iterator<Long> it = ids.iterator();
        if (it.hasNext()) {
            sb.append(String.valueOf(it.next()));
        }
        while (it.hasNext()) {
            sb.append(",");
            sb.append(String.valueOf(it.next()));
        }
        return sb.toString();
    }

    public static List<Long> convertStringDataToList(@NonNull String ids) {
        if (ids == null) {
            throw new NullPointerException("ids is marked non-null but is null");
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String id : COMMA_SEPARATED_SPLITTER.split((CharSequence)ids)) {
            builder.add((Object)Long.valueOf(id));
        }
        return builder.build();
    }
}

