/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.rest.utils;

import com.appdynamics.voltron.rest.utils.RestException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Supplier;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class RestExceptionMapper
implements ExceptionMapper<Exception> {
    private static final Logger log = LoggerFactory.getLogger(RestExceptionMapper.class);
    private final Supplier<Boolean> includeExceptionSupplier;

    public final Response toResponse(Exception exception) {
        if (!(exception instanceof RestException)) {
            if (exception instanceof WebApplicationException) {
                WebApplicationException webExc = (WebApplicationException)exception;
                Response response = webExc.getResponse();
                String msg = exception.getMessage();
                if ((msg == null || msg.length() == 0) && response.getEntity() != null) {
                    msg = response.getEntity().toString();
                } else if (msg == null) {
                    msg = "Unknown error";
                }
                RestException restException = new RestException(webExc.getResponse().getStatus(), "UNKNOWN_WEB_EXCEPTION", msg, exception, (boolean)((Boolean)this.includeExceptionSupplier.get()));
                return restException.getResponse();
            }
            if (exception instanceof JsonProcessingException) {
                RestException restException = new RestException(Response.Status.BAD_REQUEST.getStatusCode(), "BAD_JSON", "The request could not be understood by the server due to malformed syntax. The client SHOULD NOT repeat the request without modifications.", exception, (boolean)((Boolean)this.includeExceptionSupplier.get()));
                return restException.getResponse();
            }
            RestException restException = new RestException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "INTERNAL_ERROR", "An unexpected error occurred", exception, (boolean)((Boolean)this.includeExceptionSupplier.get()));
            return restException.getResponse();
        }
        return ((RestException)exception).getResponse();
    }

    public RestExceptionMapper(Supplier<Boolean> includeExceptionSupplier) {
        this.includeExceptionSupplier = includeExceptionSupplier;
    }
}

