/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.xml;

import com.appdynamics.javax.xml.parsers.DocumentBuilder;
import com.appdynamics.javax.xml.parsers.ParserConfigurationException;
import com.appdynamics.org.apache.xml.serialize.OutputFormat;
import com.appdynamics.org.apache.xml.serialize.XMLSerializer;
import com.appdynamics.org.w3c.dom.DOMException;
import com.appdynamics.org.w3c.dom.Document;
import com.appdynamics.org.w3c.dom.Element;
import com.appdynamics.org.w3c.dom.Node;
import com.appdynamics.org.w3c.dom.Text;
import com.appdynamics.org.xml.sax.SAXException;
import com.singularity.ee.util.xml.XMLParseUtility;
import com.singularity.ee.util.xml.XMLWriteException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class XMLWriter {
    protected static final String EMPTY_STRING = "";
    private Document xmlDoc;
    private boolean cleanStrings;
    private static final String CHARACTER_ENCODING = "UTF-8";

    public XMLWriter(Document xmlDoc) {
        this.xmlDoc = xmlDoc;
    }

    public XMLWriter() throws ParserConfigurationException {
        DocumentBuilder builder = XMLParseUtility.getDocumentBuilder();
        this.xmlDoc = builder.newDocument();
    }

    public Element createElement(String elementName) {
        return this.xmlDoc.createElement(elementName);
    }

    public Element createElement(String name, Element parent) {
        Element child = this.createElement(name);
        parent.appendChild((Node)child);
        return child;
    }

    public void appendElementFromXmlString(String xmlStr, Element parentElement) throws DOMException, SAXException, IOException, ParserConfigurationException {
        DocumentBuilder builder = XMLParseUtility.getDocumentBuilder();
        xmlStr = this.removeNullChars(xmlStr);
        Element rootEle = builder.parse((InputStream)new ByteArrayInputStream(xmlStr.getBytes(CHARACTER_ENCODING))).getDocumentElement();
        this.xmlDoc.adoptNode((Node)rootEle);
        parentElement.appendChild((Node)rootEle);
    }

    public Document getDocument() {
        return this.xmlDoc;
    }

    public Element addTextNode(Element addToElement, String tagName, boolean text) {
        return this.addTextNode(addToElement, tagName, Boolean.toString(text));
    }

    public Element addTextNode(Element addToElement, String tagName, Enum enumName) {
        return this.addTextNode(addToElement, tagName, enumName.name());
    }

    public Element addTextNode(Element configEle, String tagName, int value) {
        return this.addTextNode(configEle, tagName, String.valueOf(value));
    }

    public Element addTextNode(Element configEle, String tagName, long value) {
        return this.addTextNode(configEle, tagName, String.valueOf(value));
    }

    public Element addTextNode(Element configEle, String tagName, float value) {
        return this.addTextNode(configEle, tagName, String.valueOf(value));
    }

    public Element addTextNode(Element configEle, String tagName, double value) {
        return this.addTextNode(configEle, tagName, String.valueOf(value));
    }

    public Element addTextNode(Element configEle, String tagName, Date date) {
        return this.addTextNode(configEle, tagName, date.getTime());
    }

    public Element addTextNode(Element addToElement, String tagName, String text) {
        text = this.removeNullChars(text);
        Element textNode = this.xmlDoc.createElement(tagName);
        Text scriptText = this.xmlDoc.createTextNode(this.getSafeStringValue(text));
        textNode.appendChild((Node)scriptText);
        addToElement.appendChild((Node)textNode);
        return textNode;
    }

    protected String getSafeStringValue(String value) {
        return value == null ? EMPTY_STRING : value;
    }

    public void addTextNode(Element addToElement, String tagName, Map<String, String> attributes) {
        Element textNode = this.xmlDoc.createElement(tagName);
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String attributeName = entry.getKey();
            String text = entry.getValue();
            text = this.removeNullChars(text);
            textNode.setAttribute(attributeName, text);
        }
        addToElement.appendChild((Node)textNode);
    }

    public void addTextNode(Element addToElement, String tagName, String text, Map<String, String> attributes) {
        Element textNode = this.xmlDoc.createElement(tagName);
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String attributeName = entry.getKey();
            String attributeText = entry.getValue();
            attributeText = this.removeNullChars(attributeText);
            textNode.setAttribute(attributeName, attributeText);
        }
        text = this.removeNullChars(text);
        Text scriptText = this.xmlDoc.createTextNode(text);
        textNode.appendChild((Node)scriptText);
        addToElement.appendChild((Node)textNode);
    }

    public void addTextNodeWithSingleAttribute(Element addToElement, String tagName, String key, String value) {
        value = this.removeNullChars(value);
        Element textNode = this.xmlDoc.createElement(tagName);
        textNode.setAttribute(key, value);
        addToElement.appendChild((Node)textNode);
    }

    private static OutputFormat getOutputFormat() {
        OutputFormat format = new OutputFormat();
        format.setIndenting(true);
        format.setOmitXMLDeclaration(true);
        format.setIndent(4);
        format.setOmitComments(false);
        return format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToFile(String filePath) throws XMLWriteException {
        try (FileOutputStream fos = new FileOutputStream(new File(filePath));){
            XMLSerializer serializer = new XMLSerializer((OutputStream)fos, XMLWriter.getOutputFormat());
            serializer.serialize(this.xmlDoc);
        }
        catch (Exception e) {
            throw new XMLWriteException(e);
        }
    }

    public void logToConsole() throws XMLWriteException {
        try {
            XMLSerializer serializer = new XMLSerializer((OutputStream)System.out, XMLWriter.getOutputFormat());
            serializer.serialize(this.xmlDoc);
        }
        catch (Exception e) {
            throw new XMLWriteException(e);
        }
    }

    public static String getStringRepresentationForElement(Element element) throws XMLWriteException {
        try {
            StringWriter stw = new StringWriter();
            XMLSerializer serializer = new XMLSerializer((Writer)stw, XMLWriter.getOutputFormat());
            serializer.serialize(element);
            return stw.toString();
        }
        catch (Exception e) {
            throw new XMLWriteException(e);
        }
    }

    public static String safeGetStringRepresentationForElement(Element element) {
        try {
            return XMLWriter.getStringRepresentationForElement(element);
        }
        catch (Exception e) {
            e.printStackTrace();
            return EMPTY_STRING;
        }
    }

    public static void saveToFile(Element element, String filePath) throws XMLWriteException {
        XMLWriter.saveToFile(element, new File(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveToFile(Element element, File file) throws XMLWriteException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            XMLSerializer serializer = new XMLSerializer((OutputStream)fos, XMLWriter.getOutputFormat());
            serializer.serialize(element);
        }
        catch (Exception e) {
            throw new XMLWriteException(e);
        }
    }

    public void removeNodeWithTextValueForTag(Element containerNode, String nodeName, String tagName, String text) {
        List<Element> elements = XMLParseUtility.getListOfDirectSiblingsUnderWithName((Node)containerNode, nodeName);
        for (Element element : elements) {
            if (!XMLParseUtility.getTextForTagForElement((Node)element, tagName).equals(text)) continue;
            containerNode.removeChild((Node)element);
        }
    }

    public void removeChildNode(Element containerNode, String childNodeName) {
        Element childNode = XMLParseUtility.getFirstDirectChildUnderWithName((Node)containerNode, childNodeName);
        containerNode.removeChild((Node)childNode);
    }

    public static void main(String[] args) throws Exception {
        XMLWriter writer = new XMLWriter();
        Element el = writer.createElement("root-element");
        HashMap<String, String> attribs = new HashMap<String, String>();
        attribs.put("filter-type", "abcd");
        attribs.put("filter-value", "myval");
        attribs.put("inverse", "true");
        writer.addTextNode(el, "implements-intf", attribs);
        System.out.println(XMLWriter.safeGetStringRepresentationForElement(el));
    }

    private String removeNullChars(String text) {
        if (this.cleanStrings && text != null) {
            return text.replaceAll("\u0000", EMPTY_STRING);
        }
        return text;
    }

    public boolean isCleanStrings() {
        return this.cleanStrings;
    }

    public void setCleanStrings(boolean cleanStrings) {
        this.cleanStrings = cleanStrings;
    }
}

