/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.xml;

import com.appdynamics.javax.xml.parsers.DocumentBuilder;
import com.appdynamics.javax.xml.parsers.ParserConfigurationException;
import com.appdynamics.javax.xml.parsers.SAXParser;
import com.appdynamics.javax.xml.parsers.SAXParserFactory;
import com.appdynamics.org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import com.appdynamics.org.apache.xerces.util.XMLChar;
import com.appdynamics.org.w3c.dom.Document;
import com.appdynamics.org.w3c.dom.Element;
import com.appdynamics.org.w3c.dom.NamedNodeMap;
import com.appdynamics.org.w3c.dom.Node;
import com.appdynamics.org.w3c.dom.NodeList;
import com.appdynamics.org.xml.sax.SAXException;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.xml.XMLParseException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XMLParseUtility {
    public static final int INVALID_INT_VALUE_READ = -1;
    public static final long INVALID_LONG_VALUE_READ = -1L;
    public static final String DEFAULT_PROPERTIES_CONTAINER_TAG_NAME = "properties";
    private static final Pattern pattern = Pattern.compile("[&]");
    private static final String ampEntityRef = "&amp;";
    private static final String LOAD_EXTERNAL_ENTITY = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private static final String[] VALID_ENTITY_REFS = new String[]{"&quot;", "&amp;", "&apos;", "&gt;", "&lt;", "&cent;", "&pound;", "&copy;", "&not;"};
    private static volatile ThreadLocal<DocumentBuilder> perThreadDomBuilders;
    private static volatile ThreadLocal<SAXParser> saxParserThreadLocal;

    public static ThreadLocal<DocumentBuilder> getPerThreadDomBuilders() {
        return perThreadDomBuilders;
    }

    public static void usePerThreadDomBuilders(final ILogger logger) {
        perThreadDomBuilders = new ThreadLocal<DocumentBuilder>(){

            @Override
            protected DocumentBuilder initialValue() {
                try {
                    return XMLParseUtility.newDocumentBuilder();
                }
                catch (ParserConfigurationException e) {
                    logger.warn("Error occurred while creating a new reusable DocumentBuilder");
                    return null;
                }
            }
        };
    }

    static DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactoryImpl factory = new DocumentBuilderFactoryImpl();
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setFeature(LOAD_EXTERNAL_ENTITY, false);
        factory.setXIncludeAware(false);
        factory.setExpandEntityReferences(false);
        return factory.newDocumentBuilder();
    }

    public static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilder builder;
        ThreadLocal<DocumentBuilder> tls = perThreadDomBuilders;
        if (tls != null && (builder = tls.get()) != null) {
            builder.reset();
            return builder;
        }
        return XMLParseUtility.newDocumentBuilder();
    }

    public static void usePerThreadSaxParser(final ILogger logger) {
        saxParserThreadLocal = new ThreadLocal<SAXParser>(){

            @Override
            protected SAXParser initialValue() {
                try {
                    return XMLParseUtility.newSaxParser();
                }
                catch (Exception e) {
                    logger.warn("Error occurred while creating a new reusable DocumentBuilder");
                    return null;
                }
            }
        };
    }

    private static SAXParser newSaxParser() throws ParserConfigurationException, SAXException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(false);
        spf.setValidating(false);
        spf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        spf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        spf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        spf.setXIncludeAware(false);
        return spf.newSAXParser();
    }

    public static SAXParser getSaxParser() throws ParserConfigurationException, SAXException {
        ThreadLocal<SAXParser> tl = saxParserThreadLocal;
        if (tl == null) {
            return XMLParseUtility.newSaxParser();
        }
        SAXParser saxParser = tl.get();
        if (saxParser == null) {
            saxParser = XMLParseUtility.newSaxParser();
        } else {
            saxParser.reset();
        }
        return saxParser;
    }

    public static List<Element> getListOfDirectSiblingsUnderWithName(Node node, String tagName) {
        ArrayList<Element> list = new ArrayList<Element>();
        if (node == null) {
            return list;
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node candidateNode = nodeList.item(i);
            if (!(candidateNode instanceof Element) || !candidateNode.getNodeName().equals(tagName)) continue;
            list.add((Element)candidateNode);
        }
        return list;
    }

    public static List<Element> getListOfDirectSiblingsForNode(Node node) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node candidateNode = nodeList.item(i);
            if (!(candidateNode instanceof Element)) continue;
            list.add((Element)candidateNode);
        }
        return list;
    }

    public static Element getFirstDirectChildUnderWithName(Node node, String tagName) {
        if (node == null) {
            return null;
        }
        NodeList nodelist = node.getChildNodes();
        for (int i = 0; i < nodelist.getLength(); ++i) {
            Node candidateNode = nodelist.item(i);
            if (!(candidateNode instanceof Element) || !candidateNode.getNodeName().equals(tagName)) continue;
            return (Element)candidateNode;
        }
        return null;
    }

    public static Element getFirstDirectChildUnderWithName(Node node, String tagName, String attrName, String attrValue) {
        if (node == null) {
            return null;
        }
        NodeList nodelist = node.getChildNodes();
        for (int i = 0; i < nodelist.getLength(); ++i) {
            Node attrNode;
            Node candidateNode = nodelist.item(i);
            if (!(candidateNode instanceof Element) || !candidateNode.getNodeName().equals(tagName) || (attrNode = candidateNode.getAttributes().getNamedItem(attrName)) == null || !attrNode.getNodeValue().equals(attrValue)) continue;
            return (Element)candidateNode;
        }
        return null;
    }

    public static String[] getListofTextTagValuesForElement(Node rootNode, String elementName, String tagName) {
        Element containerNode = XMLParseUtility.getFirstDirectChildUnderWithName(rootNode, elementName);
        if (containerNode == null) {
            return new String[0];
        }
        return XMLParseUtility.getListofTextTagValuesForElement((Node)containerNode, tagName);
    }

    public static Collection<Element> getListofElements(Node rootNode, String elementName, String tagName) {
        Element containerNode = XMLParseUtility.getFirstDirectChildUnderWithName(rootNode, elementName);
        if (containerNode == null) {
            return Collections.emptyList();
        }
        return XMLParseUtility.getListOfDirectSiblingsUnderWithName((Node)containerNode, tagName);
    }

    public static String[] getListofTextTagValuesForElement(Node containerNode, String tagName) {
        List<Element> elementList = XMLParseUtility.getListOfDirectSiblingsUnderWithName(containerNode, tagName);
        String[] textList = new String[elementList.size()];
        for (int i = 0; i < elementList.size(); ++i) {
            Element element = elementList.get(i);
            textList[i] = element.getTextContent().trim();
        }
        return textList;
    }

    public static Map<String, String> getTextTagValuesForElementAsProperties(Node containerNode) {
        HashMap<String, String> properties = new HashMap<String, String>();
        NodeList nodeList = containerNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node candidateNode = nodeList.item(i);
            if (!(candidateNode instanceof Element)) continue;
            properties.put(candidateNode.getNodeName(), candidateNode.getTextContent().trim());
        }
        return properties;
    }

    public static Properties getPropertiesForElement(Element containerNode, String tagName) {
        Properties properties = new Properties();
        Element propertiesNode = XMLParseUtility.getFirstDirectChildUnderWithName((Node)containerNode, tagName);
        if (propertiesNode == null) {
            return properties;
        }
        List<Element> elementList = XMLParseUtility.getListOfDirectSiblingsUnderWithName((Node)propertiesNode, "property");
        for (Element element : elementList) {
            String key = element.getAttribute("name");
            String value = element.getAttribute("value");
            properties.setProperty(key, value);
        }
        return properties;
    }

    public static Properties getPropertiesForElementAsProperties(Element containerNode, String tagName) {
        Properties properties = new Properties();
        List<Element> elementList = XMLParseUtility.getListOfDirectSiblingsUnderWithName((Node)containerNode, tagName);
        for (Element element : elementList) {
            String key = element.getAttribute("name");
            String value = element.getAttribute("value");
            properties.put(key, value);
        }
        return properties;
    }

    public static Map<String, String> getPropertiesForElementAsMap(Element containerNode, String tagName) {
        HashMap<String, String> properties = new HashMap<String, String>();
        List<Element> elementList = XMLParseUtility.getListOfDirectSiblingsUnderWithName((Node)containerNode, tagName);
        for (Element element : elementList) {
            String key = element.getAttribute("name");
            String value = element.getAttribute("value");
            properties.put(key, value);
        }
        return properties;
    }

    public static String getTextForTagUnderRootElement(Node rootNode, String elementName, String tagName) {
        Element containerNode = XMLParseUtility.getFirstDirectChildUnderWithName(rootNode, elementName);
        if (containerNode == null) {
            return null;
        }
        return XMLParseUtility.getTextForTagForElement((Node)containerNode, tagName);
    }

    public static String getTextForTagForElement(Node containerNode, String tagName) {
        Element element = XMLParseUtility.getFirstDirectChildUnderWithName(containerNode, tagName);
        if (element == null) {
            return null;
        }
        return element.getTextContent().trim();
    }

    public static Map<String, String> getAttributeMapForElement(Element element) {
        HashMap<String, String> attribMap = new HashMap<String, String>();
        if (element == null) {
            return attribMap;
        }
        NamedNodeMap nodeMap = element.getAttributes();
        for (int i = 0; i < nodeMap.getLength(); ++i) {
            Node node = nodeMap.item(i);
            attribMap.put(node.getNodeName(), node.getNodeValue().trim());
        }
        return attribMap;
    }

    public static String getElementName(Element element) {
        return element.getNodeName();
    }

    public static String getElementValue(Element element) {
        return element.getTextContent().trim();
    }

    public static int safeParseIntValue(Element element, String tagName) {
        try {
            return Integer.parseInt(XMLParseUtility.getTextForTagForElement((Node)element, tagName));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static int safeParseIntValue(Element element, String tagName, int defaultValue) {
        try {
            return Integer.parseInt(XMLParseUtility.getTextForTagForElement((Node)element, tagName));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static long safeParseLongValue(Element element, String tagName) {
        try {
            return Long.parseLong(XMLParseUtility.getTextForTagForElement((Node)element, tagName));
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public static long safeParseLongValue(Element element, String tagName, long defaultValue) {
        try {
            return Long.parseLong(XMLParseUtility.getTextForTagForElement((Node)element, tagName));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getXmlDocumentFromFile(File xmlFile) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder builder = XMLParseUtility.getDocumentBuilder();
        try (FileInputStream fis = new FileInputStream(xmlFile);){
            Document document = builder.parse((InputStream)fis);
            return document;
        }
    }

    public static Document getXmlDocumentFromInputStream(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilder builder = XMLParseUtility.getDocumentBuilder();
        return builder.parse(inputStream);
    }

    public static Document getXmlDocumentFromString(String streamAsString) throws SAXException, IOException, ParserConfigurationException {
        return XMLParseUtility.getXmlDocumentFromInputStream(new ByteArrayInputStream(XMLParseUtility.editAmpersandsInXML(streamAsString).getBytes("utf-8")));
    }

    public static Document getXMLDocument(String xmlFile, String fileContext, ILogger logger) throws XMLParseException {
        Document xmlDoc;
        try {
            xmlDoc = XMLParseUtility.getXmlDocumentFromFile(new File(xmlFile));
        }
        catch (IOException e) {
            logger.error("Could not read" + fileContext + e.getLocalizedMessage(), (Throwable)e);
            throw new XMLParseException(e);
        }
        catch (SAXException e) {
            logger.error("Could not parse" + fileContext + e.getLocalizedMessage(), (Throwable)e);
            throw new XMLParseException(e);
        }
        catch (ParserConfigurationException e) {
            logger.error("Could not parse" + fileContext + ",Invalid Parser configuration " + e.getLocalizedMessage(), (Throwable)e);
            throw new XMLParseException(e);
        }
        return xmlDoc;
    }

    public static Document getXMLDocument(InputStream in, String streamContext, ILogger logger) throws XMLParseException {
        Document xmlDoc;
        try {
            xmlDoc = XMLParseUtility.getXmlDocumentFromInputStream(in);
        }
        catch (IOException e) {
            logger.error("Could not read" + streamContext + e.getLocalizedMessage(), (Throwable)e);
            throw new XMLParseException(e);
        }
        catch (SAXException e) {
            logger.error("Could not parse" + streamContext + e.getLocalizedMessage(), (Throwable)e);
            throw new XMLParseException(e);
        }
        catch (ParserConfigurationException e) {
            logger.error("Could not parse" + streamContext + ",Invalid Parser configuration " + e.getLocalizedMessage(), (Throwable)e);
            throw new XMLParseException(e);
        }
        return xmlDoc;
    }

    private static String editAmpersandsInXML(String originalString) {
        String returnString = originalString;
        Matcher matcher = pattern.matcher(returnString);
        int index = 0;
        while (matcher.find(index)) {
            int matchLocation = matcher.start();
            String substString = XMLParseUtility.getXMLAmpersandSubstitutionString(returnString, matchLocation);
            if (substString != null) {
                StringBuilder newSB = new StringBuilder();
                newSB.append(returnString.substring(0, matchLocation)).append(substString);
                if (matchLocation < returnString.length() - 1) {
                    newSB.append(returnString.substring(matchLocation + 1));
                    index = matchLocation + substString.length();
                    returnString = newSB.toString();
                    matcher.reset(returnString);
                    continue;
                }
                returnString = newSB.toString();
                break;
            }
            index = matchLocation + 1;
            if (index < returnString.length()) continue;
            break;
        }
        return returnString;
    }

    private static String getXMLAmpersandSubstitutionString(String xmlString, int matchLocation) {
        String returnString = null;
        char matchingChar = xmlString.charAt(matchLocation);
        if (matchingChar == '&') {
            String restOfString = xmlString.substring(matchLocation);
            boolean isValidEntityRef = false;
            for (String entityRef : VALID_ENTITY_REFS) {
                if (!restOfString.startsWith(entityRef)) continue;
                isValidEntityRef = true;
                break;
            }
            if (!isValidEntityRef) {
                returnString = ampEntityRef;
            }
        }
        return returnString;
    }

    public static boolean isValidChar(int i) {
        return XMLChar.isValid((int)i);
    }

    static {
        saxParserThreadLocal = null;
    }
}

