/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.net;

import com.singularity.ee.util.logging.ILogger;
import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicInteger;

public class PortUtil {
    public static int getNextPort(AtomicInteger generator, int min, int max, ILogger logger, String desc) {
        int value;
        while (PortUtil.isPortUsed(value = generator.getAndIncrement(), logger) && value <= max) {
        }
        if (value <= max) {
            return value;
        }
        logger.error("Ports are maxed out, cannot create any more " + desc);
        throw new RuntimeException("All ports in range " + min + "-" + max + " are in use!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isPortUsed(int port, ILogger logger) {
        logger.debug("Testing port " + port);
        Socket s = null;
        try {
            s = new Socket("localhost", port);
            logger.debug("Port" + port + " is used");
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            logger.debug("Port " + port + " is not used");
            boolean bl = false;
            return bl;
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (IOException e) {
                    return false;
                }
            }
        }
    }
}

