/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.keystore;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

public class AsymmetricKeysStoreWrapper {
    private KeyStore symmetricKeyStore;
    private final String asymmetricKeyPassword;
    private final String asymmetricKeyAlias;

    public AsymmetricKeysStoreWrapper(String configDir, String asymmetricKeysStoreFilename, String asymmetricKeysStorePassword, String asymmetricKeyPassword, String asymmetricKeyAlias) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        String keyStoreFileName = configDir + File.separator + asymmetricKeysStoreFilename;
        File keystoreFile = new File(keyStoreFileName);
        FileInputStream fis = new FileInputStream(keystoreFile);
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        keystore.load(fis, asymmetricKeysStorePassword != null ? asymmetricKeysStorePassword.toCharArray() : null);
        this.symmetricKeyStore = keystore;
        this.asymmetricKeyPassword = asymmetricKeyPassword;
        this.asymmetricKeyAlias = asymmetricKeyAlias;
    }

    public String getAsymmetricKeyPassword() {
        return this.asymmetricKeyPassword;
    }

    public String getAsymmetricKeyAlias() {
        return this.asymmetricKeyAlias;
    }

    public KeyStore getKeyStore() {
        return this.symmetricKeyStore;
    }
}

