/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.httpclient;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.client.AuthCache;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.UnsupportedSchemeException;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.util.Args;

public class ThreadSafeAuthCache
implements AuthCache {
    private final Map<HttpHost, AuthScheme> map = new ConcurrentHashMap<HttpHost, AuthScheme>();
    private final SchemePortResolver schemePortResolver;
    private final boolean isRetainAuthHeaderEnabled;

    public ThreadSafeAuthCache(SchemePortResolver schemePortResolver, boolean isRetainAuthHeaderEnabled) {
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
        this.isRetainAuthHeaderEnabled = isRetainAuthHeaderEnabled;
    }

    public ThreadSafeAuthCache() {
        this(null, false);
    }

    private HttpHost getKey(HttpHost host) {
        if (host.getPort() <= 0) {
            int port;
            try {
                port = this.schemePortResolver.resolve(host);
            }
            catch (UnsupportedSchemeException ignore) {
                return host;
            }
            return new HttpHost(host.getHostName(), port, host.getSchemeName());
        }
        return host;
    }

    public void put(HttpHost host, AuthScheme authScheme) {
        if (!(authScheme instanceof BasicScheme)) {
            throw new IllegalStateException("AuthScheme not of type BasicScheme");
        }
        Args.notNull((Object)host, (String)"HTTP host");
        this.map.put(this.getKey(host), authScheme);
    }

    public AuthScheme get(HttpHost host) {
        throw new UnsupportedOperationException("Cannot get credentials from cache, use the proxy ThreadSafeProxyAuthCache");
    }

    public void remove(HttpHost host) {
        if (!this.isRetainAuthHeaderEnabled) {
            this.map.remove(host);
        }
    }

    public void clear() {
        throw new UnsupportedOperationException("Cannot clear credentials from cache");
    }

    public String toString() {
        return this.map.toString();
    }

    public AuthCache getThreadSafeProxy() {
        return new ThreadSafeProxyAuthCache();
    }

    private class ThreadSafeProxyAuthCache
    implements AuthCache {
        private final Map<HttpHost, AuthScheme> threadedMap = new HashMap<HttpHost, AuthScheme>();

        private ThreadSafeProxyAuthCache() {
        }

        public void put(HttpHost host, AuthScheme authScheme) {
            if (!(authScheme instanceof BasicScheme)) {
                throw new IllegalStateException("AuthScheme not of type BasicScheme");
            }
            Args.notNull((Object)host, (String)"HTTP host");
            this.threadedMap.put(ThreadSafeAuthCache.this.getKey(host), authScheme);
        }

        public AuthScheme get(HttpHost host) {
            AuthScheme threadUnsafeAuthScheme;
            HttpHost resolvedHost = ThreadSafeAuthCache.this.getKey(host);
            AuthScheme threadLocalAuthScheme = this.threadedMap.get(resolvedHost);
            if (threadLocalAuthScheme == null && (threadUnsafeAuthScheme = (AuthScheme)ThreadSafeAuthCache.this.map.get(resolvedHost)) instanceof BasicScheme) {
                threadLocalAuthScheme = new BasicScheme();
                this.threadedMap.put(host, (AuthScheme)new BasicScheme());
            }
            return threadLocalAuthScheme;
        }

        public void remove(HttpHost host) {
            if (!ThreadSafeAuthCache.this.isRetainAuthHeaderEnabled) {
                this.threadedMap.remove(host);
                ThreadSafeAuthCache.this.remove(host);
            }
        }

        public void clear() {
            this.threadedMap.clear();
            ThreadSafeAuthCache.this.clear();
        }
    }
}

