/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.httpclient;

import com.singularity.ee.util.httpclient.BinaryRequestEntity;
import com.singularity.ee.util.httpclient.ConnectionCleanerTask;
import com.singularity.ee.util.httpclient.EasySSLProtocolSocketFactory;
import com.singularity.ee.util.httpclient.EasyX509TrustManager;
import com.singularity.ee.util.httpclient.HttpClientUtils;
import com.singularity.ee.util.httpclient.HttpExecutionRequest;
import com.singularity.ee.util.httpclient.HttpExecutionResponse;
import com.singularity.ee.util.httpclient.HttpOperation;
import com.singularity.ee.util.httpclient.HttpProxyCredential;
import com.singularity.ee.util.httpclient.IHttpClientWrapper;
import com.singularity.ee.util.httpclient.KeyAliasBasedX509KeyManager;
import com.singularity.ee.util.httpclient.NoLocalBindDefaultProtocolSocketFactory;
import com.singularity.ee.util.httpclient.NoLocalBindEasySSLProtocolSocketFactory;
import com.singularity.ee.util.httpclient.ThreadSafeAuthCache;
import com.singularity.ee.util.httpclient.TrustManagerShouldDoDefaultValidation;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.keystore.AsymmetricKeysStoreWrapper;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.security.credentialstore.KeyStoreBasedEncryptionWrapper;
import com.singularity.ee.util.spi.AgentTimeUnit;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;
import com.singularity.ee.util.spi.IAgentScheduledFuture;
import com.singularity.ee.util.string.StringOperations;
import com.singularity.ee.util.system.SystemUtils;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class SimpleHttpClientWrapper
implements IHttpClientWrapper {
    private final CloseableHttpClient httpClient;
    private volatile HttpHost httpHost;
    private RequestConfig globalRequestConfig;
    private final KeyStoreBasedEncryptionWrapper encryptionWrapper;
    private final CredentialsProvider credentialsProvider = new BasicCredentialsProvider();
    private final ThreadLocal<HttpClientContext> httpClientContextThreadLocal = new ThreadLocal();
    private final ThreadSafeAuthCache authCache;
    private ILogger logger;
    private IAgentScheduledFuture cleanerTaskFuture;
    private static final String KEYMANAGER_FACTORY_ALGORITHM = SystemUtils.getProperty((String)"appdynamics.agent.ssl.keymanager.factory.algorithm", (String)KeyManagerFactory.getDefaultAlgorithm());

    @Deprecated
    public SimpleHttpClientWrapper(int connectionTimeout) {
        if (connectionTimeout < 0) {
            throw new IllegalArgumentException("Connection timeout vaue: " + connectionTimeout + " should be greater than or equal to 0.");
        }
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager();
        connManager.setMaxTotal(1);
        connManager.setDefaultMaxPerRoute(1);
        connManager.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(60000).build());
        this.globalRequestConfig = RequestConfig.custom().setConnectTimeout(connectionTimeout).setSocketTimeout(60000).build();
        this.httpClient = HttpClientBuilder.create().setDefaultRequestConfig(this.globalRequestConfig).setConnectionManager((HttpClientConnectionManager)connManager).build();
        this.encryptionWrapper = null;
        this.authCache = new ThreadSafeAuthCache();
    }

    @Deprecated
    public SimpleHttpClientWrapper(ILogger logger) {
        this(logger, false, null, null, false, null, null, System.getProperties(), null, null);
    }

    public SimpleHttpClientWrapper(ILogger logger, boolean sslEnabled, TrustManagerShouldDoDefaultValidation validation, KeyStore keystore, boolean forceDefaultSSLCertificateValidation, String sslProtocol, IAgentScheduledExecutorService scheduler, Properties properties, KeyStoreBasedEncryptionWrapper encryptionWrapper, AsymmetricKeysStoreWrapper asymmetricKeysStore) {
        this(logger, sslEnabled, validation, keystore, forceDefaultSSLCertificateValidation, sslProtocol, scheduler, properties, encryptionWrapper, asymmetricKeysStore, null);
    }

    public SimpleHttpClientWrapper(ILogger logger, boolean sslEnabled, TrustManagerShouldDoDefaultValidation validation, KeyStore keystore, boolean forceDefaultSSLCertificateValidation, String sslProtocol, IAgentScheduledExecutorService scheduler, Properties properties, KeyStoreBasedEncryptionWrapper encryptionWrapper, AsymmetricKeysStoreWrapper asymmetricKeysStore, HttpRequestRetryHandler httpRequestRetryHandler) {
        this.logger = logger;
        this.encryptionWrapper = encryptionWrapper;
        boolean isRetainAuthHeaderEnabled = HttpClientUtils.getBoolean("appdynamics.http.retainAuthHeaders", true, properties, logger);
        this.authCache = new ThreadSafeAuthCache(null, isRetainAuthHeaderEnabled);
        this.httpClient = this.createInternalHttpClient(logger, properties, sslEnabled, validation, keystore, forceDefaultSSLCertificateValidation, sslProtocol, scheduler, asymmetricKeysStore, httpRequestRetryHandler);
    }

    @Override
    public HttpExecutionResponse executeHttpOperation(HttpExecutionRequest executionRequest, ILogger logger) {
        HttpClientContext httpClientContext = this.getHttpClientContext();
        return this.executeHttpOperation(executionRequest, logger, httpClientContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpExecutionResponse executeHttpOperation(final HttpExecutionRequest executionRequest, final ILogger logger, HttpClientContext httpClientContext) {
        RequestBuilder requestBuilder;
        HttpExecutionResponse executionResponse = new HttpExecutionResponse();
        CloseableHttpResponse response = null;
        switch (executionRequest.getOperation()) {
            case DELETE: {
                requestBuilder = RequestBuilder.delete();
                break;
            }
            case GET: {
                requestBuilder = RequestBuilder.get();
                break;
            }
            case POST: {
                requestBuilder = RequestBuilder.post();
                break;
            }
            case PUT: {
                requestBuilder = RequestBuilder.put();
                break;
            }
            default: {
                throw new IllegalStateException("operation not supported: " + (Object)((Object)executionRequest.getOperation()));
            }
        }
        requestBuilder.setConfig(this.globalRequestConfig);
        if (executionRequest.isDisableCookies()) {
            requestBuilder.setConfig(RequestConfig.copy((RequestConfig)this.globalRequestConfig).setCookieSpec("ignoreCookies").build());
        }
        boolean releaseConnectionNow = true;
        String exceptionMessage = null;
        Exception exception = null;
        try {
            HttpUriRequest uriRequest;
            URIBuilder uriBuilder = new URIBuilder(executionRequest.getUrl());
            if (executionRequest.getQueryString() != null) {
                uriBuilder.setCustomQuery(executionRequest.getQueryString());
            }
            if (executionRequest.getQueryParams() != null) {
                uriBuilder.setParameters(executionRequest.getQueryParams());
            }
            requestBuilder.setUri(uriBuilder.build());
            HttpEntity entity = this.addRequestBodyForRequestIfPostOrPut(executionRequest, logger);
            requestBuilder.setEntity(entity);
            if (executionRequest.getOperation() == HttpOperation.POST && executionRequest.getPostParameters() != null) {
                this.addPostParameters(requestBuilder, executionRequest.getPostParameters());
            }
            if (executionRequest.getHeaders() != null) {
                for (Map.Entry<String, String> entry : executionRequest.getHeaders().entrySet()) {
                    requestBuilder.setHeader(entry.getKey(), entry.getValue());
                }
            }
            if (executionRequest.isCompressed()) {
                requestBuilder.setHeader("Accept-Encoding", "gzip");
            }
            response = (uriRequest = requestBuilder.build()).getURI().getHost() != null ? this.httpClient.execute(uriRequest, (HttpContext)new HttpClientContext((HttpContext)httpClientContext)) : this.httpClient.execute(this.httpHost, (HttpRequest)uriRequest, (HttpContext)httpClientContext);
            final CloseableHttpResponse streamResponse = response;
            int statusCode = response.getStatusLine().getStatusCode();
            executionResponse.setStatusCode(statusCode);
            if (statusCode == 200) {
                if (executionRequest.isResponseStreamed()) {
                    InputStream responseStream = response.getEntity().getContent();
                    if (responseStream != null) {
                        releaseConnectionNow = false;
                        FilterInputStream connManagedStream = new FilterInputStream(responseStream){
                            boolean closed;
                            {
                                super(arg0);
                                this.closed = false;
                            }

                            @Override
                            public void close() throws IOException {
                                try {
                                    super.close();
                                }
                                finally {
                                    streamResponse.close();
                                    this.closed = true;
                                }
                            }

                            protected void finalize() throws Throwable {
                                if (!this.closed) {
                                    logger.warn(" ** Input Stream was not closed in the calling method, please close stream explicitly ** URL : " + executionRequest.getUrl());
                                }
                                try {
                                    super.finalize();
                                }
                                finally {
                                    try {
                                        this.close();
                                    }
                                    catch (Exception exception) {}
                                }
                            }
                        };
                        executionResponse.setResponseBodyAsStream(connManagedStream);
                    }
                } else if (executionRequest.isResponseInBinary()) {
                    executionResponse.setResponseBytes(EntityUtils.toByteArray((HttpEntity)response.getEntity()));
                } else {
                    executionResponse.setResponseBody(EntityUtils.toString((HttpEntity)response.getEntity()));
                }
            } else {
                logger.error("HTTP Request failed: " + response.getStatusLine());
                if (statusCode == 401) {
                    logger.info("Resetting AuthState for Proxy: [" + httpClientContext.getProxyAuthState() + "] and Target [" + httpClientContext.getTargetAuthState() + "]");
                    httpClientContext.getTargetAuthState().reset();
                    httpClientContext.getProxyAuthState().reset();
                }
            }
            if (entity != null) {
                executionResponse.setRequestContentLength(entity.getContentLength());
            }
        }
        catch (UnsupportedEncodingException e) {
            exceptionMessage = "Fatal encoding error";
            exception = e;
        }
        catch (FileNotFoundException e) {
            exceptionMessage = "File upload error";
            exception = e;
        }
        catch (IOException e) {
            exceptionMessage = "Fatal transport error while connecting to URL [" + executionRequest.getUrl() + "]";
            exception = e;
        }
        catch (URISyntaxException e) {
            exceptionMessage = "URL [" + executionRequest.getUrl() + "] could not be parsed as a URI reference";
            exception = e;
        }
        finally {
            block48: {
                if (releaseConnectionNow && response != null) {
                    try {
                        response.close();
                    }
                    catch (IOException e) {
                        if (!logger.isDebugEnabled()) break block48;
                        logger.debug("Failed to close response", (Throwable)e);
                    }
                }
            }
        }
        if (exception != null) {
            this.updateResponseAndLogException(logger, executionResponse, exception, exceptionMessage);
        }
        return executionResponse;
    }

    private void updateResponseAndLogException(ILogger logger, HttpExecutionResponse executionResponse, Exception e, String message) {
        executionResponse.setExceptionHappened(true);
        executionResponse.setException(e);
        executionResponse.setExceptionMessage(message);
        if (logger.isDebugEnabled()) {
            logger.debug(message, (Throwable)e);
        } else {
            logger.error(message + ": " + e.toString());
        }
    }

    @Override
    public void shutdown() {
        try {
            if (this.cleanerTaskFuture != null && !this.cleanerTaskFuture.isDone()) {
                this.cleanerTaskFuture.cancel(true);
            }
            this.httpClient.close();
            this.httpClientContextThreadLocal.set(null);
        }
        catch (IOException e) {
            this.logger.error("Failed to close HTTP Client", (Throwable)e);
        }
    }

    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            this.shutdown();
        }
    }

    private HttpEntity addRequestBodyForRequestIfPostOrPut(HttpExecutionRequest executionRequest, ILogger logger) throws IOException {
        if (executionRequest.getOperation() != HttpOperation.POST && executionRequest.getOperation() != HttpOperation.PUT) {
            return null;
        }
        Object entity = executionRequest.getRequestPayload() != null ? new BinaryRequestEntity(executionRequest.getRequestPayload(), logger) : (executionRequest.getRawBinaryPayload() != null ? new BinaryRequestEntity(executionRequest.getRawBinaryPayload(), logger) : (executionRequest.getFiles() == null || executionRequest.getFiles().length == 0 && executionRequest.getBinaryParts() == null ? new StringEntity(executionRequest.getRequestBody(), ContentType.create((String)executionRequest.getRequestBodyType(), (String)"UTF-8")) : this.getMultipartRequest(executionRequest)));
        return entity;
    }

    private HttpEntity getMultipartRequest(HttpExecutionRequest executionRequest) throws FileNotFoundException {
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).addTextBody("request", executionRequest.getRequestBody());
        if (executionRequest.getFiles() != null) {
            for (int i = 0; i < executionRequest.getFiles().length; ++i) {
                multipartEntityBuilder.addPart(executionRequest.getFiles()[i].getName(), (ContentBody)new FileBody(executionRequest.getFiles()[i]));
            }
        }
        if (executionRequest.getBinaryParts() != null) {
            for (Map.Entry<String, byte[]> binaryEntry : executionRequest.getBinaryParts().entrySet()) {
                multipartEntityBuilder.addBinaryBody(binaryEntry.getKey(), binaryEntry.getValue());
            }
        }
        return multipartEntityBuilder.build();
    }

    private void addPostParameters(RequestBuilder requestBuilder, Map<String, String> postParams) {
        block3: {
            ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> entry : postParams.entrySet()) {
                list.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            try {
                requestBuilder.setEntity((HttpEntity)new UrlEncodedFormEntity(list));
            }
            catch (UnsupportedEncodingException e) {
                if (!this.logger.isDebugEnabled()) break block3;
                this.logger.debug("Unable to encode POST parameters into body");
            }
        }
    }

    public void setLogger(ILogger logger) {
        this.logger = logger;
    }

    private CloseableHttpClient createInternalHttpClient(ILogger logger, Properties properties, boolean sslEnabled, TrustManagerShouldDoDefaultValidation validation, KeyStore keystore, boolean forceDefaultSSLCertificateValidation, String sslProtocol, IAgentScheduledExecutorService scheduler, AsymmetricKeysStoreWrapper asymmetricKeysStore, HttpRequestRetryHandler httpRequestRetryHandler) {
        RegistryBuilder registryBuilder;
        HttpClientBuilder clientBuilder;
        DefaultProxyRoutePlanner routePlanner;
        ConnectionConfig.Builder connectionBuilder;
        int socketTimeout;
        int maxConnection;
        int maxConnectionPerHost;
        block14: {
            maxConnectionPerHost = HttpClientUtils.getInteger("com.singularity.httpclientwrapper.maxConnectionsPerHost", 4, properties, logger);
            maxConnection = HttpClientUtils.getInteger("com.singularity.httpclientwrapper.maxTotalConnections", 20, properties, logger);
            int connTimeout = HttpClientUtils.getInteger("com.singularity.httpclientwrapper.connectionTimeout", 5000, properties, logger);
            socketTimeout = HttpClientUtils.getInteger("com.singularity.httpclientwrapper.readTimeout", 60000, properties, logger);
            int sendBufferSize = HttpClientUtils.getInteger("com.singularity.httpclientwrapper.socketSendBufferSize", 32768, properties, logger);
            int recBufferSize = HttpClientUtils.getInteger("com.singularity.httpclientwrapper.socketReceiveBufferSize", 32768, properties, logger);
            this.globalRequestConfig = RequestConfig.custom().setConnectTimeout(connTimeout).setSocketTimeout(socketTimeout).build();
            connectionBuilder = ConnectionConfig.custom();
            connectionBuilder.setBufferSize(sendBufferSize > recBufferSize ? sendBufferSize : recBufferSize);
            routePlanner = null;
            HttpProxyCredential proxyCredential = new HttpProxyCredential(this.encryptionWrapper, properties, logger);
            String proxyHost = proxyCredential.getProxyHost();
            if (StringOperations.isNotEmpty((String)proxyHost)) {
                int proxyPort = proxyCredential.getProxyPort();
                HttpHost proxy = new HttpHost(proxyHost, proxyPort);
                routePlanner = new DefaultProxyRoutePlanner(proxy);
                this.setupProxyAuthentication(proxyHost, proxyPort, proxyCredential.getProxyUserName(), proxyCredential.getProxyPassword(), proxyCredential.getProxyPreemptiveAuth());
            }
            clientBuilder = HttpClientBuilder.create();
            Boolean doNotBindToLocalAddress = Boolean.getBoolean("appdynamics.agent.socket.no.local.bind");
            registryBuilder = RegistryBuilder.create();
            registryBuilder.register("http", (Object)(doNotBindToLocalAddress != false ? new NoLocalBindDefaultProtocolSocketFactory(logger) : new PlainConnectionSocketFactory()));
            if (sslEnabled) {
                try {
                    SSLContext sslcontext;
                    KeyManager[] keyManagers = null;
                    if (asymmetricKeysStore != null) {
                        KeyStore ksKeys = asymmetricKeysStore.getKeyStore();
                        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KEYMANAGER_FACTORY_ALGORITHM);
                        kmf.init(ksKeys, asymmetricKeysStore.getAsymmetricKeyPassword().toCharArray());
                        keyManagers = kmf.getKeyManagers();
                        if (asymmetricKeysStore.getAsymmetricKeyAlias() != null && asymmetricKeysStore.getAsymmetricKeyAlias().length() > 0 && keyManagers != null) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Specific Key-Alias: " + asymmetricKeysStore.getAsymmetricKeyAlias() + " is configured for client key selection");
                            }
                            for (int idx = 0; idx < keyManagers.length; ++idx) {
                                if (!(keyManagers[idx] instanceof X509KeyManager)) continue;
                                keyManagers[idx] = new KeyAliasBasedX509KeyManager((X509KeyManager)keyManagers[idx], asymmetricKeysStore.getAsymmetricKeyAlias(), logger);
                            }
                        } else if (logger.isDebugEnabled()) {
                            logger.debug("No Specific Key-Alias is configured for client key selection - Will be using standard KeyManager");
                        }
                    }
                    if ((sslcontext = SSLContext.getInstance(sslProtocol)).getProvider().getInfo().contains("FIPS mode")) {
                        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("PKIX");
                        trustManagerFactory.init(keystore);
                        sslcontext.init(keyManagers, trustManagerFactory.getTrustManagers(), null);
                    } else {
                        sslcontext.init(keyManagers, new TrustManager[]{new EasyX509TrustManager(keystore, logger, forceDefaultSSLCertificateValidation, validation)}, null);
                    }
                    EasySSLProtocolSocketFactory socketFactory = doNotBindToLocalAddress != false ? new NoLocalBindEasySSLProtocolSocketFactory(logger, sslcontext) : new EasySSLProtocolSocketFactory(logger, sslcontext);
                    registryBuilder.register("https", (Object)socketFactory);
                }
                catch (Exception e) {
                    if (logger == null) break block14;
                    logger.error("Error in handling SSL Context or Factory creation", (Throwable)e);
                }
            }
        }
        Registry socketFactoryRegistry = registryBuilder.build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        connManager.setDefaultMaxPerRoute(maxConnectionPerHost);
        connManager.setMaxTotal(maxConnection);
        connManager.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(socketTimeout).build());
        if (scheduler != null) {
            this.cleanerTaskFuture = scheduler.scheduleAtFixedRate((IAgentRunnable)new ConnectionCleanerTask((HttpClientConnectionManager)connManager), 30000L, 30000L, AgentTimeUnit.MILLISECONDS);
        }
        if (httpRequestRetryHandler != null) {
            clientBuilder.setRetryHandler(httpRequestRetryHandler);
        }
        return clientBuilder.setDefaultRequestConfig(this.globalRequestConfig).setDefaultConnectionConfig(connectionBuilder.build()).setRoutePlanner((HttpRoutePlanner)routePlanner).setConnectionManager((HttpClientConnectionManager)connManager).build();
    }

    private HttpClientContext getHttpClientContext() {
        HttpClientContext httpClientContext = this.httpClientContextThreadLocal.get();
        if (httpClientContext == null) {
            httpClientContext = HttpClientUtils.createHttpContext(this.credentialsProvider, this.authCache.getThreadSafeProxy());
            this.httpClientContextThreadLocal.set(httpClientContext);
        }
        return httpClientContext;
    }

    private void setupProxyAuthentication(String proxyHost, int proxyPort, String proxyUser, String proxyPassword, boolean proxyPreemptiveAuth) {
        if (StringOperations.isNotEmpty((String)proxyUser) && StringOperations.isNotEmpty((String)proxyPassword)) {
            if (this.logger != null) {
                this.logger.info("Using proxy authentication with user [" + proxyUser + "]");
            }
            this.credentialsProvider.setCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPassword));
            if (proxyPreemptiveAuth) {
                this.authCache.put(new HttpHost(proxyHost, proxyPort), (AuthScheme)new BasicScheme());
            }
        } else if (this.logger != null) {
            this.logger.info("Proxy authentication is not configured.");
        }
    }

    @Override
    public void authenticateHost(String host, int port, String realm, String userName, String password, boolean setPreemptiveAuth, boolean sslEnabled) {
        String scheme = sslEnabled ? "https" : "http";
        this.httpHost = new HttpHost(host, port, scheme);
        if (userName != null && password != null) {
            BasicScheme basicAuth = new BasicScheme();
            this.authCache.put(this.httpHost, (AuthScheme)basicAuth);
            UsernamePasswordCredentials hostCredentials = new UsernamePasswordCredentials(userName, password);
            this.credentialsProvider.setCredentials(new AuthScope(new HttpHost(host, port)), (Credentials)hostCredentials);
        }
    }
}

