/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.httpclient;

import com.singularity.ee.util.httpclient.EasySSLProtocolSocketFactory;
import com.singularity.ee.util.logging.ILogger;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import org.apache.http.HttpHost;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.protocol.HttpContext;

public class NoLocalBindEasySSLProtocolSocketFactory
extends EasySSLProtocolSocketFactory
implements LayeredConnectionSocketFactory {
    final ILogger logger;

    public NoLocalBindEasySSLProtocolSocketFactory(ILogger logger, SSLContext sslContext) {
        super(logger, sslContext);
        this.logger = logger;
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(NoLocalBindEasySSLProtocolSocketFactory.class);
    }

    @Override
    public int hashCode() {
        return NoLocalBindEasySSLProtocolSocketFactory.class.hashCode();
    }

    @Override
    public Socket connectSocket(int connectTimeout, Socket socket, HttpHost httpHost, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext httpContext) throws IOException {
        Socket sock = socket != null ? socket : this.createSocket(httpContext);
        try {
            sock.connect(remoteAddress, connectTimeout);
        }
        catch (IOException ex) {
            try {
                sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.logger.info("Hit socket exception", (Throwable)ex);
            throw ex;
        }
        if (sock instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)sock;
            if (this.logger.isDebugEnabled()) {
                sslSocket.addHandshakeCompletedListener(new EasySSLProtocolSocketFactory.HandshakeCompletedCallbackHandler(sslSocket));
                this.logCipherSuites("NLBEasy-SSLSocketFactory-EnabledCipherSuites", sslSocket.getEnabledCipherSuites());
                this.logProtocols("NLBEasy-SSLSocketFactory-EnabledProtocols", sslSocket.getEnabledProtocols());
            }
            sslSocket.startHandshake();
            return sock;
        }
        return this.createLayeredSocket(sock, httpHost.getHostName(), remoteAddress.getPort(), httpContext);
    }
}

