/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.httpclient;

import com.singularity.ee.util.logging.ILogger;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.http.HttpHost;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.protocol.HttpContext;

public class NoLocalBindDefaultProtocolSocketFactory
implements ConnectionSocketFactory {
    private final ILogger logger;

    public NoLocalBindDefaultProtocolSocketFactory(ILogger logger) {
        this.logger = logger;
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException {
        this.logger.debug("createSocket called. host = " + host + ", port = " + port + ", ignoring localAddress = " + (localAddress != null ? localAddress.toString() : "null") + ", ignoring localPort = " + localPort);
        try {
            return new Socket(host, port);
        }
        catch (IOException e) {
            this.logger.error("Error creating socket: " + e.getMessage());
            throw e;
        }
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        this.logger.debug("createSocket called with HttpConnectionParams -- ignoring the timeout value and proceeding");
        return new Socket(host, port);
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException, IOException {
        this.logger.debug("createSocket called with just host and port. proceeding..");
        return new Socket(host, port);
    }

    public Socket createSocket(HttpContext httpContext) throws IOException {
        return null;
    }

    public Socket connectSocket(int port, Socket socket, HttpHost httpHost, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, HttpContext httpContext) throws IOException {
        return null;
    }
}

