/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.httpclient;

import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.logging.SysOutLogger;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.X509KeyManager;

public class KeyAliasBasedX509KeyManager
implements X509KeyManager {
    private static ILogger logger = new SysOutLogger(KeyAliasBasedX509KeyManager.class.getName());
    private final X509KeyManager delegateX509KeyManager;
    private final String keyAlias;

    KeyAliasBasedX509KeyManager(X509KeyManager delegateX509KeyManager, String keyAlias, ILogger logger) {
        if (logger != null) {
            KeyAliasBasedX509KeyManager.setLogger(logger);
        }
        this.delegateX509KeyManager = delegateX509KeyManager;
        this.keyAlias = keyAlias;
    }

    private static void setLogger(ILogger logger) {
        KeyAliasBasedX509KeyManager.logger = logger;
    }

    private boolean matchAlias(String candidateKeyAlias) {
        if (candidateKeyAlias == null || candidateKeyAlias.length() < this.keyAlias.length()) {
            return false;
        }
        if (candidateKeyAlias.length() == this.keyAlias.length()) {
            return candidateKeyAlias.equals(this.keyAlias);
        }
        return candidateKeyAlias.endsWith("." + this.keyAlias);
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.delegateX509KeyManager.getClientAliases(keyType, issuers);
    }

    @Override
    public String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket socket) {
        if (keyTypes == null || keyTypes.length == 0) {
            logger.warn("Failing attempt to choose client key alias without any given keyTypes");
            return null;
        }
        for (String keyType : keyTypes) {
            Object[] keyAliases = this.getClientAliases(keyType, issuers);
            if (keyAliases == null) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Attempt to search client key Aliases of keyType: " + keyType + " returned nothing.");
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Attempt to search client key Aliases of keyType: " + keyType + " returned: " + Arrays.toString(keyAliases));
            }
            for (Object candidateKeyAlias : keyAliases) {
                if (!this.matchAlias((String)candidateKeyAlias)) continue;
                logger.info("Matched and selected Key alias: " + (String)candidateKeyAlias);
                return candidateKeyAlias;
            }
        }
        logger.info("Could not find matching Client Key with alias: " + this.keyAlias);
        return null;
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.delegateX509KeyManager.getServerAliases(keyType, issuers);
    }

    @Override
    public String chooseServerAlias(String keyTypes, Principal[] issuers, Socket socket) {
        return this.delegateX509KeyManager.chooseServerAlias(keyTypes, issuers, socket);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        return this.delegateX509KeyManager.getCertificateChain(alias);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this.delegateX509KeyManager.getPrivateKey(alias);
    }
}

