/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.httpclient;

import com.singularity.ee.util.httpclient.HttpClientUtils;
import com.singularity.ee.util.io.FileUtil;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.security.credentialstore.KeyStoreBasedEncryptionWrapper;
import com.singularity.ee.util.security.credentialstore.exception.CryptoOperationFailureException;
import com.singularity.ee.util.string.StringOperations;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class HttpProxyCredential {
    private final KeyStoreBasedEncryptionWrapper encryptionWrapper;
    private final ILogger logger;
    private String proxyHost;
    private int proxyPort;
    private String proxyUserName;
    private String proxyPassword;
    private boolean proxyPreemptiveAuth;

    public HttpProxyCredential(KeyStoreBasedEncryptionWrapper encryptionWrapper, Properties properties, ILogger logger) {
        this.encryptionWrapper = encryptionWrapper;
        this.logger = logger;
        this.proxyHost = properties.getProperty("com.singularity.httpclientwrapper.proxyHost");
        if (this.proxyHost == null) {
            this.proxyHost = properties.getProperty("appdynamics.http.proxyHost");
        }
        if (StringOperations.isNotEmpty((String)this.proxyHost)) {
            Integer proxyPort = HttpClientUtils.getInteger("com.singularity.httpclientwrapper.proxyPort", properties, logger);
            if (proxyPort == null) {
                proxyPort = HttpClientUtils.getInteger("appdynamics.http.proxyPort", properties, logger);
            }
            if (proxyPort == null) {
                throw new IllegalStateException("Proxy support is enabled but no proxy port is specified: appdynamics.http.proxyPort");
            }
            this.proxyPort = proxyPort;
            if (logger != null) {
                logger.info("Using proxy settings [" + this.proxyHost + ":" + proxyPort + "]");
            }
            this.proxyUserName = properties.getProperty("appdynamics.http.proxyUser");
            this.proxyPreemptiveAuth = StringOperations.safeParseBoolean((String)properties.getProperty("appdynamics.http.preemptiveProxyAuth"), (boolean)false);
            String proxyPasswordFile = properties.getProperty("appdynamics.http.proxyPasswordFile");
            if (StringOperations.isNotEmpty((String)proxyPasswordFile)) {
                this.proxyPassword = this.getProxyPassword(proxyPasswordFile);
            }
        }
    }

    private String getProxyPassword(String proxyPasswordFile) {
        String proxyPassword = null;
        File proxyPasswordFileObj = new File(proxyPasswordFile);
        try {
            proxyPassword = FileUtil.readFirstLine((File)proxyPasswordFileObj);
            if (this.encryptionWrapper != null) {
                proxyPassword = this.encryptionWrapper.decryptCipherTextString(proxyPassword);
            }
        }
        catch (IOException e) {
            if (this.logger != null) {
                this.logger.error("Error reading file: " + proxyPasswordFileObj.getAbsolutePath(), (Throwable)e);
            } else {
                e.printStackTrace(System.out);
            }
        }
        catch (CryptoOperationFailureException cryptoFailureException) {
            if (this.logger != null) {
                this.logger.error("Failed to decrypt proxyPassword read from: " + proxyPasswordFileObj.getAbsolutePath(), (Throwable)cryptoFailureException);
            }
            cryptoFailureException.printStackTrace(System.out);
        }
        return proxyPassword;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyUserName() {
        return this.proxyUserName;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public boolean getProxyPreemptiveAuth() {
        return this.proxyPreemptiveAuth;
    }
}

