/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.httpclient;

import com.singularity.ee.util.httpclient.HttpOperation;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import org.apache.http.NameValuePair;

public class HttpExecutionRequest
implements Serializable {
    public final String DEFAULT_REQUEST_BODY_TYPE = "text/xml";
    private static final long serialVersionUID = 1L;
    private String url;
    private String requestBody;
    private String requestBodyType = "text/xml";
    private HttpOperation operation;
    private Map<String, String> postParameters;
    private String queryString;
    private NameValuePair[] queryParams;
    private File[] files;
    private Map<String, byte[]> binaryParts;
    private boolean isCompressed;
    private boolean isResponseStreamed;
    private transient Object requestPayload;
    private transient byte[] rawBinaryPayload;
    private transient boolean responseInBinary;
    private Map<String, String> headers;
    private boolean disableCookies;

    public HttpExecutionRequest(String url, Object requestBody) {
        this.url = url;
        this.requestPayload = requestBody;
        this.operation = HttpOperation.POST;
    }

    public HttpExecutionRequest(String url, byte[] requestBody) {
        this.url = url;
        this.rawBinaryPayload = requestBody;
        this.operation = HttpOperation.POST;
    }

    public HttpExecutionRequest(String url, String requestBody, HttpOperation operation) {
        this.url = url;
        this.requestBody = requestBody;
        this.operation = operation;
    }

    public HttpExecutionRequest(String url, String requestBody, File[] files, HttpOperation operation) {
        this.url = url;
        this.requestBody = requestBody;
        this.operation = operation;
        this.files = files;
    }

    public HttpExecutionRequest(String url, String requestBody, String[] fileNames, HttpOperation operation) {
        this.url = url;
        this.requestBody = requestBody;
        this.operation = operation;
        this.files = new File[fileNames.length];
        for (int i = 0; i < fileNames.length; ++i) {
            this.files[i] = new File(fileNames[i]);
        }
    }

    public HttpExecutionRequest(String url) {
        this(url, null, HttpOperation.GET);
        this.isResponseStreamed = true;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public void setRequestBody(String requestBody) {
        this.requestBody = requestBody;
    }

    public String getRequestBodyType() {
        return this.requestBodyType;
    }

    public void setRequestBodyType(String requestBodyType) {
        this.requestBodyType = requestBodyType;
    }

    public HttpOperation getOperation() {
        return this.operation;
    }

    public void setOperation(HttpOperation operation) {
        this.operation = operation;
    }

    public File[] getFiles() {
        return this.files;
    }

    public void setFiles(File[] files) {
        this.files = files;
    }

    public Map<String, byte[]> getBinaryParts() {
        return this.binaryParts;
    }

    public Object getRequestPayload() {
        return this.requestPayload;
    }

    public byte[] getRawBinaryPayload() {
        return this.rawBinaryPayload;
    }

    public void setBinaryParts(Map<String, byte[]> binaryParts) {
        this.binaryParts = binaryParts;
    }

    public Map<String, String> getPostParameters() {
        return this.postParameters;
    }

    public void setPostParameters(Map<String, String> postParameters) {
        this.postParameters = postParameters;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public NameValuePair[] getQueryParams() {
        return this.queryParams;
    }

    public void setQueryParams(NameValuePair[] queryParams) {
        this.queryParams = queryParams;
    }

    public boolean isCompressed() {
        return this.isCompressed;
    }

    public void setCompressed(boolean compressed) {
        this.isCompressed = compressed;
    }

    public boolean isResponseStreamed() {
        return this.isResponseStreamed;
    }

    public void setResponseStreamed(boolean streamed) {
        this.isResponseStreamed = streamed;
    }

    public void setResponseInBinary(boolean responseInBinary) {
        this.responseInBinary = responseInBinary;
    }

    public boolean isResponseInBinary() {
        return this.responseInBinary;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public boolean isDisableCookies() {
        return this.disableCookies;
    }

    public void setDisableCookies(boolean disableCookies) {
        this.disableCookies = disableCookies;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nHTTP Execution Request for URL[").append((Object)this.getOperation()).append("\t").append(this.getUrl()).append("]\n");
        if (this.getRequestBody() != null) {
            stringBuilder.append("Request Body [").append(this.getRequestBody()).append("]\n");
        }
        if (this.getPostParameters() != null) {
            stringBuilder.append("POST Parameters [").append(this.getPostParameters()).append("]\n");
        }
        if (this.getQueryString() != null) {
            stringBuilder.append("Query String [").append(this.getQueryString()).append("]\n");
        }
        if (this.getQueryParams() != null) {
            stringBuilder.append("Query Params ").append(Arrays.toString(this.getQueryParams())).append("\n");
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpExecutionRequest that = (HttpExecutionRequest)o;
        if (this.disableCookies != that.disableCookies) {
            return false;
        }
        if (this.isCompressed != that.isCompressed) {
            return false;
        }
        if (this.isResponseStreamed != that.isResponseStreamed) {
            return false;
        }
        if (this.responseInBinary != that.responseInBinary) {
            return false;
        }
        if (this.binaryParts != null ? !this.binaryParts.equals(that.binaryParts) : that.binaryParts != null) {
            return false;
        }
        if (!Arrays.equals(this.files, that.files)) {
            return false;
        }
        if (this.headers != null ? !this.headers.equals(that.headers) : that.headers != null) {
            return false;
        }
        if (this.operation != that.operation) {
            return false;
        }
        if (this.postParameters != null ? !this.postParameters.equals(that.postParameters) : that.postParameters != null) {
            return false;
        }
        if (!Arrays.equals(this.queryParams, that.queryParams)) {
            return false;
        }
        if (this.queryString != null ? !this.queryString.equals(that.queryString) : that.queryString != null) {
            return false;
        }
        if (!Arrays.equals(this.rawBinaryPayload, that.rawBinaryPayload)) {
            return false;
        }
        if (this.requestBody != null ? !this.requestBody.equals(that.requestBody) : that.requestBody != null) {
            return false;
        }
        if (this.requestBodyType != null ? !this.requestBodyType.equals(that.requestBodyType) : that.requestBodyType != null) {
            return false;
        }
        if (this.requestPayload != null ? !this.requestPayload.equals(that.requestPayload) : that.requestPayload != null) {
            return false;
        }
        return !(this.url != null ? !this.url.equals(that.url) : that.url != null);
    }

    public int hashCode() {
        int result = this.url != null ? this.url.hashCode() : 0;
        result = 31 * result + (this.requestBody != null ? this.requestBody.hashCode() : 0);
        result = 31 * result + (this.requestBodyType != null ? this.requestBodyType.hashCode() : 0);
        result = 31 * result + (this.operation != null ? this.operation.hashCode() : 0);
        result = 31 * result + (this.postParameters != null ? this.postParameters.hashCode() : 0);
        result = 31 * result + (this.queryString != null ? this.queryString.hashCode() : 0);
        result = 31 * result + (this.queryParams != null ? Arrays.hashCode(this.queryParams) : 0);
        result = 31 * result + (this.files != null ? Arrays.hashCode(this.files) : 0);
        result = 31 * result + (this.binaryParts != null ? this.binaryParts.hashCode() : 0);
        result = 31 * result + (this.isCompressed ? 1 : 0);
        result = 31 * result + (this.isResponseStreamed ? 1 : 0);
        result = 31 * result + (this.requestPayload != null ? this.requestPayload.hashCode() : 0);
        result = 31 * result + (this.rawBinaryPayload != null ? Arrays.hashCode(this.rawBinaryPayload) : 0);
        result = 31 * result + (this.responseInBinary ? 1 : 0);
        result = 31 * result + (this.headers != null ? this.headers.hashCode() : 0);
        result = 31 * result + (this.disableCookies ? 1 : 0);
        return result;
    }
}

