/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.httpclient;

import com.google.common.base.Joiner;
import com.google.common.collect.Ordering;
import com.singularity.ee.util.httpclient.HTTPClientConstants;
import com.singularity.ee.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.protocol.HttpClientContext;

public class HttpClientUtils {
    public static int getInteger(String propName, int defaultValue, Properties properties, ILogger logger) {
        Integer value = HttpClientUtils.getInteger(propName, properties, logger);
        return value == null ? defaultValue : value;
    }

    public static Integer getInteger(String propName, Properties properties, ILogger logger) {
        String value = properties.getProperty(propName);
        if (value != null) {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                if (logger != null) {
                    logger.error("Value for property [" + propName + "] is not an integer: [" + value + "]");
                }
                return null;
            }
        }
        return null;
    }

    public static boolean getBoolean(String propName, boolean defaultValue, Properties properties, ILogger logger) {
        Boolean value = HttpClientUtils.getBoolean(propName, properties, logger);
        return value == null ? defaultValue : value;
    }

    public static Boolean getBoolean(String propName, Properties properties, ILogger logger) {
        String value = properties.getProperty(propName);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return null;
    }

    public static HttpClientContext createHttpContext(CredentialsProvider credentialsProvider, AuthCache authCache) {
        HttpClientContext httpClientContext = HttpClientContext.create();
        httpClientContext.setAuthCache(authCache);
        httpClientContext.setCredentialsProvider(credentialsProvider);
        return httpClientContext;
    }

    public static String getMostSecureCompatibleProtocol(String[] supportedProtocols, ILogger logger) {
        if (supportedProtocols != null && supportedProtocols.length > 0) {
            ArrayList<String> supportedProtosAsList = new ArrayList<String>(Arrays.asList(supportedProtocols));
            supportedProtosAsList.retainAll(HTTPClientConstants.tlsVersions);
            Collections.sort(supportedProtosAsList, Ordering.explicit(HTTPClientConstants.tlsVersions));
            logger.info("Secure TLS protocols supported by JDK are: " + Joiner.on((String)", ").join(supportedProtosAsList));
            return (String)supportedProtosAsList.get(0);
        }
        logger.error("No supported protocols found from JDK, there might be issues in creating HTTPS connections.");
        return null;
    }

    public static boolean isProtocolUnsafe(String tlsProtocol) {
        return HTTPClientConstants.disallowedTLSVersions.contains(tlsProtocol);
    }
}

