/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.httpclient;

import com.singularity.ee.util.enums.EnumHelper;
import com.singularity.ee.util.httpclient.TrustManagerShouldDoDefaultValidation;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.logging.SysOutLogger;
import com.singularity.ee.util.system.SystemUtils;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class EasyX509TrustManager
implements X509TrustManager {
    private X509TrustManager standardTrustManager = null;
    private static ILogger logger = new SysOutLogger(EasyX509TrustManager.class.getName());
    public static final String FORCE_DEFAULT_CERTIFICATE_VALIDATION_PROP_NAME = "appdynamics.force.default.ssl.certificate.validation";
    private static final String MINIMAL_VALIDATION_LOG_MESSAGE = "Minimal certificate chain validation performed";
    private static final String FULL_VALIDATION_MESSAGE_SEGMENT_1 = "Full certificate chain validation performed using ";
    private static final String FULL_VALIDATION_MESSAGE_SEGMENT_2 = " certificate file";
    private static final String FULL_VALIDATION_MESSAGE_DEFAULT_SEGMENT = "default";
    private static final String FULL_VALIDATION_MESSAGE_LOCAL_SEGMENT = "local";
    private static final String FAILED_VALIDATION_MESSAGE_SEGMENT_1 = "Certificate chain validation failed ";
    private static final String FAILED_VALIDATION_MESSAGE_SEGMENT_2 = " attempting validation.";
    private final KeyStore keystore;
    private static final TrustManagerShouldDoDefaultValidation SHOULD_FORCE_DEFAULT_CERTIFICATE_VALIDATION_FROM_PROP = EasyX509TrustManager.getForceDefaultCertificateValidation();
    private final TrustManagerShouldDoDefaultValidation overrideForceDefaultCertificateValidation;
    private final boolean forceDefaultCertificateValidation;

    private static TrustManagerShouldDoDefaultValidation getForceDefaultCertificateValidation() {
        TrustManagerShouldDoDefaultValidation returnValue = null;
        String propValue = SystemUtils.getProperty((String)FORCE_DEFAULT_CERTIFICATE_VALIDATION_PROP_NAME);
        if (propValue != null) {
            try {
                returnValue = (TrustManagerShouldDoDefaultValidation)EnumHelper.getEnum(TrustManagerShouldDoDefaultValidation.class, (String)propValue.toUpperCase());
            }
            catch (Exception e) {
                logger.error(String.format("Invalid value for property %s: %s.  Exception: %s", FORCE_DEFAULT_CERTIFICATE_VALIDATION_PROP_NAME, propValue, e), (Throwable)e);
                returnValue = null;
            }
        }
        if (returnValue == null) {
            returnValue = TrustManagerShouldDoDefaultValidation.UNSPECIFIED;
        }
        return returnValue;
    }

    public EasyX509TrustManager(KeyStore keystore, ILogger logger) throws NoSuchAlgorithmException, KeyStoreException {
        this(keystore, logger, false, TrustManagerShouldDoDefaultValidation.UNSPECIFIED);
    }

    private static void setLogger(ILogger logger) {
        EasyX509TrustManager.logger = logger;
    }

    public EasyX509TrustManager(KeyStore keystore, ILogger logger, boolean forceDefaultCertificateValidation, TrustManagerShouldDoDefaultValidation overrideForceDefaultCertificateValidation) throws NoSuchAlgorithmException, KeyStoreException {
        if (logger != null) {
            EasyX509TrustManager.setLogger(logger);
        }
        this.keystore = keystore;
        this.overrideForceDefaultCertificateValidation = SHOULD_FORCE_DEFAULT_CERTIFICATE_VALIDATION_FROM_PROP != TrustManagerShouldDoDefaultValidation.UNSPECIFIED ? SHOULD_FORCE_DEFAULT_CERTIFICATE_VALIDATION_FROM_PROP : overrideForceDefaultCertificateValidation;
        this.forceDefaultCertificateValidation = (forceDefaultCertificateValidation || this.overrideForceDefaultCertificateValidation == TrustManagerShouldDoDefaultValidation.TRUE || keystore != null) && this.overrideForceDefaultCertificateValidation != TrustManagerShouldDoDefaultValidation.FALSE;
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init(keystore);
        TrustManager[] trustmanagers = factory.getTrustManagers();
        if (trustmanagers.length == 0) {
            throw new NoSuchAlgorithmException("no trust manager found");
        }
        this.standardTrustManager = (X509TrustManager)trustmanagers[0];
    }

    @Override
    public void checkClientTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        this.standardTrustManager.checkClientTrusted(certificates, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        try {
            if (this.forceDefaultCertificateValidation) {
                this.standardTrustManager.checkServerTrusted(certificates, authType);
                logger.info(FULL_VALIDATION_MESSAGE_SEGMENT_1 + (this.keystore == null ? FULL_VALIDATION_MESSAGE_DEFAULT_SEGMENT : FULL_VALIDATION_MESSAGE_LOCAL_SEGMENT) + FULL_VALIDATION_MESSAGE_SEGMENT_2);
            } else {
                if (certificates != null && logger.isDebugEnabled()) {
                    logger.debug("Server certificate chain:");
                    for (int i = 0; i < certificates.length; ++i) {
                        logger.debug("X509Certificate[" + i + "]=" + certificates[i]);
                    }
                }
                if (certificates != null && certificates.length == 1) {
                    certificates[0].checkValidity();
                    logger.info(MINIMAL_VALIDATION_LOG_MESSAGE);
                } else if (this.overrideForceDefaultCertificateValidation == TrustManagerShouldDoDefaultValidation.FALSE) {
                    if (certificates != null) {
                        for (X509Certificate next : certificates) {
                            next.checkValidity();
                        }
                    }
                    logger.info(MINIMAL_VALIDATION_LOG_MESSAGE);
                } else {
                    this.standardTrustManager.checkServerTrusted(certificates, authType);
                    logger.info(FULL_VALIDATION_MESSAGE_SEGMENT_1 + (this.keystore == null ? FULL_VALIDATION_MESSAGE_DEFAULT_SEGMENT : FULL_VALIDATION_MESSAGE_LOCAL_SEGMENT) + FULL_VALIDATION_MESSAGE_SEGMENT_2);
                }
            }
        }
        catch (CertificateException e) {
            logger.warn(FAILED_VALIDATION_MESSAGE_SEGMENT_1 + e.toString() + FAILED_VALIDATION_MESSAGE_SEGMENT_2);
            throw e;
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.standardTrustManager.getAcceptedIssuers();
    }
}

