/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.httpclient;

import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.logging.SysOutLogger;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Arrays;
import javax.net.SocketFactory;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.http.HttpHost;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.protocol.HttpContext;

public class EasySSLProtocolSocketFactory
implements LayeredConnectionSocketFactory {
    private ILogger logger = new SysOutLogger(EasySSLProtocolSocketFactory.class.getName());
    private SSLContext sslcontext = null;
    private static final int DEFAULT_SOCKET_TIMEOUT = 60000;

    public EasySSLProtocolSocketFactory(ILogger logger, SSLContext sslContext) {
        if (logger != null) {
            this.logger = logger;
        }
        this.sslcontext = sslContext;
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(EasySSLProtocolSocketFactory.class);
    }

    public int hashCode() {
        return EasySSLProtocolSocketFactory.class.hashCode();
    }

    public Socket createLayeredSocket(Socket socket, String host, int port, HttpContext httpContext) throws IOException {
        SSLSocket sslSock = (SSLSocket)this.sslcontext.getSocketFactory().createSocket(socket, host, port, true);
        sslSock.setSoTimeout(60000);
        if (this.logger.isDebugEnabled()) {
            sslSock.addHandshakeCompletedListener(new HandshakeCompletedCallbackHandler(sslSock));
            this.logCipherSuites("EasySSLSocketFactory-layeredSocket-EnabledCipherSuites", sslSock.getEnabledCipherSuites());
            this.logProtocols("EasySSLSocketFactory-layeredSocket-EnabledProtocols", sslSock.getEnabledProtocols());
        }
        sslSock.startHandshake();
        return sslSock;
    }

    public Socket createSocket(HttpContext httpContext) throws IOException {
        Socket socket = SocketFactory.getDefault().createSocket();
        socket.setSoTimeout(60000);
        return socket;
    }

    public Socket connectSocket(int connectTimeout, Socket socket, HttpHost httpHost, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext httpContext) throws IOException {
        Socket sock;
        Socket socket2 = sock = socket != null ? socket : this.createSocket(httpContext);
        if (localAddress != null) {
            sock.bind(localAddress);
        }
        try {
            sock.connect(remoteAddress, connectTimeout);
        }
        catch (IOException ex) {
            try {
                sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ex;
        }
        if (sock instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)sock;
            if (this.logger.isDebugEnabled()) {
                sslSocket.addHandshakeCompletedListener(new HandshakeCompletedCallbackHandler(sslSocket));
                this.logCipherSuites("EasySSLSocketFactory-EnabledCipherSuites", sslSocket.getEnabledCipherSuites());
                this.logProtocols("EasySSLSocketFactory-EnabledProtocols", sslSocket.getEnabledProtocols());
            }
            sslSocket.startHandshake();
            return sock;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Changing socket into SSLSocket: " + sock);
        }
        return this.createLayeredSocket(sock, httpHost.getHostName(), remoteAddress.getPort(), httpContext);
    }

    protected final void logCipherSuites(String prefix, String[] cipherSuites) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SSL CipherSuites for: " + prefix + " - " + Arrays.toString(cipherSuites));
        }
    }

    protected final void logProtocols(String prefix, String[] sslProtocols) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SSL Protocols for: " + prefix + " - " + Arrays.toString(sslProtocols));
        }
    }

    protected class HandshakeCompletedCallbackHandler
    implements HandshakeCompletedListener {
        private SSLSocket socket;

        public HandshakeCompletedCallbackHandler(SSLSocket socket) {
            this.socket = socket;
        }

        @Override
        public void handshakeCompleted(HandshakeCompletedEvent event) {
            if (EasySSLProtocolSocketFactory.this.logger.isDebugEnabled()) {
                SSLSession session = this.socket.getSession();
                EasySSLProtocolSocketFactory.this.logger.debug("SSL Handshake Cipher Suite: " + session.getCipherSuite() + " - SSL Handshake Protocol: " + session.getProtocol());
            }
        }
    }
}

