/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.httpclient;

import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.serialize.ObjectSerializer;
import com.singularity.ee.util.serialize.ObjectSerializerFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.Header;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.message.BasicHeader;

public class BinaryRequestEntity
extends AbstractHttpEntity {
    private byte[] content;
    boolean rawInput;
    private ILogger logger;
    private static ObjectSerializer serializer = ObjectSerializerFactory.getSerializer();
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String RAW_BYTES = "application/singularity-raw-bytes";
    private static final Header RAW_HEADER = new BasicHeader("Content-Type", "application/singularity-raw-bytes");

    public BinaryRequestEntity(Object requestPayload, ILogger logger) throws IOException {
        this.logger = logger;
        this.content = serializer.marshalObject(requestPayload);
        this.rawInput = false;
    }

    public BinaryRequestEntity(byte[] rawRequestPayload, ILogger logger) throws IOException {
        this.logger = logger;
        this.content = rawRequestPayload;
        this.rawInput = true;
    }

    public boolean isRepeatable() {
        return true;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.content);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("REST\nSending Binary payload Size : " + this.content.length + " bytes");
        }
    }

    public long getContentLength() {
        return this.content.length;
    }

    public InputStream getContent() {
        return new ByteArrayInputStream(this.content);
    }

    public boolean isStreaming() {
        return false;
    }

    public Header getContentType() {
        if (this.rawInput) {
            return RAW_HEADER;
        }
        return new BasicHeader(CONTENT_TYPE, serializer.getContentType());
    }
}

