/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util;

import com.singularity.ee.controller.api.dto.NameValuePair;
import com.singularity.ee.controller.api.dto.transactionmonitor.ADStackTraceElement;
import com.singularity.ee.controller.api.dto.transactionmonitor.ADThrowable;
import com.singularity.ee.util.reflect.ReflectionUtilityCommon;
import com.singularity.ee.util.string.StringOperations;

public class StackTraceHelperShared {
    public static final char NEW_LINE = '\n';
    public static final char SPACE = ' ';
    public static final char TAB = '\t';
    private static int STACK_TRACE_LINE_LIMIT = 200;

    public static NameValuePair getStackTraceNameValuePair(ADThrowable[] adThrowables) {
        NameValuePair nameValuePair = new NameValuePair("Error", "Error");
        if (adThrowables != null && adThrowables.length > 0) {
            StringBuilder stackTraceDetails = new StringBuilder();
            StringBuilder stackTraceName = new StringBuilder();
            StackTraceHelperShared.fillInStackTrace(stackTraceDetails, stackTraceName, adThrowables[0], adThrowables[0].getAdStackTraceElements(), adThrowables[0].getAdStackTraceElements().length, true, adThrowables, 1);
            if (stackTraceName.charAt(stackTraceName.length() - 1) == ':') {
                StringOperations.setLength((StringBuilder)stackTraceName, (int)(stackTraceName.length() - 1));
            }
            nameValuePair.setName(stackTraceName.toString());
            nameValuePair.setValue(stackTraceDetails.toString());
        }
        return nameValuePair;
    }

    public static void fillInStackTrace(StringBuilder stackTraceDetails, StringBuilder stackTraceName, ADThrowable adThrowable, ADStackTraceElement[] adStackTraceElements, int traceLength, boolean truncated, ADThrowable[] causes, int causesIndex) {
        StackTraceHelperShared.fillInStackTrace(stackTraceDetails, stackTraceName, adThrowable, adStackTraceElements, traceLength, truncated, causes, causesIndex, ' ');
    }

    protected static void fillInStackTrace(StringBuilder stackTraceDetails, StringBuilder stackTraceName, ADThrowable adThrowable, ADStackTraceElement[] adStackTraceElements, int traceLength, boolean truncated, ADThrowable[] causes, int causesIndex, char SEPARATOR) {
        ADThrowable ourCause;
        try {
            stackTraceDetails.append(adThrowable.getClassName()).append(":").append(SEPARATOR);
            if (stackTraceName != null) {
                stackTraceName.append(adThrowable.getClassName()).append(":");
            }
        }
        catch (Throwable e) {
            stackTraceDetails.append(ReflectionUtilityCommon.getName(adThrowable.getClass())).append(SEPARATOR);
        }
        if (adStackTraceElements.length < traceLength) {
            traceLength = adStackTraceElements.length;
        }
        int count = 0;
        for (int i = 0; i < traceLength; ++i) {
            stackTraceDetails.append("at ");
            StackTraceHelperShared.appendTraceElement(adStackTraceElements[i], stackTraceDetails, SEPARATOR);
            if (count++ < STACK_TRACE_LINE_LIMIT) continue;
            StackTraceHelperShared.appendStackLinesLimitReached(stackTraceDetails, traceLength - 1, SEPARATOR);
            break;
        }
        if (causesIndex < causes.length && (ourCause = causes[causesIndex]) != null) {
            StackTraceHelperShared.appendStackTraceAsCause(stackTraceDetails, stackTraceName, adStackTraceElements, ourCause, traceLength, truncated, causes, causesIndex + 1, SEPARATOR);
        }
    }

    private static void appendStackLinesLimitReached(StringBuilder stackTraceDetails, int remaining, char SEPARATOR) {
        stackTraceDetails.append(remaining).append(" more lines truncated. ").append("stack-trace-line-limit (").append(STACK_TRACE_LINE_LIMIT).append(") reached.").append(SEPARATOR);
    }

    private static void appendStackTraceAsCause(StringBuilder stackTraceDetails, StringBuilder stackTraceName, ADStackTraceElement[] causedTrace, ADThrowable parentThrowable, int traceLength, boolean truncated, ADThrowable[] causes, int causesIndex, char SEPARATOR) {
        ADThrowable cause;
        ADStackTraceElement[] parentStackTraceElements = parentThrowable.getAdStackTraceElements();
        int m = parentStackTraceElements.length - 1;
        for (int n = causedTrace.length - 1; m >= 0 && n >= 0 && parentStackTraceElements[m].equals((Object)causedTrace[n]); --m, --n) {
        }
        int framesInCommon = parentStackTraceElements.length - 1 - m;
        stackTraceDetails.append("Caused by: ").append(parentThrowable.getClassName()).append(SEPARATOR);
        if (stackTraceName != null) {
            stackTraceName.append(parentThrowable.getClassName()).append(":");
        }
        if (truncated && m > traceLength) {
            m = traceLength - 1;
        }
        int count = 0;
        for (int i = 0; i <= m; ++i) {
            stackTraceDetails.append(SEPARATOR == ' ' ? (char)' ' : '\t').append("at ");
            StackTraceHelperShared.appendTraceElement(parentStackTraceElements[i], stackTraceDetails, SEPARATOR);
            if (count++ < STACK_TRACE_LINE_LIMIT) continue;
            StackTraceHelperShared.appendStackLinesLimitReached(stackTraceDetails, m - 1, SEPARATOR);
            break;
        }
        if (framesInCommon != 0) {
            stackTraceDetails.append(SEPARATOR == ' ' ? (char)' ' : '\t');
            stackTraceDetails.append("... ").append(framesInCommon);
            stackTraceDetails.append(" more").append(SEPARATOR);
        }
        if (causesIndex < causes.length && (cause = causes[causesIndex]) != null) {
            StackTraceHelperShared.appendStackTraceAsCause(stackTraceDetails, stackTraceName, parentStackTraceElements, cause, traceLength, truncated, causes, causesIndex + 1, SEPARATOR);
        }
    }

    private static void appendTraceElement(ADStackTraceElement adStackTraceElement, StringBuilder stackTraceDetails, char SEPARATOR) {
        String fileName = adStackTraceElement.getFileName();
        int lineNumber = adStackTraceElement.getLineNumber();
        stackTraceDetails.append(adStackTraceElement.getClassName()).append('.').append(adStackTraceElement.getMethodName()).append(fileName != null && lineNumber >= 0 ? "(" + fileName + ":" + lineNumber + ")" : (fileName != null ? "(" + fileName + ")" : "(Unknown Source)")).append(SEPARATOR);
    }
}

