/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util;

import com.singularity.ee.util.io.StreamGobbler;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public class OSNameUtil {
    public static final String EXTEND_OS_VERSION_SCRIPT_SHELL = "scripts/extend-os-version.sh";
    public static final String EXTEND_OS_VERSION_SCRIPT_BAT = "scripts/extend-os-version.bat";
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase();
    private static String OS_VERSION = null;
    private static String INSTALL_DIR = null;

    private static void initOSVersion() {
        String version = System.getProperty("os.version").toLowerCase();
        String script = OS_NAME.contains("windows") ? EXTEND_OS_VERSION_SCRIPT_BAT : EXTEND_OS_VERSION_SCRIPT_SHELL;
        File binary = new File((INSTALL_DIR != null ? INSTALL_DIR + File.separator : "") + script);
        if (binary.isFile()) {
            try {
                Process process = Runtime.getRuntime().exec(new String[]{binary.getAbsolutePath(), OS_NAME}, null, INSTALL_DIR != null ? new File(INSTALL_DIR) : null);
                StreamGobbler eStreamGobbler = new StreamGobbler(process.getErrorStream(), "os-version-error-stream");
                eStreamGobbler.start();
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                StreamGobbler oStreamGobbler = new StreamGobbler(process.getInputStream(), "os-version-output-stream");
                oStreamGobbler.doCaptureData((OutputStream)output);
                oStreamGobbler.start();
                int exitValue = process.waitFor();
                oStreamGobbler.waitForCompletion();
                if (exitValue == 0) {
                    String extension = output.toString();
                    extension = extension.replace('\n', ' ');
                    extension = extension.replace('\r', ' ');
                    if ((extension = extension.trim()) != null && extension.length() > 0) {
                        version = version + "-" + extension;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
            catch (InterruptedException e) {
                e.printStackTrace(System.err);
            }
        }
        OS_VERSION = version;
    }

    public static String getName() {
        return OS_NAME;
    }

    public static String getVersion() {
        if (OS_VERSION == null) {
            OSNameUtil.initOSVersion();
        }
        return OS_VERSION;
    }

    public static void setInstallDir(String installDir) {
        INSTALL_DIR = installDir;
    }
}

