/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.transport.onewayagent;

import com.singularity.ee.transport.onewayagent.IRequestStrategy;
import com.singularity.ee.transport.onewayagent.RequestHandlingStrategy;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class OneWayAgentExecutor
extends ThreadPoolExecutor {
    public static final String EXCLUSIVE_MODE_ERROR_MSG = "EXCLUSIVE mode does not allow more than one operation executing at a given time";
    private ConcurrentHashMap<Class<?>, LinkedBlockingQueue<IRequestStrategy>> serializedRequestClassVsQueue = new ConcurrentHashMap();

    public OneWayAgentExecutor(int corePoolSize, int maxPoolSize, long keepAliveTime, TimeUnit timeUnit, BlockingQueue<Runnable> runnables, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        super(corePoolSize, maxPoolSize, keepAliveTime, timeUnit, runnables, threadFactory, rejectedExecutionHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(IRequestStrategy handler) {
        block10: {
            RequestHandlingStrategy strategy = handler.getRequestHandlingStrategy();
            if (strategy == RequestHandlingStrategy.ASYNCHRONOUS) {
                super.execute(handler);
                return;
            }
            LinkedBlockingQueue<IRequestStrategy> queue = this.serializedRequestClassVsQueue.get(handler.getClass());
            if (queue == null) {
                LinkedBlockingQueue toInsert = new LinkedBlockingQueue();
                queue = this.serializedRequestClassVsQueue.putIfAbsent(handler.getClass(), toInsert);
                if (queue == null) {
                    queue = toInsert;
                }
            }
            LinkedBlockingQueue<IRequestStrategy> linkedBlockingQueue = queue;
            synchronized (linkedBlockingQueue) {
                block11: {
                    block9: {
                        if (!queue.isEmpty()) break block9;
                        queue.add(handler);
                        super.execute(handler);
                        break block10;
                    }
                    if (queue.remainingCapacity() <= 0) break block11;
                    switch (strategy) {
                        case SERIALIZED: {
                            queue.add(handler);
                            break block10;
                        }
                        default: {
                            throw new RejectedExecutionException("Unknown request handling strategy: " + (Object)((Object)strategy));
                        }
                    }
                }
                throw new RejectedExecutionException("Queue for:" + handler.getClass().getSimpleName() + "at capacity");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterExecute(Runnable runnable, Throwable throwable) {
        LinkedBlockingQueue<IRequestStrategy> queue;
        IRequestStrategy requestStrategy = (IRequestStrategy)runnable;
        if (requestStrategy.getRequestHandlingStrategy() == RequestHandlingStrategy.ASYNCHRONOUS) {
            return;
        }
        LinkedBlockingQueue<IRequestStrategy> linkedBlockingQueue = queue = this.serializedRequestClassVsQueue.get(requestStrategy.getClass());
        synchronized (linkedBlockingQueue) {
            assert (!queue.isEmpty());
            queue.remove();
            if (queue.isEmpty()) {
                return;
            }
            super.execute(queue.peek());
        }
    }
}

