/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.transport.onewayagent;

import com.singularity.ee.rest.RESTResponse;
import com.singularity.ee.rest.controller.request.OneWayAgentPayloadRequest;
import com.singularity.ee.transport.onewayagent.AServerRequestHandler;
import com.singularity.ee.transport.onewayagent.IRequestStrategy;
import com.singularity.ee.transport.onewayagent.IServerRequestHandlerFactory;
import com.singularity.ee.transport.onewayagent.OneWayAgentExecutor;
import com.singularity.ee.transport.onewayagent.RequestWrapper;
import com.singularity.ee.transport.onewayagent.ResponseWrapper;
import com.singularity.ee.util.httpclient.HttpExecutionResponse;
import com.singularity.ee.util.logging.ILogger;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@Deprecated
public class AgentTransport {
    public static final String ONE_WAY_AGENT_POLLING_PERIOD_PROPERTY = "com.singularity.onewayagent.polling.period";
    public static final long MIN_AGENT_POLLING_PERIOD_SEC = 1L;
    public static final long MAX_AGENT_POLLING_PERIOD_SEC = 30L;
    public static final String ASYNC_RESPONSE_OUTPUT = "Async request delivered to handler";
    private final ILogger logger;
    private final String controllerHost;
    private final int controllerPort;
    private final String machineId;
    private final OneWayAgentPoller poller;

    public AgentTransport(String controllerHost, int controllerPort, String machineId, ILogger logger) {
        if (controllerHost == null) {
            throw new NullPointerException("controller host is null");
        }
        if (controllerPort <= 0) {
            throw new IllegalArgumentException("controller port is illegal: " + controllerPort);
        }
        if (machineId == null) {
            throw new NullPointerException("machine id is null");
        }
        if (logger == null) {
            throw new NullPointerException("logger is null");
        }
        this.controllerHost = controllerHost;
        this.controllerPort = controllerPort;
        this.machineId = machineId;
        this.logger = logger;
        long pollingPeriodSecs = Long.getLong(ONE_WAY_AGENT_POLLING_PERIOD_PROPERTY, 2L);
        this.poller = new OneWayAgentPoller(pollingPeriodSecs);
    }

    public void start() {
        this.poller.start();
        this.logger.info("One-way agent transport is started");
    }

    public void shutdown() {
        this.poller.shutdown();
        this.logger.info("One-way agent transport is stopped");
    }

    public void registerServerRequestHandlerFactory(IServerRequestHandlerFactory handlerFactory) {
        this.poller.addRequestHandlerFactory(handlerFactory);
    }

    private class OneWayAgentPoller {
        private final OneWayAgentPollingTask pollingTask;
        private final long pollingPeriodMsecs;
        private final Map<String, IServerRequestHandlerFactory> locatorId2RequestHandlerFactory;
        private final OneWayAgentExecutor requestExecutor;
        private final ScheduledExecutorService scheduler;
        private volatile boolean shutdown;
        private volatile ScheduledFuture future;

        public OneWayAgentPoller(long pollingPeriodSecs) {
            if (pollingPeriodSecs < 1L || pollingPeriodSecs > 30L) {
                throw new IllegalStateException("One-way agent polling period is outside range of 1-30 sec: " + pollingPeriodSecs);
            }
            AgentTransport.this.logger.info("One-way agent polling period is set to " + pollingPeriodSecs + " sec");
            this.pollingPeriodMsecs = pollingPeriodSecs * 1000L;
            this.locatorId2RequestHandlerFactory = new HashMap<String, IServerRequestHandlerFactory>();
            ThreadFactory requestExecutorFactory = new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = new Thread(r, "One-Way Agent Request Handler Thread");
                    thread.setDaemon(true);
                    return thread;
                }
            };
            this.requestExecutor = new OneWayAgentExecutor(2, 2, Long.MAX_VALUE, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(100), requestExecutorFactory, new ThreadPoolExecutor.AbortPolicy());
            this.scheduler = Executors.newScheduledThreadPool(1, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = new Thread(r, "One-Way Agent Poller Thread");
                    thread.setDaemon(true);
                    thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                        @Override
                        public void uncaughtException(Thread t, Throwable e) {
                            AgentTransport.this.logger.error("One-way agent transport polling thread terminated abruptly", e);
                        }
                    });
                    return thread;
                }
            });
            this.pollingTask = new OneWayAgentPollingTask(this.requestExecutor, this.pollingPeriodMsecs);
        }

        public void addRequestHandlerFactory(IServerRequestHandlerFactory handlerFactory) {
            if (handlerFactory == null) {
                throw new NullPointerException("server request handler factory is null");
            }
            String locatorId = handlerFactory.getLocatorId();
            if (locatorId == null) {
                throw new NullPointerException("locator id is null");
            }
            if (this.locatorId2RequestHandlerFactory.containsKey(locatorId)) {
                throw new IllegalArgumentException("locator id is not unique: " + locatorId);
            }
            this.locatorId2RequestHandlerFactory.put(locatorId, handlerFactory);
        }

        public void start() {
            if (this.shutdown) {
                throw new IllegalStateException("poller has already been shut down");
            }
            this.requestExecutor.prestartAllCoreThreads();
            this.pollingTask.setHandlerFactories(this.locatorId2RequestHandlerFactory);
            this.future = this.scheduler.scheduleWithFixedDelay(this.pollingTask, 0L, this.pollingPeriodMsecs, TimeUnit.MILLISECONDS);
        }

        public void shutdown() {
            this.pollingTask.setNotRunning();
            if (this.future != null) {
                this.future.cancel(true);
            }
            this.scheduler.shutdown();
            this.requestExecutor.shutdownNow();
            this.shutdown = true;
        }
    }

    private class OneWayAgentPollingTask
    implements Runnable {
        private final OneWayAgentExecutor requestExecutor;
        private final long pollingPeriodMsecs;
        private final LinkedBlockingQueue<ResponseWrapper> responseQueue;
        private final List<ResponseWrapper> responseLocalCache;
        private Map<String, IServerRequestHandlerFactory> handlerFactories = Collections.emptyMap();
        private volatile boolean running;

        public OneWayAgentPollingTask(OneWayAgentExecutor requestExecutor, long pollingPeriodMsecs) {
            this.requestExecutor = requestExecutor;
            this.pollingPeriodMsecs = pollingPeriodMsecs;
            this.responseQueue = new LinkedBlockingQueue();
            this.responseLocalCache = new LinkedList<ResponseWrapper>();
            this.running = true;
        }

        public void setHandlerFactories(Map<String, IServerRequestHandlerFactory> handlerFactories) {
            this.handlerFactories = Collections.unmodifiableMap(new HashMap<String, IServerRequestHandlerFactory>(handlerFactories));
        }

        public void setNotRunning() {
            this.running = false;
        }

        @Override
        public void run() {
            List<ResponseWrapper> responseLocalCache = this.responseLocalCache;
            boolean hasMoreRequestsToProcess = true;
            block4: while (true) {
                try {
                    while (hasMoreRequestsToProcess) {
                        if (!this.running) {
                            return;
                        }
                        if (!this.responseQueue.isEmpty()) {
                            this.responseQueue.drainTo(responseLocalCache);
                        }
                        OneWayAgentPayloadRequest oneWayServerRequest = new OneWayAgentPayloadRequest(AgentTransport.this.controllerHost, AgentTransport.this.controllerPort, AgentTransport.this.machineId, AgentTransport.this.logger);
                        oneWayServerRequest.setAgentResponses(responseLocalCache);
                        HttpExecutionResponse response = oneWayServerRequest.sendRequest();
                        List<RequestWrapper> requests = Collections.emptyList();
                        if (response.getStatusCode() == 200) {
                            responseLocalCache.clear();
                            OneWayAgentPayloadRequest oneWayServerResponse = new OneWayAgentPayloadRequest(response.getResponseBodyAsStream(), AgentTransport.this.logger);
                            RESTResponse controllerResponse = oneWayServerResponse.getControllerResponse();
                            if (controllerResponse.isSuccessfullyExecuted()) {
                                requests = oneWayServerResponse.getControllerRequests();
                                this.handleServerRequests(this.handlerFactories, requests);
                            } else {
                                AgentTransport.this.logger.error("Failed to poll controller for requests: " + controllerResponse.getExecutionOutput());
                            }
                        }
                        try {
                            if (requests.isEmpty() && this.responseQueue.isEmpty()) {
                                hasMoreRequestsToProcess = false;
                                continue block4;
                            }
                            CountDownLatch latch = new CountDownLatch(1);
                            long waitTimeMsecs = 250L;
                            int maxNumLoops = (int)(this.pollingPeriodMsecs / 250L);
                            for (int numLoops = 0; numLoops < maxNumLoops && this.responseQueue.isEmpty(); ++numLoops) {
                                latch.await(250L, TimeUnit.MILLISECONDS);
                            }
                            hasMoreRequestsToProcess = !this.responseQueue.isEmpty();
                            continue block4;
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                    break;
                }
                catch (Throwable e) {
                    AgentTransport.this.logger.error("One-way agent encountered exception while polling", e);
                    break;
                }
            }
        }

        private void handleServerRequests(Map<String, IServerRequestHandlerFactory> handlerFactories, List<RequestWrapper> requests) throws Exception {
            if (requests.isEmpty()) {
                return;
            }
            for (RequestWrapper request : requests) {
                IServerRequestHandlerFactory handlerFactory = handlerFactories.get(request.getLocatorId());
                String errorMessage = null;
                if (handlerFactory == null) {
                    errorMessage = "Ignoring server request since no handler is registered with locator id: " + request.getLocatorId();
                    AgentTransport.this.logger.error(errorMessage);
                } else {
                    Object handler = handlerFactory.newHandlerInstance();
                    AgentTransport.this.logger.info("Agent transport is handling server request with handler: " + handler.getClass().getSimpleName() + "; locator id=" + request.getLocatorId());
                    ((AServerRequestHandler)handler).setServerRequest(request);
                    ((AServerRequestHandler)handler).setResponseQueue(this.responseQueue);
                    ((AServerRequestHandler)handler).setAgentContext(AgentTransport.this.controllerHost, AgentTransport.this.controllerPort, AgentTransport.this.machineId);
                    boolean isAsyncResponse = ((AServerRequestHandler)handler).isServerResponseAsynchronous();
                    try {
                        this.requestExecutor.execute((IRequestStrategy)handler);
                        if (isAsyncResponse) {
                            HttpExecutionResponse response = RESTResponse.createSuccessResponse(AgentTransport.ASYNC_RESPONSE_OUTPUT);
                            this.responseQueue.add(new ResponseWrapper(response, request));
                        }
                    }
                    catch (RejectedExecutionException e) {
                        errorMessage = "Agent request handling queue rejected handler execution; remaining queue capacity=" + this.requestExecutor.getQueue().remainingCapacity();
                        AgentTransport.this.logger.error(errorMessage, (Throwable)e);
                    }
                }
                if (errorMessage == null) continue;
                HttpExecutionResponse failureResponse = new HttpExecutionResponse();
                failureResponse.setStatusCode(500);
                failureResponse.setExceptionHappened(true);
                failureResponse.setExceptionMessage(errorMessage);
                this.responseQueue.add(new ResponseWrapper(failureResponse, request));
            }
        }
    }
}

