/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.transport.onewayagent;

import com.singularity.ee.transport.onewayagent.IRequestStrategy;
import com.singularity.ee.transport.onewayagent.RequestWrapper;
import com.singularity.ee.transport.onewayagent.ResponseWrapper;
import com.singularity.ee.util.httpclient.HttpExecutionRequest;
import com.singularity.ee.util.httpclient.HttpExecutionResponse;
import java.util.concurrent.LinkedBlockingQueue;

public abstract class AServerRequestHandler
implements IRequestStrategy {
    private RequestWrapper requestWrapper;
    private LinkedBlockingQueue<ResponseWrapper> responseQueue;
    private String controllerHost;
    private int controllerPort;
    private String machineId;

    public final void setResponseQueue(LinkedBlockingQueue<ResponseWrapper> responseQueue) {
        if (responseQueue == null) {
            throw new NullPointerException("response queue is null");
        }
        this.responseQueue = responseQueue;
    }

    public final void setServerRequest(RequestWrapper requestWrapper) {
        if (requestWrapper == null) {
            throw new NullPointerException("request is null");
        }
        this.requestWrapper = requestWrapper;
    }

    public void setAgentContext(String controllerHost, int controllerPort, String machineId) {
        if (controllerHost == null) {
            throw new NullPointerException("controller host is null");
        }
        if (machineId == null) {
            throw new NullPointerException("machine id is null");
        }
        if (controllerPort <= 0) {
            throw new IllegalArgumentException("controller port is illegal: " + controllerPort);
        }
        this.controllerHost = controllerHost;
        this.controllerPort = controllerPort;
        this.machineId = machineId;
    }

    public abstract boolean isServerResponseAsynchronous();

    @Override
    public abstract void run();

    protected final HttpExecutionRequest getServerRequest() {
        return this.requestWrapper.getRequest();
    }

    protected final String getControllerHost() {
        return this.controllerHost;
    }

    protected final int getControllerPort() {
        return this.controllerPort;
    }

    protected final String getMachineId() {
        return this.machineId;
    }

    protected final void sendAgentResponse(HttpExecutionResponse response) {
        if (this.isServerResponseAsynchronous()) {
            throw new IllegalStateException("server request is asynchronous");
        }
        this.responseQueue.add(new ResponseWrapper(response, this.requestWrapper));
    }
}

