/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.transactiondefinition.config.xml.spring.beans;

import com.appdynamics.org.w3c.dom.Element;
import com.appdynamics.org.w3c.dom.Node;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.IMatchPointRule;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.StringMatch;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.spring.beans.SpringBeanMatchRule;
import com.singularity.ee.transactiondefinition.config.xml.AMatchRuleParser;
import com.singularity.ee.transactiondefinition.config.xml.IMatchPointRuleParser;
import com.singularity.ee.transactiondefinition.config.xml.ParserUtil;
import com.singularity.ee.transactiondefinition.config.xml.spring.beans.SpringBeanEntryPointTagNames;
import com.singularity.ee.util.xml.XMLParseUtility;
import java.util.List;

public class SpringBeanMatchRuleParser
extends AMatchRuleParser
implements SpringBeanEntryPointTagNames,
IMatchPointRuleParser {
    private SpringBeanMatchRule springBeanMatchRule = new SpringBeanMatchRule();

    @Override
    public String getMatchRuleTagName() {
        return "spring-bean-rule";
    }

    @Override
    public IMatchPointRule parseMatchRule(Element matchRuleElement) {
        this.springBeanMatchRule = new SpringBeanMatchRule();
        AMatchRuleParser.parseCommon(matchRuleElement, (IMatchPointRule)this.springBeanMatchRule);
        return this.parse(matchRuleElement);
    }

    public SpringBeanMatchRule parse(Element SpringBeanMatchRuleElement) {
        this.setSpringBeanIDData(SpringBeanMatchRuleElement);
        this.setBusinessIntfData(SpringBeanMatchRuleElement);
        this.setExtendsClassData(SpringBeanMatchRuleElement);
        this.setClassNameData(SpringBeanMatchRuleElement);
        this.setMethodMatchData(SpringBeanMatchRuleElement);
        return this.springBeanMatchRule;
    }

    private void setSpringBeanIDData(Element matchRuleElement) {
        Element springBeanIDElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)matchRuleElement, "bean-id");
        if (springBeanIDElement != null) {
            StringMatch stringData = ParserUtil.convertNode(springBeanIDElement);
            this.springBeanMatchRule.setBeanID(stringData);
        }
    }

    private void setBusinessIntfData(Element matchRuleElement) {
        Element businessIntfElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)matchRuleElement, "implements-business-interface");
        if (businessIntfElement != null) {
            StringMatch stringData = ParserUtil.convertNode(businessIntfElement);
            this.springBeanMatchRule.setBusinessIntf(stringData);
        }
    }

    private void setExtendsClassData(Element matchRuleElement) {
        Element extendsClassElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)matchRuleElement, "extends-from-class");
        if (extendsClassElement != null) {
            StringMatch stringData = ParserUtil.convertNode(extendsClassElement);
            this.springBeanMatchRule.setExtendsFromClass(stringData);
        }
    }

    private void setClassNameData(Element matchRuleElement) {
        Element classNameElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)matchRuleElement, "class-name");
        if (classNameElement != null) {
            StringMatch stringData = ParserUtil.convertNode(classNameElement);
            this.springBeanMatchRule.setClassName(stringData);
        }
    }

    private void setMethodMatchData(Element matchRuleElement) {
        List<Element> methodMatchNodes = XMLParseUtility.getListOfDirectSiblingsUnderWithName((Node)matchRuleElement, "match-method");
        StringMatch[] methodMatchData = new StringMatch[methodMatchNodes.size()];
        int i = 0;
        for (Element methodMatchNode : methodMatchNodes) {
            methodMatchData[i++] = ParserUtil.convertNode(XMLParseUtility.getFirstDirectChildUnderWithName((Node)methodMatchNode, "name"));
        }
        if (methodMatchData.length != 0) {
            this.springBeanMatchRule.setMethodMatchData(methodMatchData);
        }
    }
}

