/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.transactiondefinition.config.xml.pojo;

import com.appdynamics.org.w3c.dom.Element;
import com.appdynamics.org.w3c.dom.Node;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.IMatchPointRule;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.StringMatch;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.pojo.POJOMatchRule;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.pojo.POJOMatchType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.pojo.POJOMatchTypeHelper;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.pojo.SplitConfig;
import com.singularity.ee.transactiondefinition.config.xml.AMatchRuleParser;
import com.singularity.ee.transactiondefinition.config.xml.IMatchPointRuleParser;
import com.singularity.ee.transactiondefinition.config.xml.ParserUtil;
import com.singularity.ee.util.collections.CollectionHelper;
import com.singularity.ee.util.string.StringOperations;
import com.singularity.ee.util.xml.XMLParseUtility;
import java.util.ArrayList;
import java.util.List;

public class POJOMatchRuleParser
extends AMatchRuleParser
implements IMatchPointRuleParser {
    protected POJOMatchRule getMatchRule(POJOMatchType matchClassType, StringMatch classMatch, StringMatch[] methodMatch) {
        return new POJOMatchRule(matchClassType, classMatch, methodMatch);
    }

    @Override
    public String getMatchRuleTagName() {
        return "pojo-rule";
    }

    @Override
    public IMatchPointRule parseMatchRule(Element matchRuleElement) {
        return this.parse(matchRuleElement);
    }

    public POJOMatchRule parse(Element pojoRuleElement) {
        Element excludeElement;
        Element matchClassElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)pojoRuleElement, "match-class");
        POJOMatchType matchClassType = POJOMatchTypeHelper.getEnumValue((String)XMLParseUtility.getAttributeMapForElement(matchClassElement).get("type"));
        StringMatch classMatchData = ParserUtil.convertNode(XMLParseUtility.getFirstDirectChildUnderWithName((Node)matchClassElement, "name"));
        String displayName = XMLParseUtility.getTextForTagForElement((Node)pojoRuleElement, "display-name");
        boolean isBackgroundTask = Boolean.parseBoolean(XMLParseUtility.getTextForTagForElement((Node)pojoRuleElement, "background"));
        List<Element> methodMatchNodes = XMLParseUtility.getListOfDirectSiblingsUnderWithName((Node)pojoRuleElement, "match-method");
        StringMatch[] methodMatchData = new StringMatch[methodMatchNodes.size()];
        int i = 0;
        for (Element methodMatchNode : methodMatchNodes) {
            methodMatchData[i++] = ParserUtil.convertNode(XMLParseUtility.getFirstDirectChildUnderWithName((Node)methodMatchNode, "name"));
        }
        POJOMatchRule matchRule = this.getMatchRule(matchClassType, classMatchData, methodMatchData);
        AMatchRuleParser.parseCommon(pojoRuleElement, (IMatchPointRule)matchRule);
        matchRule.setDisplayName(displayName);
        matchRule.setBackgroundTask(isBackgroundTask);
        List<Element> splitConfigElements = XMLParseUtility.getListOfDirectSiblingsUnderWithName((Node)pojoRuleElement, "split-config");
        ArrayList<SplitConfig> splitConfigList = new ArrayList<SplitConfig>();
        for (Element splitConfigElement : splitConfigElements) {
            if (splitConfigElement == null) continue;
            String operationTypeStr = splitConfigElement.getAttribute("type");
            int operationType = StringOperations.safeParseInteger((String)operationTypeStr, (int)0);
            String operation = splitConfigElement.getAttribute("operation");
            SplitConfig splitConfig = new SplitConfig();
            splitConfig.setSplitOperation(operation);
            splitConfig.setSplitOperationType(operationType);
            splitConfigList.add(splitConfig);
        }
        if (!splitConfigList.isEmpty()) {
            matchRule.setSplitConfig((SplitConfig[])CollectionHelper.collectionToArray(splitConfigList, (Object[])new SplitConfig[splitConfigList.size()]));
        }
        if ((excludeElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)pojoRuleElement, "split-exclude")) != null) {
            matchRule.setExcludes(ParserUtil.convertNode(excludeElement));
        }
        return matchRule;
    }
}

