/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.transactiondefinition.config.xml.pojo;

import com.appdynamics.javax.xml.parsers.ParserConfigurationException;
import com.appdynamics.org.w3c.dom.Element;
import com.appdynamics.org.w3c.dom.Node;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.IMatchPointRule;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.StringMatch;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.pojo.POJOMatchRule;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.pojo.POJOMatchType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.pojo.POJOMatchTypeHelper;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.pojo.SplitConfig;
import com.singularity.ee.transactiondefinition.config.xml.AMatchRuleGenerator;
import com.singularity.ee.transactiondefinition.config.xml.ParserUtil;
import com.singularity.ee.util.string.StringOperations;
import com.singularity.ee.util.xml.XMLWriter;
import java.util.HashMap;

public class POJOMatchRuleGenerator
extends AMatchRuleGenerator {
    @Override
    public String getMatchRuleTagName() {
        return "pojo-rule";
    }

    @Override
    public Element addMatchRuleDetail(XMLWriter writer, Element pojoRuleElement, IMatchPointRule rule) throws ParserConfigurationException {
        POJOMatchRule pojoMatchRule = (POJOMatchRule)rule;
        StringMatch classMatch = pojoMatchRule.getClassMatch();
        if (classMatch == null || StringMatch.isEmptyPattern((String)classMatch.getMatchPattern())) {
            throw new IllegalArgumentException("Class name is not specified");
        }
        if (pojoMatchRule.getDisplayName() != null) {
            writer.addTextNode(pojoRuleElement, "display-name", pojoMatchRule.getDisplayName());
        }
        writer.addTextNode(pojoRuleElement, "background", String.valueOf(pojoMatchRule.isBackgroundTask()));
        Element classMatchElement = writer.createElement("match-class");
        classMatchElement.setAttribute("type", POJOMatchTypeHelper.getStringValue((POJOMatchType)pojoMatchRule.getMatchClassType()));
        writer.addTextNode(classMatchElement, "name", ParserUtil.getAttributesFor(classMatch));
        pojoRuleElement.appendChild((Node)classMatchElement);
        StringMatch[] methodMatches = pojoMatchRule.getMethodMatch();
        if (methodMatches == null || StringMatch.isEmptyPattern((String)methodMatches[0].getMatchPattern())) {
            throw new IllegalArgumentException("Method name is not specified");
        }
        if (methodMatches.length > 1) {
            throw new IllegalArgumentException("Cannot not specify more than one method match");
        }
        Element matchMethodElement = writer.createElement("match-method");
        for (StringMatch methodMatch : methodMatches) {
            writer.addTextNode(matchMethodElement, "name", ParserUtil.getAttributesFor(methodMatch));
        }
        SplitConfig[] splitConfigs = pojoMatchRule.getSplitConfig();
        if (null != splitConfigs) {
            for (SplitConfig sc : splitConfigs) {
                this.addSplitConfigDetail(writer, pojoRuleElement, sc);
            }
        }
        SplitConfig splitConfig = new SplitConfig();
        splitConfig.setSplitOperation(pojoMatchRule.getSplitOperation());
        splitConfig.setSplitOperationType(pojoMatchRule.getSplitOperationType());
        this.addSplitConfigDetail(writer, pojoRuleElement, splitConfig);
        if (pojoMatchRule.getExcludes() != null) {
            writer.addTextNode(pojoRuleElement, "split-exclude", ParserUtil.getAttributesFor(pojoMatchRule.getExcludes()));
        }
        pojoRuleElement.appendChild((Node)matchMethodElement);
        return pojoRuleElement;
    }

    private void addSplitConfigDetail(XMLWriter writer, Element pojoRuleElement, SplitConfig splitConfig) {
        if (splitConfig.getSplitOperationType() == 0) {
            return;
        }
        HashMap<String, String> operations = new HashMap<String, String>();
        operations.put("type", String.valueOf(splitConfig.getSplitOperationType()));
        if (!StringOperations.isEmpty((String)splitConfig.getSplitOperation())) {
            operations.put("operation", String.valueOf(splitConfig.getSplitOperation()));
        }
        writer.addTextNode(pojoRuleElement, "split-config", operations);
    }
}

