/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.transactiondefinition.config.xml.jms;

import com.appdynamics.org.w3c.dom.Element;
import com.appdynamics.org.w3c.dom.Node;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.IMatchPointRule;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.StringMatch;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.jms.DestinationMatchData;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.jms.JMSPropertyType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.jms.MessageContentMatchData;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.jms.MessageDestinationType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.jms.MessageMatchRule;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.jms.MessagePropertyMatchData;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.jms.MessageType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.jms.PropertyMatchTypeHelper;
import com.singularity.ee.transactiondefinition.config.xml.AMatchRuleParser;
import com.singularity.ee.transactiondefinition.config.xml.IMatchPointRuleParser;
import com.singularity.ee.transactiondefinition.config.xml.ParserUtil;
import com.singularity.ee.util.enums.EnumHelper;
import com.singularity.ee.util.xml.XMLParseUtility;
import java.util.List;

public class MessageMatchRuleParser
extends AMatchRuleParser
implements IMatchPointRuleParser {
    private MessageMatchRule messageMatchRule = this.getMatchRule();

    @Override
    public String getMatchRuleTagName() {
        return "incoming-message-rule";
    }

    protected MessageMatchRule getMatchRule() {
        return new MessageMatchRule();
    }

    @Override
    public IMatchPointRule parseMatchRule(Element matchRuleElement) {
        this.messageMatchRule = this.getMatchRule();
        return this.parse(matchRuleElement);
    }

    public MessageMatchRule parse(Element messageMatchRuleElement) {
        AMatchRuleParser.parseCommon(messageMatchRuleElement, (IMatchPointRule)this.messageMatchRule);
        this.setJMSCorrelationID(messageMatchRuleElement);
        this.setMessagePropertyMatchData(messageMatchRuleElement);
        this.setMessageDestinationData(messageMatchRuleElement);
        this.setMessageContentData(messageMatchRuleElement);
        return this.messageMatchRule;
    }

    private void setJMSCorrelationID(Element messageMatchRuleElement) {
        Element corIDElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)messageMatchRuleElement, "jms-correlation-id");
        if (corIDElement != null) {
            StringMatch stringData = ParserUtil.convertNode(messageMatchRuleElement);
            this.messageMatchRule.setJmsCorrelationID(stringData);
        }
    }

    private void setMessagePropertyMatchData(Element messageMatchRuleElement) {
        Element messagePropertiesElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)messageMatchRuleElement, "message-properties");
        if (messagePropertiesElement != null) {
            this.messageMatchRule.setMessageProperties(this.getMapMessageMatchData(messagePropertiesElement));
        }
    }

    private void setMessageDestinationData(Element messageMatchRuleElement) {
        Element destinationElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)messageMatchRuleElement, "message-destination");
        if (destinationElement != null) {
            MessageDestinationType destinationType = (MessageDestinationType)EnumHelper.getEnum(MessageDestinationType.class, (String)XMLParseUtility.getAttributeMapForElement(destinationElement).get("type"));
            Element nameElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)destinationElement, "destination-name");
            StringMatch nameData = null;
            if (nameElement != null) {
                nameData = ParserUtil.convertNode(nameElement);
            }
            DestinationMatchData destinationData = new DestinationMatchData(destinationType, nameData);
            this.messageMatchRule.setDestination(destinationData);
        }
    }

    private void setMessageContentData(Element messageMatchRuleElement) {
        Element messageContentElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)messageMatchRuleElement, "message-content");
        if (messageContentElement != null) {
            MessageType messageType = (MessageType)EnumHelper.getEnum(MessageType.class, (String)XMLParseUtility.getAttributeMapForElement(messageContentElement).get("message-type").toUpperCase());
            MessageContentMatchData messageContentData = new MessageContentMatchData();
            messageContentData.setMessageMatchType(messageType);
            if (messageType == MessageType.TEXT) {
                Element textMsgElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)messageContentElement, "text-message");
                StringMatch textMessageData = ParserUtil.convertNode(XMLParseUtility.getFirstDirectChildUnderWithName((Node)textMsgElement, "text"));
                messageContentData.setTextMessageMatchData(textMessageData);
            }
            if (messageType == MessageType.MAP) {
                messageContentData.setMapMessageMatchData(this.getMapMessageMatchData(XMLParseUtility.getFirstDirectChildUnderWithName((Node)messageContentElement, "map-message")));
            }
            this.messageMatchRule.setMessageContent(messageContentData);
        }
    }

    private MessagePropertyMatchData[] getMapMessageMatchData(Element mapMessageElement) {
        List<Element> propertyNodes = XMLParseUtility.getListOfDirectSiblingsUnderWithName((Node)mapMessageElement, "property");
        MessagePropertyMatchData[] messagePropertyMatches = new MessagePropertyMatchData[propertyNodes.size()];
        int i = 0;
        for (Element propertyElement : propertyNodes) {
            MessagePropertyMatchData matchData = new MessagePropertyMatchData();
            String name = XMLParseUtility.getAttributeMapForElement(propertyElement).get("name");
            matchData.setName(name);
            String matchType = XMLParseUtility.getAttributeMapForElement(propertyElement).get("match-type");
            if (matchType == null || matchType.trim().length() == 0) {
                throw new IllegalArgumentException("Message property type is not specified for " + name);
            }
            matchData.setMatchType(PropertyMatchTypeHelper.getEnumValue((String)matchType.toLowerCase()));
            String type = XMLParseUtility.getAttributeMapForElement(propertyElement).get("type");
            if (type == null || type.trim().length() == 0) {
                throw new IllegalArgumentException("Property type is not specified for " + name);
            }
            try {
                matchData.setType((JMSPropertyType)EnumHelper.getEnum(JMSPropertyType.class, (String)type.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid property type " + type + " specified for " + name);
            }
            Element valueElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)propertyElement, "value");
            if (valueElement != null) {
                StringMatch valueData = ParserUtil.convertNode(valueElement);
                matchData.setValue(valueData);
            }
            messagePropertyMatches[i++] = matchData;
        }
        return messagePropertyMatches;
    }
}

