/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.transactiondefinition.config.xml.jms;

import com.appdynamics.javax.xml.parsers.ParserConfigurationException;
import com.appdynamics.org.w3c.dom.Element;
import com.appdynamics.org.w3c.dom.Node;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.IMatchPointRule;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.StringMatch;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.jms.DestinationMatchData;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.jms.JMSPropertyType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.jms.MessageContentMatchData;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.jms.MessageDestinationType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.jms.MessageMatchRule;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.jms.MessagePropertyMatchData;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.jms.PropertyMatchType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.jms.PropertyMatchTypeHelper;
import com.singularity.ee.transactiondefinition.config.xml.AMatchRuleGenerator;
import com.singularity.ee.transactiondefinition.config.xml.ParserUtil;
import com.singularity.ee.util.enums.EnumHelper;
import com.singularity.ee.util.xml.XMLWriter;

public class MessageMatchRuleGenerator
extends AMatchRuleGenerator {
    @Override
    public String getMatchRuleTagName() {
        return "incoming-message-rule";
    }

    @Override
    public Element addMatchRuleDetail(XMLWriter writer, Element messageRuleElement, IMatchPointRule rule) throws ParserConfigurationException {
        MessageMatchRule messageMatchRule = (MessageMatchRule)rule;
        if (messageMatchRule.getJmsCorrelationID() != null) {
            writer.addTextNode(messageRuleElement, "jms-correlation-id", ParserUtil.getAttributesFor(messageMatchRule.getJmsCorrelationID()));
        }
        if (messageMatchRule.getMessageProperties() != null) {
            messageRuleElement.appendChild((Node)this.getMessagePropertiesElement(writer, messageMatchRule.getMessageProperties()));
        }
        if (messageMatchRule.getDestination() != null) {
            messageRuleElement.appendChild((Node)this.getMessageDestinationElement(writer, messageMatchRule.getDestination()));
        }
        if (messageMatchRule.getMessageContent() != null) {
            messageRuleElement.appendChild((Node)this.getMessageContentElement(writer, messageMatchRule.getMessageContent()));
        }
        return messageRuleElement;
    }

    private Element getMessagePropertiesElement(XMLWriter writer, MessagePropertyMatchData[] messagePropertyData) throws ParserConfigurationException {
        Element messagePropertiesElement = writer.createElement("message-properties");
        this.appendMessageProperties(writer, messagePropertyData, messagePropertiesElement);
        return messagePropertiesElement;
    }

    private void appendMessageProperties(XMLWriter writer, MessagePropertyMatchData[] properties, Element parentEle) {
        for (MessagePropertyMatchData messageProperty : properties) {
            Element propertyElement = writer.createElement("property");
            String name = messageProperty.getName();
            if (name == null || name.trim().length() == 0) {
                throw new IllegalArgumentException("One of the property name is not specified");
            }
            propertyElement.setAttribute("name", name);
            PropertyMatchType matchType = messageProperty.getMatchType();
            if (matchType == null) {
                throw new IllegalArgumentException("Message property type is not specified for " + name);
            }
            propertyElement.setAttribute("match-type", PropertyMatchTypeHelper.getStringValue((PropertyMatchType)matchType));
            JMSPropertyType jmsPropertyType = messageProperty.getType();
            if (jmsPropertyType == null) {
                throw new IllegalArgumentException("Property type is not specified for " + name);
            }
            propertyElement.setAttribute("type", EnumHelper.getName((Enum)jmsPropertyType, (Enum)jmsPropertyType).toLowerCase());
            if (messageProperty.getValue() != null) {
                writer.addTextNode(propertyElement, "value", ParserUtil.getAttributesFor(messageProperty.getValue()));
            }
            parentEle.appendChild((Node)propertyElement);
        }
    }

    public Element getMessageDestinationElement(XMLWriter writer, DestinationMatchData destinationData) throws ParserConfigurationException {
        Element messageDestinationElement = writer.createElement("message-destination");
        MessageDestinationType destinationType = destinationData.getDestinationType();
        if (destinationType == null) {
            throw new IllegalArgumentException("Destination type is not specified");
        }
        messageDestinationElement.setAttribute("type", EnumHelper.getName((Enum)destinationType, (Enum)destinationType));
        StringMatch destinationNameData = destinationData.getDestinationNameData();
        if (StringMatch.isEmpty((StringMatch)destinationNameData)) {
            throw new IllegalArgumentException("Destination name match is not specified");
        }
        writer.addTextNode(messageDestinationElement, "destination-name", ParserUtil.getAttributesFor(destinationNameData));
        return messageDestinationElement;
    }

    public Element getMessageContentElement(XMLWriter writer, MessageContentMatchData contentData) throws ParserConfigurationException {
        Element messageContentElement = writer.createElement("message-content");
        if (contentData.getMessageMatchType() != null) {
            messageContentElement.setAttribute("message-type", EnumHelper.getName((Enum)contentData.getMessageMatchType(), (Enum)contentData.getMessageMatchType()));
        }
        if (contentData.getTextMessageMatchData() != null) {
            Element textMessageElement = writer.createElement("text-message");
            writer.addTextNode(textMessageElement, "text", ParserUtil.getAttributesFor(contentData.getTextMessageMatchData()));
            messageContentElement.appendChild((Node)textMessageElement);
        }
        if (contentData.getMapMessageMatchData() != null) {
            Element mapMessageElement = writer.createElement("map-message");
            this.appendMessageProperties(writer, contentData.getMapMessageMatchData(), mapMessageElement);
            messageContentElement.appendChild((Node)mapMessageElement);
        }
        return messageContentElement;
    }
}

