/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.transactiondefinition.config.xml.http.servlet;

import com.appdynamics.org.w3c.dom.Element;
import com.appdynamics.org.w3c.dom.Node;
import com.singularity.ee.controller.api.dto.NameValuePair;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.IMatchPointRule;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.MethodTransactionSplitConfig;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.StringMatch;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.XMLJavaBindingConfig;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.XPathExpressionConfig;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.http.HTTPMethod;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.http.servlet.CookieMatchData;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.http.servlet.HTTPParameterMatchData;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.http.servlet.ParameterMatchType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.http.servlet.ParameterMatchTypeHelper;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.http.servlet.ServletMatchRule;
import com.singularity.ee.transactiondefinition.config.xml.AMatchRuleParser;
import com.singularity.ee.transactiondefinition.config.xml.IMatchPointRuleParser;
import com.singularity.ee.transactiondefinition.config.xml.ParserUtil;
import com.singularity.ee.util.collections.CollectionHelper;
import com.singularity.ee.util.enums.EnumHelper;
import com.singularity.ee.util.exceptionop.ExceptionOperations;
import com.singularity.ee.util.xml.XMLParseUtility;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ServletMatchRuleParser
extends AMatchRuleParser
implements IMatchPointRuleParser {
    protected ServletMatchRule servletMatchRule = this.getMatchRule();

    @Override
    public String getMatchRuleTagName() {
        return "servlet-rule";
    }

    @Override
    public IMatchPointRule parseMatchRule(Element matchRuleElement) {
        this.servletMatchRule = this.getMatchRule();
        AMatchRuleParser.parseCommon(matchRuleElement, (IMatchPointRule)this.servletMatchRule);
        return this.parse(matchRuleElement);
    }

    protected ServletMatchRule getMatchRule() {
        return new ServletMatchRule();
    }

    public ServletMatchRule parse(Element servletMatchRuleElement) {
        this.setHTTPMethod(servletMatchRuleElement);
        this.setClassNameData(servletMatchRuleElement);
        this.setURI(servletMatchRuleElement);
        this.setServletNameData(servletMatchRuleElement);
        this.setPort(servletMatchRuleElement);
        this.setHost(servletMatchRuleElement);
        this.setParameters(servletMatchRuleElement);
        this.setHeaders(servletMatchRuleElement);
        this.setCookies(servletMatchRuleElement);
        this.setXPathConfiguration(servletMatchRuleElement);
        this.setXMLJavaBindingConfig(servletMatchRuleElement);
        this.setPOJOSplitConfig(servletMatchRuleElement);
        this.setRuleProperties(servletMatchRuleElement);
        return this.servletMatchRule;
    }

    protected void setClassNameData(Element matchRuleElement) {
        Element classNameElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)matchRuleElement, "class-name");
        if (classNameElement != null) {
            StringMatch stringData = ParserUtil.convertNode(classNameElement);
            this.servletMatchRule.setClassName(stringData);
        }
    }

    protected void setURI(Element matchRuleElement) {
        Element uriElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)matchRuleElement, "uri");
        if (uriElement != null) {
            StringMatch stringData = ParserUtil.convertNode(uriElement);
            this.servletMatchRule.setUri(stringData);
        }
    }

    protected void setServletNameData(Element matchRuleElement) {
        Element servletNameElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)matchRuleElement, "servlet-name");
        if (servletNameElement != null) {
            StringMatch stringData = ParserUtil.convertNode(servletNameElement);
            this.servletMatchRule.setServletName(stringData);
        }
    }

    protected void setPort(Element matchRuleElement) {
        Element portElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)matchRuleElement, "port");
        if (portElement != null) {
            StringMatch stringData = ParserUtil.convertNode(portElement);
            this.servletMatchRule.setPort(stringData);
        }
    }

    protected void setHost(Element matchRuleElement) {
        Element hostNameElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)matchRuleElement, "host");
        if (hostNameElement != null) {
            StringMatch stringData = ParserUtil.convertNode(hostNameElement);
            this.servletMatchRule.setHost(stringData);
        }
    }

    protected void setParameters(Element matchRuleElement) {
        Element paramElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)matchRuleElement, "parameters");
        ArrayList<HTTPParameterMatchData> params = new ArrayList<HTTPParameterMatchData>();
        if (paramElement != null) {
            List<Element> parameters = XMLParseUtility.getListOfDirectSiblingsUnderWithName((Node)paramElement, "parameter");
            for (Element parameter : parameters) {
                HTTPParameterMatchData paramData = this.getParameterData(parameter);
                if (paramData == null) continue;
                params.add(paramData);
            }
        }
        if (params != null && !params.isEmpty()) {
            this.servletMatchRule.setParameters((HTTPParameterMatchData[])CollectionHelper.collectionToArray(params, (Object[])new HTTPParameterMatchData[params.size()]));
        }
    }

    protected void setHeaders(Element matchRuleElement) {
        Element headerElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)matchRuleElement, "headers");
        ArrayList<HTTPParameterMatchData> params = new ArrayList<HTTPParameterMatchData>();
        if (headerElement != null) {
            List<Element> headers = XMLParseUtility.getListOfDirectSiblingsUnderWithName((Node)headerElement, "header");
            for (Element header : headers) {
                HTTPParameterMatchData paramData = this.getParameterData(header);
                if (paramData == null) continue;
                params.add(paramData);
            }
        }
        if (params != null && !params.isEmpty()) {
            this.servletMatchRule.setHeaders((HTTPParameterMatchData[])CollectionHelper.collectionToArray(params, (Object[])new HTTPParameterMatchData[params.size()]));
        }
    }

    protected void setCookies(Element matchRuleElement) {
        ArrayList<CookieMatchData> cookies = new ArrayList<CookieMatchData>();
        Element cookiesElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)matchRuleElement, "cookies");
        if (cookiesElement != null) {
            List<Element> cookiesList = XMLParseUtility.getListOfDirectSiblingsUnderWithName((Node)cookiesElement, "cookie");
            for (Element cookie : cookiesList) {
                CookieMatchData cookieData = this.getCookieData(cookie);
                if (cookieData == null) continue;
                cookies.add(cookieData);
            }
        }
        if (cookies != null && !cookies.isEmpty()) {
            this.servletMatchRule.setCookies((CookieMatchData[])CollectionHelper.collectionToArray(cookies, (Object[])new CookieMatchData[cookies.size()]));
        }
    }

    protected HTTPParameterMatchData getParameterData(Element paramElement) {
        HTTPParameterMatchData paramData = new HTTPParameterMatchData();
        try {
            ParameterMatchType matchType = ParameterMatchTypeHelper.getEnumValue((String)XMLParseUtility.getAttributeMapForElement(paramElement).get("match-type"));
            paramData.setMatchType(matchType);
            Element nameElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)paramElement, "name");
            paramData.setName(ParserUtil.convertNode(nameElement));
            Element valueElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)paramElement, "value");
            if (valueElement != null) {
                paramData.setValue(ParserUtil.convertNode(valueElement));
            }
            return paramData;
        }
        catch (IllegalArgumentException e) {
            ExceptionOperations.printStackTrace((Throwable)e);
            return null;
        }
    }

    protected CookieMatchData getCookieData(Element cookieElement) {
        CookieMatchData cookieData = new CookieMatchData();
        try {
            Element pathElement;
            ParameterMatchType matchType = ParameterMatchTypeHelper.getEnumValue((String)XMLParseUtility.getAttributeMapForElement(cookieElement).get("match-type"));
            cookieData.setMatchType(matchType);
            Element nameElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)cookieElement, "name");
            cookieData.setName(ParserUtil.convertNode(nameElement));
            Element valueElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)cookieElement, "value");
            if (valueElement != null) {
                cookieData.setValue(ParserUtil.convertNode(valueElement));
            }
            if ((pathElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)cookieElement, "path")) != null) {
                cookieData.setValue(ParserUtil.convertNode(pathElement));
            }
            return cookieData;
        }
        catch (IllegalArgumentException e) {
            ExceptionOperations.printStackTrace((Throwable)e);
            return null;
        }
    }

    protected void setHTTPMethod(Element matchRuleElement) {
        String httpMethod = XMLParseUtility.getTextForTagForElement((Node)matchRuleElement, "http-method");
        if (httpMethod != null) {
            try {
                this.servletMatchRule.setHttpMethod((HTTPMethod)EnumHelper.getEnum(HTTPMethod.class, (String)httpMethod));
            }
            catch (IllegalArgumentException e) {
                ExceptionOperations.printStackTrace((Throwable)e);
            }
        }
    }

    protected void setXPathConfiguration(Element matchRuleElement) {
        Element xPathConfigElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)matchRuleElement, "x-path-config");
        if (xPathConfigElement != null) {
            List<Element> xPathExpressionElements = XMLParseUtility.getListOfDirectSiblingsUnderWithName((Node)xPathConfigElement, "x-path-expression");
            ArrayList<XPathExpressionConfig> configList = new ArrayList<XPathExpressionConfig>();
            for (Element xPathExpressionElement : xPathExpressionElements) {
                configList.add(new XPathExpressionConfig(Boolean.parseBoolean(xPathExpressionElement.getAttribute("optional")), xPathExpressionElement.getAttribute("value")));
            }
            this.servletMatchRule.setXpathExpressionConfig((XPathExpressionConfig[])CollectionHelper.collectionToArray(configList, (Object[])new XPathExpressionConfig[configList.size()]));
        }
    }

    protected void setXMLJavaBindingConfig(Element matchRuleElement) {
        Element bindingConfigElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)matchRuleElement, "xml-java-binding-config");
        if (bindingConfigElement != null) {
            String bindingClassName = XMLParseUtility.getTextForTagForElement((Node)bindingConfigElement, "binding-class-name");
            String[] getters = XMLParseUtility.getListofTextTagValuesForElement((Node)bindingConfigElement, "binding-class-getter");
            this.servletMatchRule.setXmlJavaBindingConfig(new XMLJavaBindingConfig(bindingClassName, getters));
        }
    }

    protected void setRuleProperties(Element matchRuleElement) {
        Element propertiesElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)matchRuleElement, "properties");
        if (propertiesElement != null) {
            Map<String, String> props = XMLParseUtility.getPropertiesForElementAsMap(propertiesElement, "property");
            this.servletMatchRule.setRuleProperties(NameValuePair.convertMap(props));
        }
    }

    protected void setPOJOSplitConfig(Element matchRuleElement) {
        Element pojoSplitConfigElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)matchRuleElement, "generic-method-config");
        if (pojoSplitConfigElement != null) {
            MethodTransactionSplitConfig splitConfig = new MethodTransactionSplitConfig();
            String className = XMLParseUtility.getTextForTagForElement((Node)pojoSplitConfigElement, "class-name");
            splitConfig.setClassName(className);
            Element methodConfigElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)pojoSplitConfigElement, "method-config");
            String methodName = XMLParseUtility.getTextForTagForElement((Node)methodConfigElement, "name");
            splitConfig.setMethodName(methodName);
            boolean isReturnType = Boolean.parseBoolean(methodConfigElement.getAttribute("return-type"));
            if (!isReturnType) {
                int paramIndex = Integer.parseInt(XMLParseUtility.getTextForTagForElement((Node)methodConfigElement, "param-index"));
                splitConfig.setArgumentIndex(paramIndex);
                splitConfig.setArgumentLength(Integer.parseInt(XMLParseUtility.getTextForTagForElement((Node)methodConfigElement, "param-length")));
            } else {
                splitConfig.setReturnType(true);
            }
            String[] getterList = XMLParseUtility.getListofTextTagValuesForElement((Node)methodConfigElement, "param-getter");
            if (getterList != null && getterList.length != 0) {
                splitConfig.setRecursiveGetter(getterList);
            }
            this.servletMatchRule.setMethodSplitConfig(splitConfig);
        }
    }
}

