/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.transactiondefinition.config.xml.http.servlet;

import com.appdynamics.javax.xml.parsers.ParserConfigurationException;
import com.appdynamics.org.w3c.dom.Element;
import com.appdynamics.org.w3c.dom.Node;
import com.singularity.ee.controller.api.dto.NameValuePair;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.IMatchPointRule;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.MethodTransactionSplitConfig;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.XPathExpressionConfig;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.http.servlet.CookieMatchData;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.http.servlet.HTTPParameterMatchData;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.http.servlet.ParameterMatchType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.http.servlet.ParameterMatchTypeHelper;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.http.servlet.ServletMatchRule;
import com.singularity.ee.transactiondefinition.config.xml.AMatchRuleGenerator;
import com.singularity.ee.transactiondefinition.config.xml.ParserUtil;
import com.singularity.ee.transactiondefinition.config.xml.http.servlet.ServletMatchRuleParser;
import com.singularity.ee.util.enums.EnumHelper;
import com.singularity.ee.util.xml.XMLWriter;
import java.util.HashMap;

public class ServletMatchRuleGenerator
extends AMatchRuleGenerator {
    @Override
    public String getMatchRuleTagName() {
        return "servlet-rule";
    }

    @Override
    public Element addMatchRuleDetail(XMLWriter writer, Element servletRuleElement, IMatchPointRule rule) throws ParserConfigurationException {
        ServletMatchRule servletRule = (ServletMatchRule)rule;
        if (servletRule.getClassName() != null) {
            writer.addTextNode(servletRuleElement, "class-name", ParserUtil.getAttributesFor(servletRule.getClassName()));
        }
        if (servletRule.getServletName() != null) {
            writer.addTextNode(servletRuleElement, "servlet-name", ParserUtil.getAttributesFor(servletRule.getServletName()));
        }
        if (servletRule.getUri() != null) {
            writer.addTextNode(servletRuleElement, "uri", ParserUtil.getAttributesFor(servletRule.getUri()));
        }
        if (servletRule.getHost() != null) {
            writer.addTextNode(servletRuleElement, "host", ParserUtil.getAttributesFor(servletRule.getHost()));
        }
        if (servletRule.getPort() != null) {
            writer.addTextNode(servletRuleElement, "port", ParserUtil.getAttributesFor(servletRule.getPort()));
        }
        if (servletRule.getHttpMethod() != null) {
            writer.addTextNode(servletRuleElement, "http-method", EnumHelper.getName((Enum)servletRule.getHttpMethod(), (Enum)servletRule.getHttpMethod()));
        }
        if (servletRule.getParameters() != null) {
            Element paramsEle = this.getParametersElement(servletRule.getParameters(), writer);
            servletRuleElement.appendChild((Node)paramsEle);
        }
        if (servletRule.getHeaders() != null) {
            Element headersEle = this.getHeadersElement(servletRule.getHeaders(), writer);
            servletRuleElement.appendChild((Node)headersEle);
        }
        if (servletRule.getCookies() != null) {
            Element cookiesElement = this.getCookiesElement(servletRule.getCookies(), writer);
            servletRuleElement.appendChild((Node)cookiesElement);
        }
        if (servletRule.getRuleProperties() != null) {
            Element propsElement = writer.createElement("properties");
            servletRuleElement.appendChild((Node)propsElement);
            for (NameValuePair nameValuePair : servletRule.getRuleProperties()) {
                HashMap<String, String> attribs = new HashMap<String, String>();
                attribs.put("name", nameValuePair.getName());
                attribs.put("value", nameValuePair.getValue());
                writer.addTextNode(propsElement, "property", attribs);
            }
        }
        if (servletRule.getXpathExpressionConfig() != null) {
            Element xPathConfigElement = writer.createElement("x-path-config");
            servletRuleElement.appendChild((Node)xPathConfigElement);
            for (XPathExpressionConfig xPathExpressionConfig : servletRule.getXpathExpressionConfig()) {
                HashMap<String, String> xpathElementAttributes = new HashMap<String, String>();
                xpathElementAttributes.put("value", xPathExpressionConfig.getExpression());
                xpathElementAttributes.put("optional", String.valueOf(xPathExpressionConfig.isOptional()));
                writer.addTextNode(xPathConfigElement, "x-path-expression", xpathElementAttributes);
            }
        }
        if (servletRule.getXmlJavaBindingConfig() != null) {
            Element bindingConfigElement = writer.createElement("xml-java-binding-config");
            servletRuleElement.appendChild((Node)bindingConfigElement);
            writer.addTextNode(bindingConfigElement, "binding-class-name", servletRule.getXmlJavaBindingConfig().getBindingClassName());
            for (String string : servletRule.getXmlJavaBindingConfig().getChainedGetter()) {
                writer.addTextNode(bindingConfigElement, "binding-class-getter", string);
            }
        }
        if (servletRule.getMethodSplitConfig() != null) {
            Element methodSplitConfigElement = writer.createElement("generic-method-config");
            servletRuleElement.appendChild((Node)methodSplitConfigElement);
            writer.addTextNode(methodSplitConfigElement, "class-name", servletRule.getMethodSplitConfig().getClassName());
            Element element = writer.createElement("method-config");
            methodSplitConfigElement.appendChild((Node)element);
            writer.addTextNode(element, "name", servletRule.getMethodSplitConfig().getMethodName());
            if (servletRule.getMethodSplitConfig().isReturnType()) {
                element.setAttribute("return-type", Boolean.TRUE.toString());
            } else {
                writer.addTextNode(element, "name", servletRule.getMethodSplitConfig().getMethodName());
                writer.addTextNode(element, "param-length", String.valueOf(servletRule.getMethodSplitConfig().getArgumentLength()));
                writer.addTextNode(element, "param-index", String.valueOf(servletRule.getMethodSplitConfig().getArgumentIndex()));
            }
            String[] getters = servletRule.getMethodSplitConfig().getRecursiveGetter();
            if (getters != null) {
                for (String getter : getters) {
                    writer.addTextNode(element, "param-getter", getter);
                }
            }
        }
        return servletRuleElement;
    }

    protected Element getParametersElement(HTTPParameterMatchData[] paramMatchData, XMLWriter writer) throws ParserConfigurationException {
        Element parametersElement = writer.createElement("parameters");
        for (HTTPParameterMatchData parameter : paramMatchData) {
            Element paramElement = writer.createElement("parameter");
            paramElement.setAttribute("match-type", ParameterMatchTypeHelper.getStringValue((ParameterMatchType)parameter.getMatchType()));
            writer.addTextNode(paramElement, "name", ParserUtil.getAttributesFor(parameter.getName()));
            if (parameter.getValue() != null) {
                writer.addTextNode(paramElement, "value", ParserUtil.getAttributesFor(parameter.getValue()));
            }
            parametersElement.appendChild((Node)paramElement);
        }
        return parametersElement;
    }

    protected Element getHeadersElement(HTTPParameterMatchData[] paramMatchData, XMLWriter writer) throws ParserConfigurationException {
        Element headersElement = writer.createElement("headers");
        for (HTTPParameterMatchData parameter : paramMatchData) {
            Element paramElement = writer.createElement("header");
            paramElement.setAttribute("match-type", ParameterMatchTypeHelper.getStringValue((ParameterMatchType)parameter.getMatchType()));
            writer.addTextNode(paramElement, "name", ParserUtil.getAttributesFor(parameter.getName()));
            if (parameter.getValue() != null) {
                writer.addTextNode(paramElement, "value", ParserUtil.getAttributesFor(parameter.getValue()));
            }
            headersElement.appendChild((Node)paramElement);
        }
        return headersElement;
    }

    protected Element getCookiesElement(CookieMatchData[] cookieMatchData, XMLWriter writer) throws ParserConfigurationException {
        Element cookiesElement = writer.createElement("cookies");
        for (CookieMatchData cookie : cookieMatchData) {
            Element cookieElement = writer.createElement("cookie");
            cookieElement.setAttribute("match-type", ParameterMatchTypeHelper.getStringValue((ParameterMatchType)cookie.getMatchType()));
            writer.addTextNode(cookieElement, "name", ParserUtil.getAttributesFor(cookie.getName()));
            if (cookie.getValue() != null) {
                writer.addTextNode(cookieElement, "value", ParserUtil.getAttributesFor(cookie.getValue()));
            }
            if (cookie.getPath() != null) {
                writer.addTextNode(cookieElement, "path", ParserUtil.getAttributesFor(cookie.getPath()));
            }
            cookiesElement.appendChild((Node)cookieElement);
        }
        return cookiesElement;
    }

    public static void main(String[] args) throws ParserConfigurationException {
        ServletMatchRule rule = new ServletMatchRule();
        MethodTransactionSplitConfig splitConfig = new MethodTransactionSplitConfig();
        splitConfig.setClassName("com.foo.ClassName");
        splitConfig.setMethodName("methodName");
        splitConfig.setArgumentIndex(2);
        splitConfig.setArgumentLength(5);
        splitConfig.setRecursiveGetter(new String[]{"getabcd", "getbce"});
        rule.setMethodSplitConfig(splitConfig);
        Element el = new ServletMatchRuleGenerator().toXML((IMatchPointRule)rule);
        System.out.println("Reprs ->" + XMLWriter.safeGetStringRepresentationForElement(el));
        ServletMatchRule readFrom = (ServletMatchRule)new ServletMatchRuleParser().parseMatchRule(el);
        Element toEl = new ServletMatchRuleGenerator().toXML((IMatchPointRule)readFrom);
        System.out.println("Reprs1 ->" + XMLWriter.safeGetStringRepresentationForElement(toEl));
        System.out.println("Equals ->" + XMLWriter.safeGetStringRepresentationForElement(el).equals(XMLWriter.safeGetStringRepresentationForElement(toEl)));
    }
}

