/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.transactiondefinition.config.xml.ejb;

import com.appdynamics.org.w3c.dom.Element;
import com.appdynamics.org.w3c.dom.Node;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.IMatchPointRule;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.StringMatch;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.ejb.EJBMatchRule;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.ejb.EJBType;
import com.singularity.ee.transactiondefinition.config.xml.AMatchRuleParser;
import com.singularity.ee.transactiondefinition.config.xml.IMatchPointRuleParser;
import com.singularity.ee.transactiondefinition.config.xml.ParserUtil;
import com.singularity.ee.transactiondefinition.config.xml.ejb.EJBEntryPointTagNames;
import com.singularity.ee.util.xml.XMLParseUtility;
import java.util.List;

public class EJBMatchRuleParser
extends AMatchRuleParser
implements IMatchPointRuleParser,
EJBEntryPointTagNames {
    private EJBMatchRule ejbMatchRule = new EJBMatchRule();

    @Override
    public String getMatchRuleTagName() {
        return "ejb-rule";
    }

    @Override
    public IMatchPointRule parseMatchRule(Element matchRuleElement) {
        this.ejbMatchRule = new EJBMatchRule();
        AMatchRuleParser.parseCommon(matchRuleElement, (IMatchPointRule)this.ejbMatchRule);
        return this.parse(matchRuleElement);
    }

    public EJBMatchRule parse(Element ejbMatchRuleElement) {
        this.setEJBType(ejbMatchRuleElement);
        this.setEJBNameData(ejbMatchRuleElement);
        this.setBusinessIntfData(ejbMatchRuleElement);
        this.setExtendsClassData(ejbMatchRuleElement);
        this.setClassNameData(ejbMatchRuleElement);
        this.setMethodMatchData(ejbMatchRuleElement);
        return this.ejbMatchRule;
    }

    private void setEJBType(Element matchRuleElement) {
        String ejbType = XMLParseUtility.getAttributeMapForElement(matchRuleElement).get("type");
        if (ejbType != null) {
            this.ejbMatchRule.setEjbType(EJBType.valueOf((String)ejbType.toUpperCase()));
        }
    }

    private void setEJBNameData(Element matchRuleElement) {
        Element ejbNameElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)matchRuleElement, "ejb-name");
        if (ejbNameElement != null) {
            StringMatch stringData = ParserUtil.convertNode(ejbNameElement);
            this.ejbMatchRule.setEjbName(stringData);
        }
    }

    private void setBusinessIntfData(Element matchRuleElement) {
        Element businessIntfElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)matchRuleElement, "implements-business-interface");
        if (businessIntfElement != null) {
            StringMatch stringData = ParserUtil.convertNode(businessIntfElement);
            this.ejbMatchRule.setBusinessIntf(stringData);
        }
    }

    private void setExtendsClassData(Element matchRuleElement) {
        Element extendsClassElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)matchRuleElement, "extends-from-class");
        if (extendsClassElement != null) {
            StringMatch stringData = ParserUtil.convertNode(extendsClassElement);
            this.ejbMatchRule.setExtendsFromClass(stringData);
        }
    }

    private void setClassNameData(Element matchRuleElement) {
        Element classNameElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)matchRuleElement, "class-name");
        if (classNameElement != null) {
            StringMatch stringData = ParserUtil.convertNode(classNameElement);
            this.ejbMatchRule.setClassName(stringData);
        }
    }

    private void setMethodMatchData(Element matchRuleElement) {
        List<Element> methodMatchNodes = XMLParseUtility.getListOfDirectSiblingsUnderWithName((Node)matchRuleElement, "match-method");
        StringMatch[] methodMatchData = new StringMatch[methodMatchNodes.size()];
        int i = 0;
        for (Element methodMatchNode : methodMatchNodes) {
            methodMatchData[i++] = ParserUtil.convertNode(XMLParseUtility.getFirstDirectChildUnderWithName((Node)methodMatchNode, "name"));
        }
        if (methodMatchData.length != 0) {
            this.ejbMatchRule.setMethodMatchData(methodMatchData);
        }
    }
}

