/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.transactiondefinition.config.xml.ejb;

import com.appdynamics.javax.xml.parsers.ParserConfigurationException;
import com.appdynamics.org.w3c.dom.Element;
import com.appdynamics.org.w3c.dom.Node;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.IMatchPointRule;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.StringMatch;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.StringMatchType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.ejb.EJBMatchRule;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.ejb.EJBType;
import com.singularity.ee.transactiondefinition.config.xml.AMatchRuleGenerator;
import com.singularity.ee.transactiondefinition.config.xml.ParserUtil;
import com.singularity.ee.transactiondefinition.config.xml.ejb.EJBEntryPointTagNames;
import com.singularity.ee.transactiondefinition.config.xml.ejb.EJBMatchRuleParser;
import com.singularity.ee.util.xml.XMLWriter;

public class EJBMatchRuleGenerator
extends AMatchRuleGenerator
implements EJBEntryPointTagNames {
    @Override
    public Element addMatchRuleDetail(XMLWriter writer, Element ejbRuleElement, IMatchPointRule rule) throws ParserConfigurationException {
        EJBMatchRule ejbMatchRule = (EJBMatchRule)rule;
        if (ejbMatchRule.getEjbType() != null) {
            ejbRuleElement.setAttribute("type", ejbMatchRule.getEjbType().name());
        }
        if (ejbMatchRule.getEjbName() != null) {
            writer.addTextNode(ejbRuleElement, "ejb-name", ParserUtil.getAttributesFor(ejbMatchRule.getEjbName()));
        }
        if (ejbMatchRule.getBusinessIntf() != null) {
            writer.addTextNode(ejbRuleElement, "implements-business-interface", ParserUtil.getAttributesFor(ejbMatchRule.getBusinessIntf()));
        }
        if (ejbMatchRule.getExtendsFromClass() != null) {
            writer.addTextNode(ejbRuleElement, "extends-from-class", ParserUtil.getAttributesFor(ejbMatchRule.getExtendsFromClass()));
        }
        if (ejbMatchRule.getClassName() != null) {
            writer.addTextNode(ejbRuleElement, "class-name", ParserUtil.getAttributesFor(ejbMatchRule.getClassName()));
        }
        if (ejbMatchRule.getMethodMatchData() != null) {
            Element matchMethodElement = writer.createElement("match-method");
            for (StringMatch methodMatch : ejbMatchRule.getMethodMatchData()) {
                writer.addTextNode(matchMethodElement, "name", ParserUtil.getAttributesFor(methodMatch));
            }
            ejbRuleElement.appendChild((Node)matchMethodElement);
        }
        return ejbRuleElement;
    }

    @Override
    public String getMatchRuleTagName() {
        return "ejb-rule";
    }

    public static void main(String[] args) throws Exception {
        EJBMatchRule matchRule = new EJBMatchRule();
        matchRule.setBusinessIntf(new StringMatch(StringMatchType.EQUALS, "com.foo.MyBusinessIntf"));
        matchRule.setClassName(new StringMatch(StringMatchType.EQUALS, "com.foo.MYClass"));
        matchRule.setEjbName(new StringMatch(StringMatchType.EQUALS, "MYEJBName"));
        matchRule.setEjbType(EJBType.SESSION);
        matchRule.setExtendsFromClass(new StringMatch(StringMatchType.EQUALS, "com.foo.BaseClass"));
        StringMatch[] methods = new StringMatch[]{new StringMatch(StringMatchType.EQUALS, "meth1"), new StringMatch(StringMatchType.EQUALS, "meth2")};
        matchRule.setExtendsFromClass(new StringMatch(StringMatchType.EQUALS, "com.foo.BaseClass"));
        matchRule.setMethodMatchData(methods);
        Element ejbElement = new EJBMatchRuleGenerator().toXML((IMatchPointRule)matchRule);
        String xmlFormat = XMLWriter.getStringRepresentationForElement(ejbElement);
        System.out.println(" String REP ->" + xmlFormat);
        StringMatch classMatch = new StringMatch();
        classMatch.setExtendedMatchType("ENDSWITH");
        classMatch.setExtendedMatchPattern("SomeClassName");
        EJBMatchRule matchRule2 = new EJBMatchRule();
        matchRule2.setBusinessIntf(new StringMatch(StringMatchType.EQUALS, "com.foo.MyBusinessIntf"));
        matchRule2.setClassName(classMatch);
        matchRule2.setEjbName(new StringMatch(StringMatchType.EQUALS, "MYEJBName"));
        matchRule2.setEjbType(EJBType.SESSION);
        matchRule2.setExtendsFromClass(new StringMatch(StringMatchType.EQUALS, "com.foo.BaseClass"));
        StringMatch[] methods2 = new StringMatch[]{new StringMatch(StringMatchType.EQUALS, "meth1"), new StringMatch(StringMatchType.EQUALS, "meth2")};
        matchRule2.setExtendsFromClass(new StringMatch(StringMatchType.EQUALS, "com.foo.BaseClass"));
        matchRule2.setMethodMatchData(methods2);
        Element ejbElement2 = new EJBMatchRuleGenerator().toXML((IMatchPointRule)matchRule2);
        String xmlFormat2 = XMLWriter.getStringRepresentationForElement(ejbElement2);
        System.out.println(" String REP Extended ->" + xmlFormat2);
        EJBMatchRule o = new EJBMatchRuleParser().parse(ejbElement2);
        StringMatch classMatchR = o.getClassName();
        System.out.println("classMatchR = " + classMatchR);
        classMatch = new StringMatch();
        classMatch.setExtendedMatchType("GT");
        classMatch.setExtendedMatchPattern("5");
        matchRule2 = new EJBMatchRule();
        matchRule2.setBusinessIntf(new StringMatch(StringMatchType.EQUALS, "com.foo.MyBusinessIntf"));
        matchRule2.setClassName(classMatch);
        matchRule2.setEjbName(new StringMatch(StringMatchType.EQUALS, "MYEJBName"));
        matchRule2.setEjbType(EJBType.SESSION);
        matchRule2.setExtendsFromClass(new StringMatch(StringMatchType.EQUALS, "com.foo.BaseClass"));
        methods2 = new StringMatch[]{new StringMatch(StringMatchType.EQUALS, "meth1"), new StringMatch(StringMatchType.EQUALS, "meth2")};
        matchRule2.setExtendsFromClass(new StringMatch(StringMatchType.EQUALS, "com.foo.BaseClass"));
        matchRule2.setMethodMatchData(methods2);
        ejbElement2 = new EJBMatchRuleGenerator().toXML((IMatchPointRule)matchRule2);
        xmlFormat2 = XMLWriter.getStringRepresentationForElement(ejbElement2);
        System.out.println(" String REP Extended ->" + xmlFormat2);
        o = new EJBMatchRuleParser().parse(ejbElement2);
        classMatchR = o.getClassName();
        System.out.println("classMatchR = " + classMatchR);
    }
}

