/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.transactiondefinition.config.xml;

import com.appdynamics.org.w3c.dom.Element;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.MethodInvocationDataGathererConfig;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.ObjectDataTransformer;
import com.singularity.ee.util.string.StringOperations;

public class ParserUtilHelper {
    public static MethodInvocationDataGathererConfig parseMIDGC(Element element) throws IllegalArgumentException {
        String gathererType = element.getAttribute("type");
        String paramIndex = element.getAttribute("param-index");
        String operation = element.getAttribute("operation");
        String operationConfig = element.getAttribute("operation-config");
        String userDefinedName = element.getAttribute("user-defined-name");
        MethodInvocationDataGathererConfig gathererConfig = new MethodInvocationDataGathererConfig();
        ObjectDataTransformer transformer = new ObjectDataTransformer();
        gathererConfig.setObjectDataTransformer(transformer);
        if (gathererType.equals("instance")) {
            gathererConfig.setGathererType("INVOKED_OBJECT_GATHERER_TYPE");
            if (operation.equals("getter-chain")) {
                transformer.setTransformerType("GETTER_METHODS_OBJECT_DATA_TRANSFORMER_TYPE");
                if (operationConfig.indexOf(".") > 0) {
                    String[] arr = StringOperations.parseSeparatedStringToArray((String)operationConfig, (String)".");
                    transformer.setObjectStateGetterMethodsArr(arr);
                } else {
                    transformer.setObjectStateGetterMethods(new String[]{operationConfig});
                }
            } else if (operation.equals("field-name")) {
                transformer.setTransformerType("FIELD_NAME_OBJECT_DATA_TRANSFORMER_TYPE");
                transformer.setFieldName(operationConfig);
            }
        } else if (gathererType.equals("return-type")) {
            gathererConfig.setGathererType("RETURN_VALUE_GATHERER_TYPE");
            if (operation.equals("getter-chain")) {
                transformer.setTransformerType("GETTER_METHODS_OBJECT_DATA_TRANSFORMER_TYPE");
                if (operationConfig.indexOf(".") > 0) {
                    String[] arr = StringOperations.parseSeparatedStringToArray((String)operationConfig, (String)".");
                    transformer.setObjectStateGetterMethodsArr(arr);
                } else {
                    transformer.setObjectStateGetterMethods(new String[]{operationConfig});
                }
            } else if (operation.equals("field-name")) {
                transformer.setTransformerType("FIELD_NAME_OBJECT_DATA_TRANSFORMER_TYPE");
                transformer.setFieldName(operationConfig);
            }
        } else if (gathererType.equals("user-defined-name")) {
            gathererConfig.setGathererType("USER_DEFINED_NAME_TYPE");
            transformer.setTransformerType("USER_DEFINED_NAME_OBJECT_DATA_TRANSFORMER_TYPE");
            transformer.setUserDefinedName(userDefinedName);
        } else {
            gathererConfig.setGathererType("POSITION_GATHERER_TYPE");
            transformer.setTransformerType("GETTER_METHODS_OBJECT_DATA_TRANSFORMER_TYPE");
            gathererConfig.setPosition(Integer.parseInt(paramIndex));
            if (operationConfig.indexOf(".") > 0) {
                String[] arr = StringOperations.parseSeparatedStringToArray((String)operationConfig, (String)".");
                transformer.setObjectStateGetterMethodsArr(arr);
            } else {
                transformer.setObjectStateGetterMethods(new String[]{operationConfig});
            }
        }
        return gathererConfig;
    }
}

