/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.transactiondefinition.config.xml;

import com.appdynamics.org.w3c.dom.Element;
import com.singularity.ee.controller.api.constants.ExtendedStringMatchTypes;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.StringMatch;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.StringMatchType;
import com.singularity.ee.transactiondefinition.config.xml.boot.TagNames;
import com.singularity.ee.util.enums.EnumHelper;
import com.singularity.ee.util.string.StringOperations;
import com.singularity.ee.util.xml.XMLParseUtility;
import java.util.HashMap;
import java.util.Map;

public class ParserUtil
implements TagNames {
    public static StringMatch convertNode(Element element) throws IllegalArgumentException {
        String filterType = XMLParseUtility.getAttributeMapForElement(element).get("filter-type").toUpperCase();
        String filterValue = XMLParseUtility.getAttributeMapForElement(element).get("filter-value");
        boolean inverse = Boolean.parseBoolean(XMLParseUtility.getAttributeMapForElement(element).get("inverse"));
        String regexGroups = XMLParseUtility.getAttributeMapForElement(element).get("regex-groups");
        StringMatch match = new StringMatch();
        if (!ExtendedStringMatchTypes.isStringMatchType((String)filterType)) {
            match.setMatchType(StringMatchType.EQUALS);
            match.setMatchPattern("_null_appd_null_");
        } else {
            StringMatchType matchType = (StringMatchType)EnumHelper.getEnum(StringMatchType.class, (String)filterType.toUpperCase());
            match.setMatchType(matchType);
            match.setMatchPattern(filterValue);
        }
        match.setExtendedMatchType(filterType);
        match.setExtendedMatchPattern(filterValue);
        match.setInverse(inverse);
        if (regexGroups != null) {
            match.setRegexGroups(StringOperations.parseCommaSeparatedStringAsIntArray((String)regexGroups));
        }
        return match;
    }

    public static Map<String, String> getAttributesFor(StringMatch stringMatchData) {
        HashMap<String, String> mapAttribs = new HashMap<String, String>();
        if (stringMatchData.getExtendedMatchType() == null) {
            String filterType = EnumHelper.getName((Enum)stringMatchData.getMatchType(), (Enum)stringMatchData.getMatchType());
            mapAttribs.put("filter-type", filterType);
            String filterValue = stringMatchData.getMatchPattern();
            mapAttribs.put("filter-value", filterValue);
        } else {
            mapAttribs.put("filter-type", stringMatchData.getExtendedMatchType());
            mapAttribs.put("filter-value", stringMatchData.getExtendedMatchPattern());
            if (stringMatchData.getRegexGroups() != null && stringMatchData.getRegexGroups().length > 0) {
                mapAttribs.put("regex-groups", StringOperations.convertToCommaSeparateString((int[])stringMatchData.getRegexGroups()));
            }
        }
        if (stringMatchData.isInverse()) {
            mapAttribs.put("inverse", Boolean.TRUE.toString());
        }
        return mapAttribs;
    }
}

