/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.transactiondefinition.config.xml;

import com.appdynamics.org.w3c.dom.Element;
import com.appdynamics.org.w3c.dom.Node;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.IMatchPointRule;
import com.singularity.ee.transactiondefinition.config.xml.boot.TagNames;
import com.singularity.ee.util.string.StringOperations;
import com.singularity.ee.util.xml.XMLParseUtility;
import com.singularity.ee.util.xml.XMLWriter;

public abstract class AMatchRuleParser
implements TagNames {
    public static boolean parseEnabledFlag(Element ruleElement) {
        String enabledString = XMLParseUtility.getTextForTagForElement((Node)ruleElement, "enabled");
        return enabledString == null ? true : Boolean.parseBoolean(enabledString);
    }

    public static int parsePriorityFlag(Element ruleElement) {
        String priorityString = XMLParseUtility.getTextForTagForElement((Node)ruleElement, "priority");
        return priorityString == null ? 0 : StringOperations.safeParseInteger((String)priorityString, (int)0);
    }

    public static boolean parseExcluded(Element ruleElement) {
        String excluded = XMLParseUtility.getTextForTagForElement((Node)ruleElement, "excluded");
        return excluded == null ? false : StringOperations.safeParseBoolean((String)excluded, (boolean)false);
    }

    public static void parseCommon(Element ruleElement, IMatchPointRule rule) {
        rule.setEnabled(AMatchRuleParser.parseEnabledFlag(ruleElement));
        rule.setPriority(AMatchRuleParser.parsePriorityFlag(ruleElement));
        rule.setRuleId(AMatchRuleParser.parseRuleId(ruleElement));
        rule.setExcluded(AMatchRuleParser.parseExcluded(ruleElement));
        rule.setOverrideLockdown(AMatchRuleParser.parseOverrideLockdown(ruleElement));
    }

    public static void writeCommon(XMLWriter writer, Element element, IMatchPointRule rule) {
        writer.addTextNode(element, "enabled", String.valueOf(rule.isEnabled()));
        writer.addTextNode(element, "priority", String.valueOf(rule.getPriority()));
        writer.addTextNode(element, "ruleId", String.valueOf(rule.getRuleId()));
    }

    public static String parseRuleId(Element ruleElement) {
        return XMLParseUtility.getTextForTagForElement((Node)ruleElement, "ruleId");
    }

    public static boolean parseOverrideLockdown(Element ruleElement) {
        String overrideLockdown = XMLParseUtility.getTextForTagForElement((Node)ruleElement, "overrideLockdown");
        return StringOperations.safeParseBoolean((String)overrideLockdown, (boolean)false);
    }
}

