/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.transactiondefinition.config;

import com.appdynamics.javax.xml.parsers.ParserConfigurationException;
import com.appdynamics.org.w3c.dom.Element;
import com.appdynamics.org.w3c.dom.Node;
import com.singularity.ee.controller.api.dto.NameValuePair;
import com.singularity.ee.controller.api.dto.NodeResolutionInfo;
import com.singularity.ee.controller.api.dto.transactionmonitor.DiscoveryResolution;
import com.singularity.ee.controller.api.dto.transactionmonitor.DiscoveryResolutionHelper;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.CustomMatchPointDefinition;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.MatchPointDiscoveryConfig;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.TransactionMatchPointConfig;
import com.singularity.ee.rest.RESTTagNames;
import com.singularity.ee.rest.controller.request.MachinesIPPortConfig;
import com.singularity.ee.rest.controller.request.TransactionMatchPointConfigurations;
import com.singularity.ee.transactiondefinition.config.BTRuleConverter;
import com.singularity.ee.transactiondefinition.config.xml.AppAgentConfigTagNames;
import com.singularity.ee.transactiondefinition.config.xml.EntryPointTagNameMapping;
import com.singularity.ee.util.xml.XMLWriteException;
import com.singularity.ee.util.xml.XMLWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TransactionConfigXMLConverter
implements AppAgentConfigTagNames,
RESTTagNames {
    private static TransactionConfigXMLConverter configXMLConverter = new TransactionConfigXMLConverter();
    private static final Map<Character, String> escapeXmlMap = new HashMap<Character, String>(){
        {
            this.put(Character.valueOf('&'), "&amp;");
            this.put(Character.valueOf('<'), "&lt;");
            this.put(Character.valueOf('>'), "&gt;");
            this.put(Character.valueOf('\''), "&apos;");
            this.put(Character.valueOf('\"'), "&quot;");
        }
    };

    public static TransactionConfigXMLConverter getConverter() {
        return configXMLConverter;
    }

    private TransactionConfigXMLConverter() {
    }

    public String getMatchPointConfigurations(TransactionMatchPointConfigurations configurations) {
        StringBuilder sb = new StringBuilder();
        sb.append("<business-transactions>").append("\n");
        sb.append("<").append("time-stamp").append(">").append(configurations.getTimestamp()).append("</").append("time-stamp").append(">").append("\n");
        for (TransactionMatchPointConfig matchPointConfig : configurations.getConfigurations()) {
            String entryPointType = matchPointConfig.getEntryPointTypeString();
            String entryPointTag = EntryPointTagNameMapping.getEntryPointTagName(entryPointType);
            sb.append(this.generateSimpleArgument(entryPointTag, "enabled", String.valueOf(matchPointConfig.isEnabled()), false));
            sb.append("<").append("custom").append(">").append("\n");
            sb.append(this.getBusinessTransactions(matchPointConfig.getCustomMatchPointDefinitionsAsArrayList()));
            sb.append("</").append("custom").append(">").append("\n");
            sb.append(this.getDiscoveryConfig(matchPointConfig.getDiscoveryConfig(), entryPointType));
            sb.append("</").append(entryPointTag).append(">").append("\n");
        }
        sb.append("</business-transactions>").append("\n");
        return sb.toString();
    }

    private String getDiscoveryConfig(MatchPointDiscoveryConfig discoveryConfig, String entryPointType) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.generateSimpleArgument("automatic-transaction-discovery", "enabled", String.valueOf(discoveryConfig.isEnabled()), "resolution", DiscoveryResolutionHelper.getID((DiscoveryResolution)discoveryConfig.getDiscoveryResolution()), false));
        sb.append(BTRuleConverter.getExcludesXML(discoveryConfig.getExcludes(), entryPointType));
        sb.append(this.generateSimpleArgument("naming-scheme", "type", BTRuleConverter.getXMLFriendlyEnumValue(entryPointType, discoveryConfig.getNamingConfig().getNamingSchemeType()), false));
        for (NameValuePair namingSchemeProperty : discoveryConfig.getNamingConfig().getProperties()) {
            sb.append(this.generateSimpleArgument("property", "name", namingSchemeProperty.getName(), "value", namingSchemeProperty.getValue(), true));
        }
        sb.append("</").append("naming-scheme").append(">").append("\n");
        sb.append("</").append("automatic-transaction-discovery").append(">").append("\n");
        return sb.toString();
    }

    private String getBusinessTransactions(List<CustomMatchPointDefinition> customMatchPointDefinitions) {
        StringBuilder sb = new StringBuilder();
        if (customMatchPointDefinitions != null) {
            for (CustomMatchPointDefinition customMatchPointDefinition : customMatchPointDefinitions) {
                sb.append(this.getTransactionStartTag(customMatchPointDefinition)).append("\n");
                sb.append(BTRuleConverter.getMatchRuleXML(customMatchPointDefinition));
                sb.append("\n");
                sb.append("</transaction>").append("\n");
            }
        }
        return sb.toString();
    }

    private String getTransactionStartTag(CustomMatchPointDefinition transaction) {
        StringBuilder sb = new StringBuilder();
        sb.append("<transaction");
        sb.append("\t");
        sb.append("name").append("=").append("\"").append(TransactionConfigXMLConverter.escapeXmlCharacters(transaction.getName())).append("\"");
        sb.append("\t");
        sb.append("id").append("=").append("\"").append(transaction.getId()).append("\"");
        sb.append(">");
        return sb.toString();
    }

    private String generateSimpleArgument(String tagName, String firstKey, String firstValue, String secondKey, String secondValue, boolean closeTag) {
        StringBuilder sb = new StringBuilder();
        String closeTagStr = ">";
        if (closeTag) {
            closeTagStr = "/>";
        }
        sb.append("<").append(tagName).append("\t").append(firstKey).append("=\"").append(firstValue).append("\"").append("\t").append(secondKey).append("=\"").append(secondValue).append("\"").append(closeTagStr).append("\n");
        return sb.toString();
    }

    private String generateSimpleArgument(String tagName, String firstKey, String firstValue, boolean closeTag) {
        StringBuilder sb = new StringBuilder();
        String closeTagStr = ">";
        if (closeTag) {
            closeTagStr = "/>";
        }
        sb.append("<").append(tagName).append("\t").append(firstKey).append("=\"").append(firstValue).append("\"").append(closeTagStr).append("\n");
        return sb.toString();
    }

    public String getBackendTierConfig(MachinesIPPortConfig machinesConfig) throws ParserConfigurationException, XMLWriteException {
        Map nodeResolutionInfoMap = machinesConfig.getComponentIdVsNodeIdVsResolutionInfo();
        XMLWriter writer = new XMLWriter();
        Element registeredBackendsElement = writer.createElement("backend-tiers");
        writer.addTextNode(registeredBackendsElement, "time-stamp", String.valueOf(machinesConfig.getTimestamp()));
        Iterator iterator = nodeResolutionInfoMap.keySet().iterator();
        while (iterator.hasNext()) {
            long tierID = (Long)iterator.next();
            Element backendTierElement = writer.createElement("backend-tier");
            backendTierElement.setAttribute("id", String.valueOf(tierID));
            registeredBackendsElement.appendChild((Node)backendTierElement);
            Iterator iterator2 = ((Map)nodeResolutionInfoMap.get(tierID)).keySet().iterator();
            while (iterator2.hasNext()) {
                long nodeID = (Long)iterator2.next();
                Element nodeElement = writer.createElement("node");
                nodeElement.setAttribute("id", String.valueOf(nodeID));
                backendTierElement.appendChild((Node)nodeElement);
                for (NodeResolutionInfo nodeResolutionInfo : (NodeResolutionInfo[])((Map)nodeResolutionInfoMap.get(tierID)).get(nodeID)) {
                    Element tierIDElement = writer.createElement("tier-id-properties");
                    nodeElement.appendChild((Node)tierIDElement);
                    tierIDElement.setAttribute("type", nodeResolutionInfo.getExitPointType().name());
                    for (NameValuePair nameValuePair : nodeResolutionInfo.getProperties()) {
                        HashMap<String, String> attribs = new HashMap<String, String>();
                        attribs.put("name", nameValuePair.getName());
                        attribs.put("value", nameValuePair.getValue());
                        writer.addTextNode(tierIDElement, "property", attribs);
                    }
                }
            }
        }
        return XMLWriter.getStringRepresentationForElement(registeredBackendsElement);
    }

    public static String escapeXmlCharacters(String value) {
        if (value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            String escapedEquivalent = null;
            for (Map.Entry<Character, String> escapeSet : escapeXmlMap.entrySet()) {
                if (c != escapeSet.getKey().charValue()) continue;
                escapedEquivalent = escapeSet.getValue();
                break;
            }
            if (escapedEquivalent == null) {
                sb.append(c);
                continue;
            }
            sb.append(escapedEquivalent);
        }
        return sb.toString();
    }
}

