/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.transactiondefinition.config;

import com.appdynamics.javax.xml.parsers.ParserConfigurationException;
import com.appdynamics.org.w3c.dom.Element;
import com.appdynamics.org.w3c.dom.Node;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.CustomMatchPointDefinition;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.ExcludeRule;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.IMatchPointRule;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.binary.remoting.BinaryRemotingNamingSchemeTypeHelper;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.dotnet.asp.ASPDotNetNamingSchemeTypeHelper;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.dotnet.jms.DotNetJMSNamingSchemeTypeHelper;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.dotnet.poco.POCONamingSchemeTypeHelper;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.dotnet.remoting.DotNetRemotingNamingSchemeTypeHelper;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.dotnet.wcf.WCFNamingSchemeTypeHelper;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.dotnet.webservices.ASPDotNetWebServiceNamingSchemeTypeHelper;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.ejb.EJBNamingSchemeType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.http.servlet.ServletNamingSchemeTypeHelper;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.jms.JMSNamingSchemeTypeHelper;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.nodeJS.web.NodeJSWebNamingSchemeType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.php.cli.PHPCLINamingSchemeType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.php.drupal.PHPDrupalNamingSchemeType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.php.mvc.PHPMVCNamingSchemeType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.php.normal.PHPNormalNamingSchemeType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.php.webservices.PHPWebServiceNamingSchemeType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.php.wordpress.PHPWordpressNamingSchemeType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.pojo.POJONamingSchemeTypeHelper;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.ruby.rails.RubyRailsNamingSchemeType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.spring.beans.SpringBeanNamingSchemeType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.struts.StrutsActionNamingSchemeType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.webservices.WebServiceNamingSchemeTypeHelper;
import com.singularity.ee.transactiondefinition.config.xml.AMatchRuleParser;
import com.singularity.ee.transactiondefinition.config.xml.IMatchPointRuleParser;
import com.singularity.ee.transactiondefinition.config.xml.binary.remoting.BinaryRemotingMatchRuleGenerator;
import com.singularity.ee.transactiondefinition.config.xml.binary.remoting.BinaryRemotingMatchRuleParser;
import com.singularity.ee.transactiondefinition.config.xml.boot.TagNames;
import com.singularity.ee.transactiondefinition.config.xml.dotnet.asp.ASPDotNetMatchRuleGenerator;
import com.singularity.ee.transactiondefinition.config.xml.dotnet.asp.ASPDotNetMatchRuleParser;
import com.singularity.ee.transactiondefinition.config.xml.dotnet.jms.DotNetMessageMatchRuleGenerator;
import com.singularity.ee.transactiondefinition.config.xml.dotnet.jms.DotNetMessageMatchRuleParser;
import com.singularity.ee.transactiondefinition.config.xml.dotnet.poco.POCOMatchRuleGenerator;
import com.singularity.ee.transactiondefinition.config.xml.dotnet.poco.POCOMatchRuleParser;
import com.singularity.ee.transactiondefinition.config.xml.dotnet.remoting.DotNetRemotingMatchRuleGenerator;
import com.singularity.ee.transactiondefinition.config.xml.dotnet.remoting.DotNetRemotingMatchRuleParser;
import com.singularity.ee.transactiondefinition.config.xml.dotnet.wcf.WCFMatchRuleGenerator;
import com.singularity.ee.transactiondefinition.config.xml.dotnet.wcf.WCFMatchRuleParser;
import com.singularity.ee.transactiondefinition.config.xml.dotnet.webservices.ASPDotNetWebserviceMatchRuleGenerator;
import com.singularity.ee.transactiondefinition.config.xml.dotnet.webservices.ASPDotNetWebserviceMatchRuleParser;
import com.singularity.ee.transactiondefinition.config.xml.ejb.EJBMatchRuleGenerator;
import com.singularity.ee.transactiondefinition.config.xml.ejb.EJBMatchRuleParser;
import com.singularity.ee.transactiondefinition.config.xml.http.servlet.ServletMatchRuleGenerator;
import com.singularity.ee.transactiondefinition.config.xml.http.servlet.ServletMatchRuleParser;
import com.singularity.ee.transactiondefinition.config.xml.jms.MessageMatchRuleGenerator;
import com.singularity.ee.transactiondefinition.config.xml.jms.MessageMatchRuleParser;
import com.singularity.ee.transactiondefinition.config.xml.nodeJS.web.NodeJSWebMatchRuleGenerator;
import com.singularity.ee.transactiondefinition.config.xml.nodeJS.web.NodeJSWebMatchRuleParser;
import com.singularity.ee.transactiondefinition.config.xml.php.cli.PHPCLIMatchRuleParser;
import com.singularity.ee.transactiondefinition.config.xml.php.cli.PHPCLIRuleGenerator;
import com.singularity.ee.transactiondefinition.config.xml.php.drupal.PHPDrupalMatchRuleParser;
import com.singularity.ee.transactiondefinition.config.xml.php.drupal.PHPDrupalRuleGenerator;
import com.singularity.ee.transactiondefinition.config.xml.php.mvc.PHPMVCMatchRuleParser;
import com.singularity.ee.transactiondefinition.config.xml.php.mvc.PHPMVCRuleGenerator;
import com.singularity.ee.transactiondefinition.config.xml.php.web.PHPNormalMatchRuleGenerator;
import com.singularity.ee.transactiondefinition.config.xml.php.web.PHPNormalMatchRuleParser;
import com.singularity.ee.transactiondefinition.config.xml.php.webservices.PHPWebServiceMatchRuleGenerator;
import com.singularity.ee.transactiondefinition.config.xml.php.webservices.PHPWebServiceMatchRuleParser;
import com.singularity.ee.transactiondefinition.config.xml.php.wordpress.PHPWordpressMatchRuleParser;
import com.singularity.ee.transactiondefinition.config.xml.php.wordpress.PHPWordpressRuleGenerator;
import com.singularity.ee.transactiondefinition.config.xml.pojo.POJOMatchRuleGenerator;
import com.singularity.ee.transactiondefinition.config.xml.pojo.POJOMatchRuleParser;
import com.singularity.ee.transactiondefinition.config.xml.ruby.rails.RubyRailsMatchRuleGenerator;
import com.singularity.ee.transactiondefinition.config.xml.ruby.rails.RubyRailsMatchRuleParser;
import com.singularity.ee.transactiondefinition.config.xml.spring.beans.SpringBeanMatchRuleGenerator;
import com.singularity.ee.transactiondefinition.config.xml.spring.beans.SpringBeanMatchRuleParser;
import com.singularity.ee.transactiondefinition.config.xml.struts.StrutsActionRuleGenerator;
import com.singularity.ee.transactiondefinition.config.xml.struts.StrutsActionRuleParser;
import com.singularity.ee.transactiondefinition.config.xml.webservices.WebServiceMatchRuleGenerator;
import com.singularity.ee.transactiondefinition.config.xml.webservices.WebServiceMatchRuleParser;
import com.singularity.ee.util.xml.XMLParseUtility;
import com.singularity.ee.util.xml.XMLWriteException;
import com.singularity.ee.util.xml.XMLWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BTRuleConverter
implements TagNames {
    private static final Map<String, IMatchPointRuleParser> typeVsParser;
    private static final Set<IMatchPointRuleParser> threadSafeParsers;

    private BTRuleConverter() {
    }

    public static IMatchPointRule readFromXMLString(CustomMatchPointDefinition definition, String matchRuleElementString) throws IllegalArgumentException {
        String entryPointType = definition.getEntryPointTypeString();
        return BTRuleConverter.readFromXML(matchRuleElementString, entryPointType);
    }

    public static IMatchPointRule readFromXML(String matchRuleElementString, String entryPointType) {
        Element matchRuleElement;
        try {
            matchRuleElement = XMLParseUtility.getXmlDocumentFromString(matchRuleElementString).getDocumentElement();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error reading match rule for type [" + entryPointType + "] from string " + matchRuleElementString, e);
        }
        return BTRuleConverter.readFromXmlElement(entryPointType, matchRuleElement);
    }

    public static IMatchPointRule readFromXmlElement(String entryPointType, Element matchRuleElement) {
        IMatchPointRuleParser matchRuleParser = BTRuleConverter.getParser(entryPointType);
        return matchRuleParser.parseMatchRule(matchRuleElement);
    }

    public static ExcludeRule[] readExcludesFromXML(String excludesStr, String type) {
        List<Element> excludeRuleElements;
        try {
            excludeRuleElements = XMLParseUtility.getListOfDirectSiblingsForNode(XMLParseUtility.getXmlDocumentFromString(excludesStr).getElementsByTagName("excludes").item(0));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error reading match rule for type [" + type + "] from string " + excludesStr, e);
        }
        IMatchPointRuleParser parser = BTRuleConverter.getParser(type);
        ArrayList<ExcludeRule> excludeRules = new ArrayList<ExcludeRule>(excludeRuleElements.size());
        for (Element element : excludeRuleElements) {
            excludeRules.add(new ExcludeRule(element.getAttribute("name"), parser.parseMatchRule(XMLParseUtility.getListOfDirectSiblingsForNode((Node)element).get(0))));
        }
        return excludeRules.toArray(new ExcludeRule[excludeRules.size()]);
    }

    private static IMatchPointRuleParser getParser(String entryPointType) {
        if (entryPointType == null) {
            throw new IllegalArgumentException("The entry point type is not specified");
        }
        IMatchPointRuleParser parser = typeVsParser.get(entryPointType);
        if (parser == null) {
            throw new IllegalArgumentException("Could not find match rule parser for type [" + entryPointType + "]");
        }
        if (threadSafeParsers.contains(parser)) {
            return parser;
        }
        try {
            return (IMatchPointRuleParser)parser.getClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Could not instantiate parser [" + parser.getClass() + "] for type [" + entryPointType + "]");
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not instantiate parser [" + parser.getClass() + "] for type [" + entryPointType + "]");
        }
    }

    public static String getMatchRuleXML(CustomMatchPointDefinition definition) throws IllegalArgumentException {
        return BTRuleConverter.getMatchRuleAsXML(definition.getMatchPointRule(), definition.getEntryPointTypeString());
    }

    public static String getMatchRuleAsXML(IMatchPointRule matchRule, String type) {
        try {
            Element matchRuleElement = BTRuleConverter.getMatchRuleElement(matchRule, type);
            return XMLWriter.getStringRepresentationForElement(matchRuleElement);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalArgumentException("Error converting match rule to XML for type [" + type, e);
        }
        catch (XMLWriteException e) {
            throw new IllegalArgumentException("Error converting match rule to XML for type [" + type, e.getCause());
        }
    }

    public static String getExcludesXML(ExcludeRule[] excludes, String type) {
        StringBuilder excludesStr = new StringBuilder("<excludes>\n");
        if (excludes != null) {
            for (ExcludeRule matchRule : excludes) {
                excludesStr.append("<exclude\tname=\"");
                excludesStr.append(matchRule.getName());
                excludesStr.append("\">");
                excludesStr.append(BTRuleConverter.getMatchRuleAsXML(matchRule.getMatchPointRule(), type));
                excludesStr.append("</exclude>");
            }
        }
        excludesStr.append("</excludes>");
        return excludesStr.toString();
    }

    private static Element getMatchRuleElement(IMatchPointRule matchRule, String entryPointType) throws ParserConfigurationException, IllegalArgumentException {
        if (entryPointType != null) {
            if (entryPointType.equals("EJB")) {
                return new EJBMatchRuleGenerator().toXML(matchRule);
            }
            if (entryPointType.equals("JMS")) {
                return new MessageMatchRuleGenerator().toXML(matchRule);
            }
            if (entryPointType.equals("POJO")) {
                return new POJOMatchRuleGenerator().toXML(matchRule);
            }
            if (entryPointType.equals("SERVLET")) {
                return new ServletMatchRuleGenerator().toXML(matchRule);
            }
            if (entryPointType.equals("SPRING_BEAN")) {
                return new SpringBeanMatchRuleGenerator().toXML(matchRule);
            }
            if (entryPointType.equals("STRUTS_ACTION")) {
                return new StrutsActionRuleGenerator().toXML(matchRule);
            }
            if (entryPointType.equals("WEB_SERVICE")) {
                return new WebServiceMatchRuleGenerator().toXML(matchRule);
            }
            if (entryPointType.equals("ASP_DOTNET")) {
                return new ASPDotNetMatchRuleGenerator().toXML(matchRule);
            }
            if (entryPointType.equals("DOTNET_REMOTING")) {
                return new DotNetRemotingMatchRuleGenerator().toXML(matchRule);
            }
            if (entryPointType.equals("ASP_DOTNET_WEB_SERVICE")) {
                return new ASPDotNetWebserviceMatchRuleGenerator().toXML(matchRule);
            }
            if (entryPointType.equals("WCF")) {
                return new WCFMatchRuleGenerator().toXML(matchRule);
            }
            if (entryPointType.equals("POCO")) {
                return new POCOMatchRuleGenerator().toXML(matchRule);
            }
            if (entryPointType.equals("DOTNET_JMS")) {
                return new DotNetMessageMatchRuleGenerator().toXML(matchRule);
            }
            if (entryPointType.equals("BINARY_REMOTING")) {
                return new BinaryRemotingMatchRuleGenerator().toXML(matchRule);
            }
            if (entryPointType.equals("PHP_WEB")) {
                return new PHPNormalMatchRuleGenerator().toXML(matchRule);
            }
            if (entryPointType.equals("PHP_MVC")) {
                return new PHPMVCRuleGenerator().toXML(matchRule);
            }
            if (entryPointType.equals("PHP_DRUPAL")) {
                return new PHPDrupalRuleGenerator().toXML(matchRule);
            }
            if (entryPointType.equals("PHP_WORDPRESS")) {
                return new PHPWordpressRuleGenerator().toXML(matchRule);
            }
            if (entryPointType.equals("PHP_CLI")) {
                return new PHPCLIRuleGenerator().toXML(matchRule);
            }
            if (entryPointType.equals("PHP_WEB_SERVICE")) {
                return new PHPWebServiceMatchRuleGenerator().toXML(matchRule);
            }
            if (entryPointType.equals("NODEJS_WEB")) {
                return new NodeJSWebMatchRuleGenerator().toXML(matchRule);
            }
            if (entryPointType.equals("NATIVE") || entryPointType.equals("WEB")) {
                return new ServletMatchRuleGenerator().toXML(matchRule);
            }
            if (entryPointType.equals("PYTHON_WEB")) {
                return new ServletMatchRuleGenerator().toXML(matchRule);
            }
            if (entryPointType.equals("RUBY_WEB")) {
                return new ServletMatchRuleGenerator().toXML(matchRule);
            }
            if (entryPointType.equals("RUBY_RAILS")) {
                return new RubyRailsMatchRuleGenerator().toXML(matchRule);
            }
        }
        throw new IllegalArgumentException("Could not find parser to convert match rule to XML for type [" + entryPointType + "]");
    }

    public static String getXMLFriendlyEnumValue(String entryPointType, String enumString) {
        if (entryPointType != null) {
            if (entryPointType.equals("EJB")) {
                return EJBNamingSchemeType.getIDForScheme((String)enumString);
            }
            if (entryPointType.equals("JMS")) {
                return JMSNamingSchemeTypeHelper.getIDForScheme((String)enumString);
            }
            if (entryPointType.equals("SERVLET")) {
                return ServletNamingSchemeTypeHelper.getIDForScheme((String)enumString);
            }
            if (entryPointType.equals("SPRING_BEAN")) {
                return SpringBeanNamingSchemeType.getIDForScheme((String)enumString);
            }
            if (entryPointType.equals("STRUTS_ACTION")) {
                return StrutsActionNamingSchemeType.getIDForScheme((String)enumString);
            }
            if (entryPointType.equals("WEB_SERVICE")) {
                return WebServiceNamingSchemeTypeHelper.getIDForScheme((String)enumString);
            }
            if (entryPointType.equals("POJO")) {
                return POJONamingSchemeTypeHelper.getIDForScheme((String)enumString);
            }
            if (entryPointType.equals("ASP_DOTNET")) {
                return ASPDotNetNamingSchemeTypeHelper.getIDForScheme((String)enumString);
            }
            if (entryPointType.equals("DOTNET_REMOTING")) {
                return DotNetRemotingNamingSchemeTypeHelper.getIDForScheme((String)enumString);
            }
            if (entryPointType.equals("ASP_DOTNET_WEB_SERVICE")) {
                return ASPDotNetWebServiceNamingSchemeTypeHelper.getIDForScheme((String)enumString);
            }
            if (entryPointType.equals("WCF")) {
                return WCFNamingSchemeTypeHelper.getIDForScheme((String)enumString);
            }
            if (entryPointType.equals("POCO")) {
                return POCONamingSchemeTypeHelper.getIDForScheme((String)enumString);
            }
            if (entryPointType.equals("DOTNET_JMS")) {
                return DotNetJMSNamingSchemeTypeHelper.getIDForScheme((String)enumString);
            }
            if (entryPointType.equals("PHP_WEB")) {
                return PHPNormalNamingSchemeType.getIDForScheme((String)enumString);
            }
            if (entryPointType.equals("PHP_MVC")) {
                return PHPMVCNamingSchemeType.getIDForScheme((String)enumString);
            }
            if (entryPointType.equals("PHP_DRUPAL")) {
                return PHPDrupalNamingSchemeType.getIDForScheme((String)enumString);
            }
            if (entryPointType.equals("PHP_WORDPRESS")) {
                return PHPWordpressNamingSchemeType.getIDForScheme((String)enumString);
            }
            if (entryPointType.equals("PHP_CLI")) {
                return PHPCLINamingSchemeType.getIDForScheme((String)enumString);
            }
            if (entryPointType.equals("PHP_WEB_SERVICE")) {
                return PHPWebServiceNamingSchemeType.getIDForScheme((String)enumString);
            }
            if (entryPointType.equals("NODEJS_WEB")) {
                return NodeJSWebNamingSchemeType.getIDForScheme((String)enumString);
            }
            if (entryPointType.equals("NATIVE") || entryPointType.equals("WEB")) {
                return ServletNamingSchemeTypeHelper.getIDForScheme((String)enumString);
            }
            if (entryPointType.equals("PYTHON_WEB")) {
                return ServletNamingSchemeTypeHelper.getIDForScheme((String)enumString);
            }
            if (entryPointType.equals("RUBY_WEB")) {
                return ServletNamingSchemeTypeHelper.getIDForScheme((String)enumString);
            }
            if (entryPointType.equals("RUBY_RAILS")) {
                return RubyRailsNamingSchemeType.getIDForScheme((String)enumString);
            }
            if (entryPointType.equals("BINARY_REMOTING")) {
                return BinaryRemotingNamingSchemeTypeHelper.getIDForScheme((String)enumString);
            }
        }
        throw new IllegalArgumentException("Could not find Naming Scheme mapping for type [" + entryPointType + "]");
    }

    static {
        threadSafeParsers = new HashSet<IMatchPointRuleParser>();
        HashMap<String, AMatchRuleParser> localTypeVsParser = new HashMap<String, AMatchRuleParser>();
        localTypeVsParser.put("EJB", new EJBMatchRuleParser());
        localTypeVsParser.put("JMS", new MessageMatchRuleParser());
        localTypeVsParser.put("POJO", new POJOMatchRuleParser());
        localTypeVsParser.put("SERVLET", new ServletMatchRuleParser());
        localTypeVsParser.put("SPRING_BEAN", new SpringBeanMatchRuleParser());
        localTypeVsParser.put("STRUTS_ACTION", new StrutsActionRuleParser());
        localTypeVsParser.put("WEB_SERVICE", new WebServiceMatchRuleParser());
        localTypeVsParser.put("ASP_DOTNET", new ASPDotNetMatchRuleParser());
        localTypeVsParser.put("DOTNET_REMOTING", new DotNetRemotingMatchRuleParser());
        localTypeVsParser.put("ASP_DOTNET_WEB_SERVICE", new ASPDotNetWebserviceMatchRuleParser());
        localTypeVsParser.put("WCF", new WCFMatchRuleParser());
        localTypeVsParser.put("POCO", new POCOMatchRuleParser());
        localTypeVsParser.put("DOTNET_JMS", new DotNetMessageMatchRuleParser());
        localTypeVsParser.put("PHP_WEB", new PHPNormalMatchRuleParser());
        localTypeVsParser.put("PHP_MVC", PHPMVCMatchRuleParser.getInstance());
        threadSafeParsers.add(PHPMVCMatchRuleParser.getInstance());
        localTypeVsParser.put("PHP_DRUPAL", PHPDrupalMatchRuleParser.getInstance());
        threadSafeParsers.add(PHPDrupalMatchRuleParser.getInstance());
        localTypeVsParser.put("PHP_WORDPRESS", PHPWordpressMatchRuleParser.getInstance());
        threadSafeParsers.add(PHPWordpressMatchRuleParser.getInstance());
        localTypeVsParser.put("PHP_CLI", PHPCLIMatchRuleParser.getInstance());
        threadSafeParsers.add(PHPCLIMatchRuleParser.getInstance());
        localTypeVsParser.put("PHP_WEB_SERVICE", new PHPWebServiceMatchRuleParser());
        localTypeVsParser.put("NODEJS_WEB", new NodeJSWebMatchRuleParser());
        localTypeVsParser.put("NATIVE", new ServletMatchRuleParser());
        localTypeVsParser.put("WEB", new ServletMatchRuleParser());
        localTypeVsParser.put("PYTHON_WEB", new ServletMatchRuleParser());
        localTypeVsParser.put("RUBY_WEB", new ServletMatchRuleParser());
        localTypeVsParser.put("RUBY_RAILS", RubyRailsMatchRuleParser.getInstance());
        threadSafeParsers.add(RubyRailsMatchRuleParser.getInstance());
        localTypeVsParser.put("BINARY_REMOTING", new BinaryRemotingMatchRuleParser());
        typeVsParser = Collections.unmodifiableMap(localTypeVsParser);
    }
}

