/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.snapshot;

import com.singularity.ee.controller.api.dto.transactionmonitor.CallGraph;
import com.singularity.ee.controller.api.dto.transactionmonitor.CallerStack;
import com.singularity.ee.controller.api.dto.transactionmonitor.ProcessAllocationGraph;
import com.singularity.ee.controller.api.dto.transactionmonitor.ProcessAllocationGraphData;
import com.singularity.ee.controller.api.dto.transactionmonitor.ProcessCallGraph;
import com.singularity.ee.controller.api.dto.transactionmonitor.ProcessCallGraphData;
import com.singularity.ee.controller.api.dto.transactionmonitor.TransactionSnapshotData;
import com.singularity.ee.snapshot.SnapshotTagNames;
import com.singularity.ee.util.compress.CompressedObject;
import com.singularity.ee.util.compress.CompressionUtility;
import com.singularity.ee.util.serialize.LookAheadObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.DataFormatException;

public class SnapshotConverter
extends SnapshotTagNames {
    private static byte[] convertToBinary(TransactionSnapshotData snapshotData) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        try (ObjectOutputStream oos = null;){
            oos = new ObjectOutputStream(baos);
            oos.writeObject(snapshotData.getCallGraph());
            oos.writeObject(snapshotData.getCallerStack());
        }
        return baos.toByteArray();
    }

    public static CompressedObject convertToBinaryAndCompress(TransactionSnapshotData snapshotData) throws IOException {
        byte[] bytes = SnapshotConverter.convertToBinary(snapshotData);
        return CompressionUtility.compressBytes((byte[])bytes);
    }

    private static byte[] convertToBinary(ProcessCallGraphData callGraphData) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        try (ObjectOutputStream oos = null;){
            oos = new ObjectOutputStream(baos);
            oos.writeObject(callGraphData.getCallGraph());
        }
        return baos.toByteArray();
    }

    public static CompressedObject convertToBinaryAndCompress(ProcessCallGraphData callGraphData) throws IOException {
        byte[] bytes = SnapshotConverter.convertToBinary(callGraphData);
        return CompressionUtility.compressBytes((byte[])bytes);
    }

    private static byte[] convertToBinary(ProcessAllocationGraphData allocationGraphData) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        try (ObjectOutputStream oos = null;){
            oos = new ObjectOutputStream(baos);
            oos.writeObject(allocationGraphData.getAllocationGraph());
        }
        return baos.toByteArray();
    }

    public static CompressedObject convertToBinaryAndCompress(ProcessAllocationGraphData allocationGraphData) throws IOException {
        byte[] bytes = SnapshotConverter.convertToBinary(allocationGraphData);
        return CompressionUtility.compressBytes((byte[])bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TransactionSnapshotData inflateAndReadSnapshotFromBinary(TransactionSnapshotData snapshotData) throws DataFormatException, IOException, ClassNotFoundException {
        byte[] snapshotBinary = snapshotData.getCompressedData();
        int originalLength = snapshotData.getOriginalLength();
        CompressedObject compressedSnapshot = new CompressedObject(originalLength, snapshotBinary.length, snapshotBinary);
        byte[] snapshotBytes = CompressionUtility.uncompressBinary((CompressedObject)compressedSnapshot);
        ByteArrayInputStream bais = new ByteArrayInputStream(snapshotBytes);
        try (LookAheadObjectInputStream ois = null;){
            ois = new LookAheadObjectInputStream((InputStream)bais);
            TransactionSnapshotData transactionSnapshotData = new TransactionSnapshotData();
            transactionSnapshotData.setCallGraph((CallGraph)ois.readObject());
            transactionSnapshotData.setCallerStack((CallerStack)ois.readObject());
            TransactionSnapshotData transactionSnapshotData2 = transactionSnapshotData;
            return transactionSnapshotData2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessCallGraphData inflateAndReadProcSnapFromBinary(ProcessCallGraphData callGraphData) throws DataFormatException, IOException, ClassNotFoundException {
        byte[] callGraphBinary = callGraphData.getCompressedData();
        int originalLength = callGraphData.getOriginalLength();
        CompressedObject compressedSnapshot = new CompressedObject(originalLength, callGraphBinary.length, callGraphBinary);
        byte[] callGraphBytes = CompressionUtility.uncompressBinary((CompressedObject)compressedSnapshot);
        ByteArrayInputStream bais = new ByteArrayInputStream(callGraphBytes);
        try (LookAheadObjectInputStream ois = null;){
            ois = new LookAheadObjectInputStream((InputStream)bais);
            ProcessCallGraphData callGraphDataOut = new ProcessCallGraphData();
            callGraphDataOut.setCallGraph((ProcessCallGraph)ois.readObject());
            ProcessCallGraphData processCallGraphData = callGraphDataOut;
            return processCallGraphData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessAllocationGraphData inflateAndReadProcSnapAllocFromBinary(ProcessAllocationGraphData allocationGraphData) throws DataFormatException, IOException, ClassNotFoundException {
        byte[] allocationGraphBinary = allocationGraphData.getCompressedData();
        int originalLength = allocationGraphData.getOriginalLength();
        CompressedObject compressedSnapshot = new CompressedObject(originalLength, allocationGraphBinary.length, allocationGraphBinary);
        byte[] allocationGraphBytes = CompressionUtility.uncompressBinary((CompressedObject)compressedSnapshot);
        ByteArrayInputStream bais = new ByteArrayInputStream(allocationGraphBytes);
        try (ObjectInputStream ois = null;){
            ois = new ObjectInputStream(bais);
            ProcessAllocationGraphData allocationGraphDataOut = new ProcessAllocationGraphData();
            allocationGraphDataOut.setAllocationGraph((ProcessAllocationGraph)ois.readObject());
            ProcessAllocationGraphData processAllocationGraphData = allocationGraphDataOut;
            return processAllocationGraphData;
        }
    }
}

