/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.rest.controller.request.spi.controller;

import com.singularity.ee.events.FindEntryPointEventData;
import com.singularity.ee.rest.RequestReadException;
import com.singularity.ee.rest.ResponseReadException;
import com.singularity.ee.rest.controller.request.ABinaryControllerRequest;
import com.singularity.ee.rest.controller.request.spi.controller.IFindEntryPointEventControllerDataRequest;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.spi.IHttpExecutionResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class FindEntryPointEventDataRequest
extends ABinaryControllerRequest
implements IFindEntryPointEventControllerDataRequest {
    public static final String EVENTS_SUFFIX = "fep-channel";

    public FindEntryPointEventDataRequest(ILogger logger) {
        super(logger);
    }

    public FindEntryPointEventDataRequest(IHttpExecutionResponse response, ILogger logger) throws ResponseReadException {
        super(response, logger);
    }

    public FindEntryPointEventDataRequest(String controllerHost, int port, String machineId, ILogger logger) {
        super(controllerHost, port, machineId, logger);
        this.url = this.url + "/" + EVENTS_SUFFIX;
    }

    public FindEntryPointEventDataRequest(HttpServletRequest servletRequest, ILogger logger) throws RequestReadException {
        super(servletRequest, logger);
    }

    @Override
    protected String getName() {
        return "FIND ENTRY POINT EVENT DATA";
    }

    @Override
    public void addFindEntryPointEvents(List<FindEntryPointEventData> eventData) {
        ArrayList<FindEntryPointEventData> events = (ArrayList<FindEntryPointEventData>)this.payload.get("agent-events");
        if (events == null) {
            events = new ArrayList<FindEntryPointEventData>();
            this.payload.put("agent-events", events);
        }
        events.addAll(eventData);
    }

    @Override
    public List<FindEntryPointEventData> getFindEntryPointEvents() {
        List events = (List)this.payload.get("agent-events");
        if (events == null) {
            return Collections.emptyList();
        }
        return events;
    }

    public void setTimestamp(Date timestamp) {
        this.payload.put("timestamp", Long.valueOf(timestamp.getTime()).toString());
    }
}

