/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.rest.controller.request;

import com.singularity.ee.events.TransientEventData;
import com.singularity.ee.rest.RequestReadException;
import com.singularity.ee.rest.ResponseReadException;
import com.singularity.ee.rest.controller.request.ABinaryControllerRequest;
import com.singularity.ee.rest.controller.request.spi.controller.ITransientEventControllerDataRequest;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.spi.IHttpExecutionResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class TransientEventDataRequest
extends ABinaryControllerRequest
implements ITransientEventControllerDataRequest {
    public static final String TRANSIENT_EVENTS_SUFFIX = "transient-channel";

    public TransientEventDataRequest(ILogger logger) {
        super(logger);
    }

    public TransientEventDataRequest(IHttpExecutionResponse response, ILogger logger) throws ResponseReadException {
        super(response, logger);
    }

    public TransientEventDataRequest(String controllerHost, int port, String machineId, ILogger logger) {
        super(controllerHost, port, machineId, logger);
        this.url = this.url + "/" + TRANSIENT_EVENTS_SUFFIX;
    }

    public TransientEventDataRequest(HttpServletRequest servletRequest, ILogger logger) throws RequestReadException {
        super(servletRequest, logger);
    }

    @Override
    public void setTimestamp(Date timestamp) {
        this.payload.put("timestamp", Long.valueOf(timestamp.getTime()).toString());
    }

    @Override
    public void addEvents(List<TransientEventData> eventData) {
        ArrayList<TransientEventData> events = (ArrayList<TransientEventData>)this.payload.get("agent-events");
        if (events == null) {
            events = new ArrayList<TransientEventData>();
            this.payload.put("agent-events", events);
        }
        events.addAll(eventData);
    }

    @Override
    public void addClosedSessionIds(Set<String> closedSessionIds) {
        HashSet<String> closedSessioIdsExisting = (HashSet<String>)this.payload.get("transient-closed-sessions");
        if (closedSessioIdsExisting == null) {
            closedSessioIdsExisting = new HashSet<String>();
            this.payload.put("transient-closed-sessions", closedSessioIdsExisting);
        }
        closedSessioIdsExisting.addAll(closedSessionIds);
    }

    @Override
    public List<TransientEventData> getEvents() {
        List events = (List)this.payload.get("agent-events");
        if (events == null) {
            return Collections.emptyList();
        }
        return events;
    }

    @Override
    protected String getName() {
        return "Transient Event Data";
    }
}

