/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.rest.controller.request;

import com.appdynamics.javax.xml.parsers.ParserConfigurationException;
import com.appdynamics.org.w3c.dom.Document;
import com.appdynamics.org.xml.sax.SAXException;
import com.singularity.ee.controller.api.dto.ReregisterNodeTicket;
import com.singularity.ee.rest.RESTArgumentType;
import com.singularity.ee.rest.RequestReadException;
import com.singularity.ee.rest.ResponseReadException;
import com.singularity.ee.rest.controller.request.AControllerRequest;
import com.singularity.ee.rest.controller.request.ConnectionBackOffHelper;
import com.singularity.ee.rest.controller.request.spi.ISystemAgentReregistrationRequest;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.xml.XMLParseUtility;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class SystemAgentReregistrationRequest
extends AControllerRequest
implements ISystemAgentReregistrationRequest {
    public static final String SYSTEM_AGENT_REREGISTRATION_SUFFIX = "systemagentreregistration";
    public static final String MOVE_NODE_TICKET = "move-node-ticket";
    private static final String SYSTEM_AGENT_REREGISTRATION = "system-agent-reregistration";
    private static final ConnectionBackOffHelper backOffHelper = new ConnectionBackOffHelper();
    private String agentId;

    public SystemAgentReregistrationRequest(String controllerHost, int controllerPort, String machineID, ILogger logger) {
        this(controllerHost, controllerPort, machineID, null, logger);
    }

    public SystemAgentReregistrationRequest(String controllerHost, int controllerPort, String machineID, String agentID, ILogger logger) {
        super(controllerHost, controllerPort, machineID, logger);
        this.agentId = agentID;
        String urlAppend = "/systemagentreregistration";
        if (agentID != null) {
            urlAppend = urlAppend + "/" + agentID;
        }
        this.url = this.url + urlAppend;
    }

    public SystemAgentReregistrationRequest(HttpServletRequest request, ILogger logger) throws RequestReadException {
        super(request, logger);
        int suffixIndex = this.url.indexOf(SYSTEM_AGENT_REREGISTRATION_SUFFIX);
        int indexOfSlashIfAgentIdKnown = suffixIndex + SYSTEM_AGENT_REREGISTRATION_SUFFIX.length();
        int startIndexOfAgentIdIfKnown = indexOfSlashIfAgentIdKnown + 1;
        if (startIndexOfAgentIdIfKnown < this.url.length() && this.url.charAt(indexOfSlashIfAgentIdKnown) == '/') {
            this.agentId = this.url.substring(startIndexOfAgentIdIfKnown);
        }
    }

    public SystemAgentReregistrationRequest(ILogger logger) {
        super(logger);
    }

    public SystemAgentReregistrationRequest(String responseBody, ILogger logger) throws ResponseReadException {
        super(logger);
        if (responseBody != null) {
            try {
                Document xmlDoc = XMLParseUtility.getXmlDocumentFromString(responseBody);
                this.addArgumentsFromXMLPayload(xmlDoc);
                this.createSimpleArguments();
                this.checkForError();
            }
            catch (SAXException e) {
                logger.warn("Error parsing XML reading REST response ", (Throwable)e);
                throw new ResponseReadException(e);
            }
            catch (IOException e) {
                logger.warn("Error reading REST response ", (Throwable)e);
                throw new ResponseReadException(e);
            }
            catch (ParserConfigurationException e) {
                logger.warn("Error reading REST response, Parser configuration error ", (Throwable)e);
                throw new ResponseReadException(e);
            }
        }
    }

    private void checkForError() throws ResponseReadException {
        int responseCode;
        String responseCodeStr = this.getValueForArgument("response-code");
        if (null != responseCodeStr && (responseCode = Integer.parseInt(responseCodeStr)) == 1) {
            String executionOutput = this.getValueForArgument("execution-output");
            throw new ResponseReadException(executionOutput);
        }
    }

    @Override
    public boolean isSystemAgentReregistrationRequested() {
        return Boolean.parseBoolean(this.getValueForArgument(SYSTEM_AGENT_REREGISTRATION));
    }

    public void setReregisterSystemAgent() {
        this.addArgumentWithNoAttributes(SYSTEM_AGENT_REREGISTRATION, Boolean.TRUE.toString());
    }

    @Override
    public ReregisterNodeTicket getReregisterNodeTicket() {
        Map<String, String> objectStateMap = this.getNameValueAttributeMapForArgument(MOVE_NODE_TICKET, RESTArgumentType.STRING);
        if (objectStateMap == null) {
            return null;
        }
        return new ReregisterNodeTicket(objectStateMap);
    }

    public void setReregisterNodeTicket(ReregisterNodeTicket ticket) {
        this.setReregisterSystemAgent();
        this.addArgumentWithAttributesOnly(MOVE_NODE_TICKET, ticket.toObjectStateMap());
    }

    @Override
    protected boolean isRequestOverConnectionLimit(int errorCount) {
        return backOffHelper.isRequestOverConnectionLimit(errorCount);
    }

    public String getAgentId() {
        return this.agentId;
    }
}

