/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.rest.controller.request;

import com.appdynamics.javax.xml.parsers.ParserConfigurationException;
import com.appdynamics.org.w3c.dom.Document;
import com.appdynamics.org.w3c.dom.Element;
import com.appdynamics.org.w3c.dom.Node;
import com.appdynamics.org.xml.sax.SAXException;
import com.google.common.base.Optional;
import com.singularity.ee.agent.AgentAccountInfoStore;
import com.singularity.ee.agent.util.SystemInfo;
import com.singularity.ee.controller.api.constants.AgentType;
import com.singularity.ee.controller.api.dto.ReregisterNodeTicket;
import com.singularity.ee.rest.RESTArgument;
import com.singularity.ee.rest.RESTArgumentType;
import com.singularity.ee.rest.RequestReadException;
import com.singularity.ee.rest.ResponseReadException;
import com.singularity.ee.rest.controller.request.AControllerRequest;
import com.singularity.ee.rest.controller.request.ConnectionBackOffHelper;
import com.singularity.ee.rest.controller.request.spi.ISystemAgentRegistrationRequest;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.xml.EscapeUtility;
import com.singularity.ee.util.xml.XMLParseUtility;
import com.singularity.ee.util.xml.XMLWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class SystemAgentRegistrationRequest
extends AControllerRequest
implements ISystemAgentRegistrationRequest {
    public static final String MACHINE_ID = "machine-id";
    public static final String SYSTEM_AGENT_INIT = "system-agent-init";
    public static final String MACHINE_INFO = "machine-info";
    public static final String UNIQUE_HOST_IDENTIFIER = "unique-host-identifier";
    private static final String APPLICATION_NAME_LIST = "application-name-list";
    private static final String APPLICATION_NAME = "application-name";
    private static final String APPLICATION_NAME_LIST_ARGUMENT = "application-name-list-argument";
    private static final String APPLICATION_COMPONENT_NAME = "application-component-name";
    private static final String APPLICATION_COMPONENT_NODE_NAME = "application-component-node-name";
    private static final String APPLICATION_COMPONENT_NODE_ID = "application-component-node-id";
    private static final String CONTROLLER_VERSION = "controller-version";
    public static final String INSTALL_DIR = "install-dir";
    public static final String JVM_INFO = "jvm-info";
    private static final String AGENT_VERSION = "agent-version";
    private static final String AGENT_PROPERTIES = "agent-properties";
    private static final String FORCE_AGENT_REGISTRATION = "force-agent-registration";
    private static final String NUMBER_OF_VCPUS = "number-of-vcpus";
    private static final String UNKNOWN_MACHINE_ID = "UNKNOWN_MACHINE_ID";
    private static final ConnectionBackOffHelper backOffHelper = new ConnectionBackOffHelper();
    public static final String SYSTEM_AGENT_REGISTRATION_SUFFIX = "systemagentregistration";

    public SystemAgentRegistrationRequest(String controllerHost, int controllerPort, ILogger logger) {
        super(controllerHost, controllerPort, UNKNOWN_MACHINE_ID, logger);
        this.url = this.url + "/" + SYSTEM_AGENT_REGISTRATION_SUFFIX;
        this.setAgentType(AgentType.MACHINE_AGENT);
    }

    public SystemAgentRegistrationRequest(HttpServletRequest request, ILogger logger) throws RequestReadException {
        super(request, logger);
        String singleName = this.getValueForArgument(APPLICATION_NAME);
        if (this.getXMLValueForArgument(APPLICATION_NAME_LIST) != null && singleName != null) {
            String msg = "Both single application name and name list specified (single name: " + singleName + ")";
            logger.warn(msg);
            throw new RequestReadException(msg);
        }
    }

    public SystemAgentRegistrationRequest(ILogger logger) {
        super(logger);
    }

    public SystemAgentRegistrationRequest(String responseBody, ILogger logger) throws ResponseReadException {
        super(logger);
        if (responseBody != null) {
            try {
                Document xmlDoc = XMLParseUtility.getXmlDocumentFromString(responseBody);
                this.addArgumentsFromXMLPayload(xmlDoc);
                this.createSimpleArguments();
                this.checkForError();
            }
            catch (SAXException e) {
                logger.warn("Error parsing XML reading REST response ", (Throwable)e);
                throw new ResponseReadException(e);
            }
            catch (IOException e) {
                logger.warn("Error reading REST response ", (Throwable)e);
                throw new ResponseReadException(e);
            }
            catch (ParserConfigurationException e) {
                logger.warn("Error reading REST response, Parser configuration error ", (Throwable)e);
                throw new ResponseReadException(e);
            }
        }
        this.registerAccountKey();
    }

    private void registerAccountKey() {
        SystemAgentRegistrationRequest.registerAccountKey(AgentAccountInfoStore.getInstance().getAccountName(), this.getValueForArgument("account-key"));
    }

    @Override
    public void setHostIdentifyingInfo(String hostInfo) {
        this.addArgumentWithNoAttributes(UNIQUE_HOST_IDENTIFIER, hostInfo);
        this.addArgumentWithNoAttributes(MACHINE_INFO, SystemInfo.getMachineInfo());
        this.addArgumentWithNoAttributes(JVM_INFO, SystemInfo.getVMInfo());
        this.addArgumentWithNoAttributes(SYSTEM_AGENT_INIT, Boolean.TRUE.toString());
    }

    @Override
    public String getMachineInfo() {
        return this.getValueForArgument(MACHINE_INFO);
    }

    public String getControllerVersionInfo() {
        return this.getValueForArgument(CONTROLLER_VERSION);
    }

    @Override
    public String getJVMInfo() {
        return this.getValueForArgument(JVM_INFO);
    }

    @Override
    public String getUniqueHostInformation() {
        return this.getValueForArgument(UNIQUE_HOST_IDENTIFIER);
    }

    @Override
    public String getInstallDir() {
        return this.getValueForArgument(INSTALL_DIR);
    }

    @Override
    public void setInstallDir(String installDir) {
        this.addArgumentWithNoAttributes(INSTALL_DIR, installDir);
    }

    @Override
    public void setAgentVersion(String version) {
        this.addArgumentWithNoAttributes(AGENT_VERSION, version);
    }

    @Override
    public String getAgentVersion() {
        return this.getValueForArgument(AGENT_VERSION);
    }

    @Override
    public void setAgentProperties(Map<String, String> agentProperties) {
        this.addArgumentWithAttributesOnly(AGENT_PROPERTIES, agentProperties);
    }

    @Override
    public void setControllerVersion(String controllerVersion) {
        if (controllerVersion != null) {
            this.addArgumentWithNoAttributes(CONTROLLER_VERSION, controllerVersion);
        }
    }

    @Override
    public Map<String, String> getAgentProperties() {
        List<RESTArgument> requestArguments = this.getRequestArguments();
        for (RESTArgument requestArgument : requestArguments) {
            if (!AGENT_PROPERTIES.equals(requestArgument.getName())) continue;
            return requestArgument.getAttributes();
        }
        return null;
    }

    @Override
    @Deprecated
    public String getApplicationName() {
        if (null != this.getXMLValueForArgument(APPLICATION_NAME_LIST)) {
            throw new RuntimeException("Request for single app name on a request which specifies a list...");
        }
        return this.getValueForArgument(APPLICATION_NAME);
    }

    @Override
    public void setApplicationName(String applicationName) {
        this.addArgumentWithNoAttributes(APPLICATION_NAME, applicationName);
    }

    @Override
    public Set<String> getSetOfApplicationNames() {
        String singleAppName = this.getValueForArgument(APPLICATION_NAME);
        if (singleAppName != null) {
            return Collections.singleton(singleAppName);
        }
        LinkedHashSet<String> applicationNames = new LinkedHashSet<String>();
        Element nameListArgumentElement = this.getXMLValueForArgument(APPLICATION_NAME_LIST_ARGUMENT);
        if (nameListArgumentElement != null) {
            Element nameListElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)nameListArgumentElement, APPLICATION_NAME_LIST);
            for (Element singleNameElement : XMLParseUtility.getListOfDirectSiblingsUnderWithName((Node)nameListElement, APPLICATION_NAME)) {
                String appName = singleNameElement.getAttribute("name");
                if (appName == null) continue;
                applicationNames.add(appName);
            }
        }
        return applicationNames;
    }

    @Override
    public void setSetOfApplicationNames(Set<String> applicationNames) throws ParserConfigurationException {
        XMLWriter writer = new XMLWriter();
        Element applicationNamesElement = writer.createElement(APPLICATION_NAME_LIST);
        for (String appName : applicationNames) {
            Element singleNameElement = writer.createElement(APPLICATION_NAME);
            singleNameElement.setAttribute("name", EscapeUtility.XML.escape(appName));
            applicationNamesElement.appendChild((Node)singleNameElement);
        }
        this.addXMLArgument(APPLICATION_NAME_LIST_ARGUMENT, applicationNamesElement);
    }

    @Override
    public String getApplicationComponentName() {
        return this.getValueForArgument(APPLICATION_COMPONENT_NAME);
    }

    @Override
    public void setApplicationComponentName(String applicationComponentName) {
        this.addArgumentWithNoAttributes(APPLICATION_COMPONENT_NAME, applicationComponentName);
    }

    @Override
    public String getApplicationComponentNodeName() {
        return this.getValueForArgument(APPLICATION_COMPONENT_NODE_NAME);
    }

    @Override
    public void setApplicationComponentNodeName(String applicationComponentNodeName) {
        this.addArgumentWithNoAttributes(APPLICATION_COMPONENT_NODE_NAME, applicationComponentNodeName);
    }

    @Override
    public AgentType getAgentType() {
        String agentTypeString = this.getValueForArgument("agent-type");
        if (agentTypeString == null) {
            return AgentType.MACHINE_AGENT;
        }
        return AgentType.valueOf((String)agentTypeString);
    }

    @Override
    public void setAgentType(AgentType agentType) {
        for (RESTArgument argument : this.requestArguments) {
            if (!"agent-type".equals(argument.getName())) continue;
            this.requestArguments.remove(argument);
            break;
        }
        this.addArgumentWithNoAttributes("agent-type", agentType.name());
    }

    @Override
    public boolean isForceAgentRegistrationConfig() {
        return Boolean.parseBoolean(this.getValueForArgument(FORCE_AGENT_REGISTRATION));
    }

    @Override
    public void setForceAgentRegistrationConfig(boolean force) {
        this.addArgumentWithNoAttributes(FORCE_AGENT_REGISTRATION, String.valueOf(force));
    }

    @Override
    public ReregisterNodeTicket getReregisterNodeTicket() {
        Map<String, String> objectStateMap = this.getNameValueAttributeMapForArgument("move-node-ticket", RESTArgumentType.STRING);
        if (objectStateMap == null) {
            return null;
        }
        return new ReregisterNodeTicket(objectStateMap);
    }

    @Override
    public void setReregisterNodeTicket(ReregisterNodeTicket ticket) {
        this.addArgumentWithAttributesOnly("move-node-ticket", ticket.toObjectStateMap());
    }

    @Override
    public boolean hasInitializationInfo() {
        return Boolean.parseBoolean(this.getValueForArgument(SYSTEM_AGENT_INIT));
    }

    @Override
    public String getMachineID() {
        return this.getValueForArgument(MACHINE_ID);
    }

    @Override
    public String getControllerVersion() {
        return this.getValueForArgument(CONTROLLER_VERSION);
    }

    @Override
    public String getNodeID() {
        return this.getValueForArgument(APPLICATION_COMPONENT_NODE_ID);
    }

    public Optional<Integer> getNumberOfVirtualCpus() {
        String numberOfVCpus = this.getValueForArgument(NUMBER_OF_VCPUS);
        if (numberOfVCpus != null) {
            try {
                return Optional.of((Object)Integer.parseInt(numberOfVCpus));
            }
            catch (Exception e) {
                this.logger.debug("Exception during parsing", (Throwable)e);
            }
        }
        return Optional.absent();
    }

    @Override
    public void initializeSystemAgent(String machineID, String nodeID) {
        this.addArgumentWithNoAttributes(MACHINE_ID, machineID);
        this.addArgumentWithNoAttributes(SYSTEM_AGENT_INIT, Boolean.TRUE.toString());
        if (null != nodeID) {
            this.addArgumentWithNoAttributes(APPLICATION_COMPONENT_NODE_ID, nodeID);
        }
    }

    private void checkForError() throws ResponseReadException {
        int responseCode;
        String responseCodeStr = this.getValueForArgument("response-code");
        if (null != responseCodeStr && (responseCode = Integer.parseInt(responseCodeStr)) == 1) {
            String executionOutput = this.getValueForArgument("execution-output");
            throw new ResponseReadException(executionOutput);
        }
    }

    @Override
    protected boolean isRequestOverConnectionLimit(int errorCount) {
        return backOffHelper.isRequestOverConnectionLimit(errorCount);
    }
}

