/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.rest.controller.request;

import com.singularity.ee.controller.api.constants.AppAgentOperationStatus;
import com.singularity.ee.controller.api.dto.SystemAgentOperation;
import com.singularity.ee.rest.RequestReadException;
import com.singularity.ee.rest.ResponseReadException;
import com.singularity.ee.rest.controller.request.AgentPollingConfigurationRequest;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.spi.IHttpExecutionResponse;
import com.singularity.ee.util.string.StringOperations;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class SystemAgentPollingConfigurationRequest
extends AgentPollingConfigurationRequest {
    private static final String SYSTEM_AGENT_OPERATIONS = "system-agent-operations";
    private static final String SYSTEM_AGENT_OPERATIONS_STATUS = "system-agent-operations-status";
    public static String SYSTEM_AGENT_POLLING_REQUEST_SUFFIX = "systemagentpolling";
    public static final String STOP_AGENT_REPORTING = "stop-agent-from-reporting";
    private static final List<SystemAgentOperation> EMPTY_LIST = Collections.emptyList();

    public SystemAgentPollingConfigurationRequest(String controllerHost, int port, String machineId, ILogger logger) {
        super(controllerHost, port, machineId, logger);
        this.url = this.url + "/" + SYSTEM_AGENT_POLLING_REQUEST_SUFFIX;
    }

    public SystemAgentPollingConfigurationRequest(IHttpExecutionResponse response, ILogger logger) throws ResponseReadException {
        super(response, logger);
    }

    public SystemAgentPollingConfigurationRequest(HttpServletRequest servletRequest, ILogger logger) throws RequestReadException {
        super(servletRequest, logger);
    }

    public SystemAgentPollingConfigurationRequest(ILogger logger) throws RequestReadException {
        super(logger);
    }

    @Override
    protected String getName() {
        return "System Agent Config";
    }

    public void setSystemAgentOperations(List<SystemAgentOperation> operations) {
        this.setPayloadParam(SYSTEM_AGENT_OPERATIONS, operations);
    }

    public List<SystemAgentOperation> getSystemAgentOperations() {
        Object list = this.getPayloadParam(SYSTEM_AGENT_OPERATIONS);
        if (list != null) {
            return (List)list;
        }
        return EMPTY_LIST;
    }

    public void setSystemAgentOperationStatus(Map<Long, AppAgentOperationStatus> operationStatusMap) {
        this.setPayloadParam(SYSTEM_AGENT_OPERATIONS_STATUS, operationStatusMap);
    }

    public Map<Long, AppAgentOperationStatus> getSystemAgentOperationStatus() {
        return (Map)this.getPayloadParam(SYSTEM_AGENT_OPERATIONS_STATUS);
    }

    public void setStopAgentFromReporting(boolean stopReporting) {
        this.setPayloadParam(STOP_AGENT_REPORTING, stopReporting);
    }

    public boolean isStopAgentFromReporting() {
        return this.getPayloadParamBooleanValue(STOP_AGENT_REPORTING, false);
    }

    private String getPayloadParamStringValue(String paramName) {
        Object payloadParamVal = this.getPayloadParam(paramName);
        return String.valueOf(payloadParamVal);
    }

    private Object getPayloadParam(String paramName) {
        return this.payload.get(paramName);
    }

    private void setPayloadParam(String paramName, Object value) {
        this.payload.put(paramName, value);
    }

    private boolean getPayloadParamBooleanValue(String paramName, boolean defaultValue) {
        String paramStringValue = this.getPayloadParamStringValue(paramName);
        return StringOperations.safeParseBoolean((String)paramStringValue, (boolean)defaultValue);
    }
}

