/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.rest.controller.request;

import com.singularity.ee.controller.api.dto.transactionmonitor.ProcessSnapshotData;
import com.singularity.ee.controller.api.dto.transactionmonitor.RequestSegmentData;
import com.singularity.ee.controller.api.dto.transactionmonitor.TransactionSnapshot;
import com.singularity.ee.rest.RequestReadException;
import com.singularity.ee.rest.ResponseReadException;
import com.singularity.ee.rest.controller.request.ABinaryControllerRequest;
import com.singularity.ee.rest.controller.request.ConnectionBackOffHelper;
import com.singularity.ee.rest.controller.request.spi.controller.ISnapshotControllerDataRequest;
import com.singularity.ee.util.javaspecific.atomic.AgentAtomicIntegerImpl;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.spi.IAgentAtomicInteger;
import com.singularity.ee.util.spi.IHttpExecutionResponse;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class SnapshotDataBinaryRequest
extends ABinaryControllerRequest
implements ISnapshotControllerDataRequest {
    private static final int SNAPSHOT_DATA_MAX_CALLS_BETWEEN_ATTEMPTS = 5;
    private static final int SNAPSHOT_DATA_ERROR_LIMIT = 5;
    private static final ConnectionBackOffHelper backOffHelper = new ConnectionBackOffHelper(5, 5);
    private static final IAgentAtomicInteger snapshotDataErrorCount = new AgentAtomicIntegerImpl(0);

    public SnapshotDataBinaryRequest(ILogger logger, String controllerHost, int port, String machineId) {
        super(controllerHost, port, machineId, logger);
        this.url = this.url + "/" + "snapshotdata";
    }

    public SnapshotDataBinaryRequest(HttpServletRequest request, ILogger logger) throws RequestReadException {
        super(request, logger);
    }

    public SnapshotDataBinaryRequest(IHttpExecutionResponse response, ILogger logger) throws ResponseReadException {
        super(response, logger);
    }

    public SnapshotDataBinaryRequest(ILogger logger) {
        super(logger);
    }

    @Deprecated
    public Collection<TransactionSnapshot> getSnapshots() {
        return (Collection)this.payload.get("TransactionSnapshot");
    }

    @Deprecated
    public void setSnapshots(List<TransactionSnapshot> snapshots) {
        this.payload.put("TransactionSnapshot", snapshots);
    }

    @Override
    public void setRequestSegmentData(Collection<RequestSegmentData> segments) {
        this.payload.put("request-segment-data", segments);
    }

    @Override
    public Collection<RequestSegmentData> getRequestSegmentData() {
        return (Collection)this.payload.get("request-segment-data");
    }

    @Override
    public void setProcessSnapshotData(Collection<ProcessSnapshotData> snapshots) {
        this.payload.put("process-snapshot-data", snapshots);
    }

    @Override
    public Collection<ProcessSnapshotData> getProcessSnapshotData() {
        return (Collection)this.payload.get("process-snapshot-data");
    }

    @Override
    public void setMachineSnapshotData(byte[] snapshots) {
    }

    @Override
    public byte[] getMachineSnapshotData() {
        return null;
    }

    @Override
    protected String getName() {
        return "Snapshot Data";
    }

    @Override
    protected boolean isRequestOverConnectionLimit(int errorCount) {
        return backOffHelper.isRequestOverConnectionLimit(errorCount);
    }

    @Override
    protected void incrementErrorCount() {
        snapshotDataErrorCount.incrementAndGet();
    }

    @Override
    protected void clearErrorCount() {
        snapshotDataErrorCount.set(0);
    }

    @Override
    protected int getErrorCount() {
        return snapshotDataErrorCount.get();
    }
}

